/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteServerConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationChildBuilder;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<RemoteStoreConfiguration, RemoteStoreConfigurationBuilder>
implements RemoteStoreConfigurationChildBuilder<RemoteStoreConfigurationBuilder> {
    private static final Log log = (Log)LogFactory.getLog(RemoteStoreConfigurationBuilder.class, Log.class);
    private final ExecutorFactoryConfigurationBuilder asyncExecutorFactory;
    private final ConnectionPoolConfigurationBuilder connectionPool;
    private List<RemoteServerConfigurationBuilder> servers = new ArrayList<RemoteServerConfigurationBuilder>();

    public RemoteStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, RemoteStoreConfiguration.attributeDefinitionSet());
        this.asyncExecutorFactory = new ExecutorFactoryConfigurationBuilder(this);
        this.connectionPool = new ConnectionPoolConfigurationBuilder(this);
    }

    public RemoteStoreConfigurationBuilder self() {
        return this;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    @Override
    public RemoteStoreConfigurationBuilder balancingStrategy(String balancingStrategy) {
        this.attributes.attribute(RemoteStoreConfiguration.BALANCING_STRATEGY).set((Object)balancingStrategy);
        return this;
    }

    @Override
    public ConnectionPoolConfigurationBuilder connectionPool() {
        return this.connectionPool;
    }

    @Override
    public RemoteStoreConfigurationBuilder connectionTimeout(long connectionTimeout) {
        this.attributes.attribute(RemoteStoreConfiguration.CONNECTION_TIMEOUT).set((Object)connectionTimeout);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder forceReturnValues(boolean forceReturnValues) {
        this.attributes.attribute(RemoteStoreConfiguration.FORCE_RETURN_VALUES).set((Object)forceReturnValues);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder hotRodWrapping(boolean hotRodWrapping) {
        this.attributes.attribute(RemoteStoreConfiguration.HOTROD_WRAPPING).set((Object)hotRodWrapping);
        this.rawValues(true);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder keySizeEstimate(int keySizeEstimate) {
        this.attributes.attribute(RemoteStoreConfiguration.KEY_SIZE_ESTIMATE).set((Object)keySizeEstimate);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder marshaller(String marshaller) {
        this.attributes.attribute(RemoteStoreConfiguration.MARSHALLER).set((Object)marshaller);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder marshaller(Class<? extends Marshaller> marshaller) {
        this.marshaller(marshaller.getName());
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder protocolVersion(String protocolVersion) {
        this.attributes.attribute(RemoteStoreConfiguration.PROTOCOL_VERSION).set((Object)protocolVersion);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder rawValues(boolean rawValues) {
        this.attributes.attribute(RemoteStoreConfiguration.RAW_VALUES).set((Object)rawValues);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder remoteCacheName(String remoteCacheName) {
        this.attributes.attribute(RemoteStoreConfiguration.REMOTE_CACHE_NAME).set((Object)remoteCacheName);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder socketTimeout(long socketTimeout) {
        this.attributes.attribute(RemoteStoreConfiguration.SOCKET_TIMEOUT).set((Object)socketTimeout);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.attributes.attribute(RemoteStoreConfiguration.TCP_NO_DELAY).set((Object)tcpNoDelay);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder transportFactory(String transportFactory) {
        this.attributes.attribute(RemoteStoreConfiguration.TRANSPORT_FACTORY).set((Object)transportFactory);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder transportFactory(Class<? extends TransportFactory> transportFactory) {
        this.transportFactory(transportFactory.getName());
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder valueSizeEstimate(int valueSizeEstimate) {
        this.attributes.attribute(RemoteStoreConfiguration.VALUE_SIZE_ESTIMATE).set((Object)valueSizeEstimate);
        return this;
    }

    @Override
    public RemoteServerConfigurationBuilder addServer() {
        RemoteServerConfigurationBuilder builder = new RemoteServerConfigurationBuilder(this);
        this.servers.add(builder);
        return builder;
    }

    public RemoteStoreConfiguration create() {
        ArrayList<RemoteServerConfiguration> remoteServers = new ArrayList<RemoteServerConfiguration>();
        for (RemoteServerConfigurationBuilder server : this.servers) {
            remoteServers.add(server.create());
        }
        this.attributes.attribute(RemoteStoreConfiguration.SERVERS).set(remoteServers);
        return new RemoteStoreConfiguration(this.attributes.protect(), this.async.create(), this.singletonStore.create(), this.asyncExecutorFactory.create(), this.connectionPool.create());
    }

    public RemoteStoreConfigurationBuilder read(RemoteStoreConfiguration template) {
        super.read((StoreConfiguration)template);
        this.asyncExecutorFactory.read(template.asyncExecutorFactory());
        this.connectionPool.read(template.connectionPool());
        for (RemoteServerConfiguration server : template.servers()) {
            this.addServer().host(server.host()).port(server.port());
        }
        return this;
    }

    public void validate() {
        this.connectionPool.validate();
        this.asyncExecutorFactory.validate();
        for (RemoteServerConfigurationBuilder server : this.servers) {
            server.validate();
        }
        if (((Boolean)this.attributes.attribute(RemoteStoreConfiguration.HOTROD_WRAPPING).get()).booleanValue() && this.attributes.attribute(RemoteStoreConfiguration.MARSHALLER).get() != null) {
            throw log.cannotEnableHotRodWrapping();
        }
    }
}

