/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.lucene.ExternalizerIds;
import org.infinispan.lucene.impl.Operation;

public class DeleteOperation
implements Operation {
    private String element;

    DeleteOperation(String element) {
        this.element = element;
    }

    @Override
    public void apply(Set<String> target) {
        target.remove(this.element);
    }

    String getElement() {
        return this.element;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteOperation that = (DeleteOperation)o;
        return this.element.equals(that.element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public static class DeleteElementOperationExternalizer
    implements AdvancedExternalizer<DeleteOperation> {
        public Set<Class<? extends DeleteOperation>> getTypeClasses() {
            return Collections.singleton(DeleteOperation.class);
        }

        public void writeObject(ObjectOutput output, DeleteOperation deleteOperation) throws IOException {
            output.writeUTF(deleteOperation.element);
        }

        public DeleteOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new DeleteOperation(input.readUTF());
        }

        public Integer getId() {
            return ExternalizerIds.FILE_LIST_DELTA_DEL;
        }
    }
}

