/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.remote.LocalFlagAffectedRpcCommand;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredGetAllCommand<K, V>
extends LocalFlagAffectedRpcCommand {
    public static final byte COMMAND_ID = 46;
    private static final Log log = LogFactory.getLog(ClusteredGetAllCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private List<?> keys;
    private GlobalTransaction gtx;
    private InvocationContextFactory icf;
    private CommandsFactory commandsFactory;
    private InterceptorChain invoker;
    private TransactionTable txTable;
    private InternalEntryFactory entryFactory;
    private Equivalence<? super K> keyEquivalence;

    ClusteredGetAllCommand() {
        super(null, 0L);
    }

    public ClusteredGetAllCommand(ByteString cacheName) {
        super(cacheName, 0L);
    }

    public ClusteredGetAllCommand(ByteString cacheName, List<?> keys, long flags, GlobalTransaction gtx, Equivalence<? super K> keyEquivalence) {
        super(cacheName, flags);
        this.keys = keys;
        this.gtx = gtx;
        this.keyEquivalence = keyEquivalence;
    }

    public void init(InvocationContextFactory icf, CommandsFactory commandsFactory, InternalEntryFactory entryFactory, InterceptorChain interceptorChain, TransactionTable txTable, Equivalence<? super K> keyEquivalence) {
        this.icf = icf;
        this.commandsFactory = commandsFactory;
        this.invoker = interceptorChain;
        this.txTable = txTable;
        this.entryFactory = entryFactory;
        this.keyEquivalence = keyEquivalence;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        this.acquireLocksIfNeeded();
        GetAllCommand command = this.commandsFactory.buildGetAllCommand(this.keys, this.getFlagsBitSet(), true);
        InvocationContext invocationContext = this.icf.createRemoteInvocationContextForCommand(command, this.getOrigin());
        Map map = (Map)this.invoker.invoke(invocationContext, command);
        if (trace) {
            log.trace("Found: " + map);
        }
        if (map == null) {
            return null;
        }
        ArrayList<ImmortalCacheValue> values = new ArrayList<ImmortalCacheValue>(this.keys.size());
        for (Object key : this.keys) {
            if (map.containsKey(key)) {
                CacheEntry entry = (CacheEntry)map.get(key);
                InternalCacheValue value = entry instanceof InternalCacheEntry ? ((InternalCacheEntry)entry).toInternalCacheValue() : (entry != null ? this.entryFactory.createValue(entry) : new ImmortalCacheValue(null));
                values.add((ImmortalCacheValue)value);
                continue;
            }
            values.add(null);
        }
        return values;
    }

    private void acquireLocksIfNeeded() throws Throwable {
        if (this.hasFlag(Flag.FORCE_WRITE_LOCK)) {
            LockControlCommand lockControlCommand = this.commandsFactory.buildLockControlCommand(this.keys, this.getFlagsBitSet(), this.gtx);
            lockControlCommand.init(this.invoker, this.icf, this.txTable);
            lockControlCommand.perform(null);
        }
    }

    public List<?> getKeys() {
        return this.keys;
    }

    @Override
    public byte getCommandId() {
        return 46;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        output.writeLong(Flag.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        output.writeObject(this.gtx);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.keys = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
        this.setFlagsBitSet(input.readLong());
        this.gtx = (GlobalTransaction)input.readObject();
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ClusteredGetAllCommand{");
        sb.append("keys=").append(this.keys);
        sb.append(", flags=").append(this.printFlags());
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusteredGetAllCommand other = (ClusteredGetAllCommand)obj;
        if (this.gtx == null ? other.gtx != null : !this.gtx.equals(other.gtx)) {
            return false;
        }
        if (this.keyEquivalence == null ? other.keyEquivalence != null : !this.keyEquivalence.equals(other.keyEquivalence)) {
            return false;
        }
        return !(this.keys == null ? other.keys != null : !this.keys.equals(other.keys));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.gtx == null ? 0 : this.gtx.hashCode());
        result = 31 * result + (this.keyEquivalence == null ? 0 : this.keyEquivalence.hashCode());
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        return result;
    }
}

