/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.serializing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.CachedThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ScheduledThreadPoolExecutorFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.CustomInterceptorsConfiguration;
import org.infinispan.configuration.cache.CustomStoreConfiguration;
import org.infinispan.configuration.cache.DataContainerConfiguration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.configuration.serializing.ConfigurationHolder;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.configuration.serializing.SerializeUtils;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class Serializer
extends AbstractStoreSerializer
implements ConfigurationSerializer<ConfigurationHolder> {
    private static final Log log = LogFactory.getLog(Serializer.class);
    static final Map<String, Element> THREAD_POOL_FACTORIES = CollectionFactory.makeConcurrentMap();

    @Override
    public void serialize(XMLExtendedStreamWriter writer, ConfigurationHolder holder) throws XMLStreamException {
        this.writeJGroups(writer, holder.getGlobalConfiguration());
        this.writeThreads(writer, holder.getGlobalConfiguration());
        this.writeCacheContainer(writer, holder);
    }

    private void writeJGroups(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration) throws XMLStreamException {
        if (globalConfiguration.isClustered()) {
            writer.writeStartElement(Element.JGROUPS);
            writer.writeAttribute(Attribute.TRANSPORT, globalConfiguration.transport().transport().getClass().getName());
            TypedProperties properties = globalConfiguration.transport().properties();
            for (String property : properties.stringPropertyNames()) {
                if (!property.startsWith("stack-")) continue;
                String stackName = properties.getProperty(property);
                String path = properties.getProperty("stackFilePath-" + stackName);
                writer.writeStartElement(Element.STACK_FILE);
                writer.writeAttribute(Attribute.NAME, stackName);
                writer.writeAttribute(Attribute.PATH, path);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeThreads(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration) throws XMLStreamException {
        writer.writeStartElement(Element.THREADS);
        ConcurrentMap threadFactories = CollectionFactory.makeConcurrentMap();
        for (ThreadPoolConfiguration threadPoolConfiguration : Arrays.asList(globalConfiguration.evictionThreadPool(), globalConfiguration.listenerThreadPool(), globalConfiguration.persistenceThreadPool(), globalConfiguration.replicationQueueThreadPool(), globalConfiguration.stateTransferThreadPool())) {
            Object threadFactory = threadPoolConfiguration.threadFactory();
            if (!(threadFactory instanceof DefaultThreadFactory)) continue;
            DefaultThreadFactory tf = (DefaultThreadFactory)threadFactory;
            threadFactories.putIfAbsent(tf.getName(), tf);
        }
        for (DefaultThreadFactory threadFactory : threadFactories.values()) {
            this.writeThreadFactory(writer, threadFactory);
        }
        for (ThreadPoolConfiguration threadPoolConfiguration : Arrays.asList(globalConfiguration.evictionThreadPool(), globalConfiguration.listenerThreadPool(), globalConfiguration.persistenceThreadPool(), globalConfiguration.replicationQueueThreadPool(), globalConfiguration.stateTransferThreadPool())) {
            Object threadPoolFactory = threadPoolConfiguration.threadPoolFactory();
            if (threadPoolFactory == null) continue;
            writer.writeStartElement(THREAD_POOL_FACTORIES.get(threadPoolFactory.getClass().getName()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeThreadFactory(XMLExtendedStreamWriter writer, DefaultThreadFactory threadFactory) throws XMLStreamException {
        writer.writeStartElement(Element.THREAD_FACTORY);
        SerializeUtils.writeOptional(writer, Attribute.NAME, threadFactory.getName());
        SerializeUtils.writeOptional(writer, Attribute.GROUP_NAME, threadFactory.threadGroup().getName());
        SerializeUtils.writeOptional(writer, Attribute.THREAD_NAME_PATTERN, threadFactory.threadNamePattern());
        writer.writeAttribute(Attribute.PRIORITY, Integer.toString(threadFactory.initialPriority()));
        writer.writeEndElement();
    }

    private void writeCacheContainer(XMLExtendedStreamWriter writer, ConfigurationHolder holder) throws XMLStreamException {
        writer.writeStartElement(Element.CACHE_CONTAINER);
        GlobalConfiguration globalConfiguration = holder.getGlobalConfiguration();
        writer.writeAttribute(Attribute.NAME, globalConfiguration.globalJmxStatistics().cacheManagerName());
        globalConfiguration.globalJmxStatistics().attributes().write((XMLStreamWriter)writer, GlobalJmxStatisticsConfiguration.ENABLED, (Enum)Attribute.STATISTICS);
        this.writeTransport(writer, globalConfiguration);
        this.writeSerialization(writer, globalConfiguration);
        this.writeJMX(writer, globalConfiguration);
        for (Map.Entry<String, Configuration> configuration : holder.getConfigurations().entrySet()) {
            Configuration config = configuration.getValue();
            switch (config.clustering().cacheMode()) {
                case LOCAL: {
                    this.writeLocalCache(writer, configuration.getKey(), config);
                    break;
                }
                case DIST_ASYNC: 
                case DIST_SYNC: {
                    this.writeDistributedCache(writer, configuration.getKey(), config);
                    break;
                }
                case INVALIDATION_ASYNC: 
                case INVALIDATION_SYNC: {
                    this.writeInvalidationCache(writer, configuration.getKey(), config);
                    break;
                }
                case REPL_ASYNC: 
                case REPL_SYNC: {
                    this.writeReplicatedCache(writer, configuration.getKey(), config);
                    break;
                }
            }
        }
    }

    private void writeReplicatedCache(XMLExtendedStreamWriter writer, String name, Configuration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.REPLICATED_CACHE);
        this.writeCommonClusteredCacheAttributes(writer, configuration);
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        writer.writeEndElement();
    }

    private void writeDistributedCache(XMLExtendedStreamWriter writer, String name, Configuration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.DISTRIBUTED_CACHE);
        this.writeCommonClusteredCacheAttributes(writer, configuration);
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        writer.writeEndElement();
    }

    private void writeInvalidationCache(XMLExtendedStreamWriter writer, String name, Configuration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.INVALIDATION_CACHE);
        this.writeCommonClusteredCacheAttributes(writer, configuration);
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        writer.writeEndElement();
    }

    private void writeLocalCache(XMLExtendedStreamWriter writer, String name, Configuration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.LOCAL_CACHE);
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        writer.writeEndElement();
    }

    private void writeTransport(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration) throws XMLStreamException {
        TransportConfiguration transport = globalConfiguration.transport();
        AttributeSet attributes = transport.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.TRANSPORT);
            attributes.write((XMLStreamWriter)writer, TransportConfiguration.CLUSTER_NAME, (Enum)Attribute.CLUSTER);
            attributes.write((XMLStreamWriter)writer, TransportConfiguration.MACHINE_ID, (Enum)Attribute.MACHINE_ID);
            attributes.write((XMLStreamWriter)writer, TransportConfiguration.RACK_ID, (Enum)Attribute.RACK_ID);
            attributes.write((XMLStreamWriter)writer, TransportConfiguration.SITE_ID, (Enum)Attribute.SITE);
            writer.writeEndElement();
        }
    }

    private void writeSerialization(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration) throws XMLStreamException {
        SerializationConfiguration serialization = globalConfiguration.serialization();
        AttributeSet attributes = serialization.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.SERIALIZATION);
            attributes.write((XMLStreamWriter)writer, SerializationConfiguration.MARSHALLER, (Enum)Attribute.MARSHALLER_CLASS);
            attributes.write((XMLStreamWriter)writer, SerializationConfiguration.VERSION, (Enum)Attribute.VERSION);
            this.writeAdvancedSerializers(writer, globalConfiguration);
            writer.writeEndElement();
        }
    }

    private void writeAdvancedSerializers(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration) throws XMLStreamException {
        Map<Integer, AdvancedExternalizer<?>> externalizers = globalConfiguration.serialization().advancedExternalizers();
        for (Map.Entry<Integer, AdvancedExternalizer<?>> externalizer : externalizers.entrySet()) {
            writer.writeStartElement(Element.ADVANCED_EXTERNALIZER);
            writer.writeAttribute(Attribute.ID, Integer.toString(externalizer.getKey()));
            writer.writeAttribute(Attribute.CLASS, externalizer.getValue().getClass().getName());
            writer.writeEndElement();
        }
    }

    private void writeJMX(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration) throws XMLStreamException {
        GlobalJmxStatisticsConfiguration globalJmxStatistics = globalConfiguration.globalJmxStatistics();
        AttributeSet attributes = globalJmxStatistics.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.JMX);
            attributes.write((XMLStreamWriter)writer, GlobalJmxStatisticsConfiguration.ALLOW_DUPLICATE_DOMAINS, (Enum)Attribute.ALLOW_DUPLICATE_DOMAINS);
            attributes.write((XMLStreamWriter)writer, GlobalJmxStatisticsConfiguration.MBEAN_SERVER_LOOKUP, (Enum)Attribute.MBEAN_SERVER_LOOKUP);
            SerializeUtils.writeTypedProperties(writer, (TypedProperties)attributes.attribute(GlobalJmxStatisticsConfiguration.PROPERTIES).get());
            writer.writeEndElement();
        }
    }

    private void writeTransaction(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        TransactionConfiguration transaction = configuration.transaction();
        AttributeSet attributes = transaction.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.TRANSACTION);
            Parser.TransactionMode mode = Parser.TransactionMode.fromConfiguration(transaction.transactionMode(), !transaction.useSynchronization(), transaction.recovery().enabled(), configuration.invocationBatching().enabled());
            writer.writeAttribute(Attribute.MODE, mode.toString());
            attributes.write((XMLStreamWriter)writer, TransactionConfiguration.AUTO_COMMIT, (Enum)Attribute.AUTO_COMMIT);
            attributes.write((XMLStreamWriter)writer, TransactionConfiguration.CACHE_STOP_TIMEOUT, (Enum)Attribute.STOP_TIMEOUT);
            attributes.write((XMLStreamWriter)writer, TransactionConfiguration.COMPLETED_TX_TIMEOUT, (Enum)Attribute.COMPLETED_TX_TIMEOUT);
            attributes.write((XMLStreamWriter)writer, TransactionConfiguration.LOCKING_MODE, (Enum)Attribute.LOCKING);
            attributes.write((XMLStreamWriter)writer, TransactionConfiguration.REAPER_WAKE_UP_INTERVAL, (Enum)Attribute.REAPER_WAKE_UP_INTERVAL);
            attributes.write((XMLStreamWriter)writer, TransactionConfiguration.TRANSACTION_PROTOCOL, (Enum)Attribute.TRANSACTION_PROTOCOL);
            writer.writeEndElement();
        }
    }

    private void writeSecurity(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        AuthorizationConfiguration authorization = configuration.security().authorization();
        AttributeSet attributes = authorization.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.SECURITY);
            writer.writeStartElement(Element.AUTHORIZATION);
            attributes.write((XMLStreamWriter)writer, AuthorizationConfiguration.ENABLED, (Enum)Attribute.ENABLED);
            this.writeCollectionAsAttribute(writer, Attribute.ROLES, authorization.roles());
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeCommonClusteredCacheAttributes(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        ClusteringConfiguration clustering = configuration.clustering();
        writer.writeAttribute(Attribute.MODE, clustering.cacheMode().isSynchronous() ? "SYNC" : "ASYNC");
        AttributeSet syncAttributes = clustering.sync().attributes();
        syncAttributes.write((XMLStreamWriter)writer, ClusteringConfiguration.REMOTE_TIMEOUT, (Enum)Attribute.REMOTE_TIMEOUT);
    }

    private void writeCommonCacheAttributesElements(XMLExtendedStreamWriter writer, String name, Configuration configuration) throws XMLStreamException {
        writer.writeAttribute(Attribute.NAME, name);
        configuration.jmxStatistics().attributes().write((XMLStreamWriter)writer, JMXStatisticsConfiguration.ENABLED, (Enum)Attribute.STATISTICS);
        this.writeBackup(writer, configuration);
        configuration.sites().backupFor().attributes().write((XMLStreamWriter)writer, Element.BACKUP_FOR.getLocalName());
        configuration.locking().attributes().write((XMLStreamWriter)writer, Element.LOCKING.getLocalName());
        this.writeTransaction(writer, configuration);
        configuration.eviction().attributes().write((XMLStreamWriter)writer, Element.EVICTION.getLocalName());
        configuration.expiration().attributes().write((XMLStreamWriter)writer, Element.EXPIRATION.getLocalName());
        configuration.compatibility().attributes().write((XMLStreamWriter)writer, Element.COMPATIBILITY.getLocalName());
        configuration.storeAsBinary().attributes().write((XMLStreamWriter)writer, Element.STORE_AS_BINARY.getLocalName());
        this.writePersistence(writer, configuration);
        configuration.versioning().attributes().write((XMLStreamWriter)writer, Element.VERSIONING.getLocalName());
        this.writeDataContainer(writer, configuration);
        this.writeIndexing(writer, configuration);
        this.writeCustomInterceptors(writer, configuration);
        this.writeSecurity(writer, configuration);
        if (configuration.clustering().cacheMode().needsStateTransfer()) {
            configuration.clustering().stateTransfer().attributes().write((XMLStreamWriter)writer, Element.STATE_TRANSFER.getLocalName());
        }
        configuration.clustering().partitionHandling().attributes().write((XMLStreamWriter)writer, Element.PARTITION_HANDLING.getLocalName());
    }

    private void writeCustomInterceptors(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        CustomInterceptorsConfiguration customInterceptors = configuration.customInterceptors();
        if (customInterceptors.interceptors().size() > 0) {
            writer.writeStartElement(Element.CUSTOM_INTERCEPTORS);
            for (InterceptorConfiguration interceptor : customInterceptors.interceptors()) {
                AttributeSet attributes = interceptor.attributes();
                writer.writeStartElement(Element.INTERCEPTOR);
                attributes.write((XMLStreamWriter)writer, InterceptorConfiguration.INTERCEPTOR_CLASS, (Enum)Attribute.CLASS);
                attributes.write((XMLStreamWriter)writer, InterceptorConfiguration.AFTER, (Enum)Attribute.AFTER);
                attributes.write((XMLStreamWriter)writer, InterceptorConfiguration.BEFORE, (Enum)Attribute.BEFORE);
                attributes.write((XMLStreamWriter)writer, InterceptorConfiguration.INDEX, (Enum)Attribute.INDEX);
                attributes.write((XMLStreamWriter)writer, InterceptorConfiguration.POSITION, (Enum)Attribute.POSITION);
                SerializeUtils.writeTypedProperties(writer, interceptor.properties());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeDataContainer(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        DataContainerConfiguration dataContainer = configuration.dataContainer();
        AttributeSet attributes = dataContainer.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.DATA_CONTAINER);
            attributes.write((XMLStreamWriter)writer, DataContainerConfiguration.DATA_CONTAINER, (Enum)Attribute.CLASS);
            attributes.write((XMLStreamWriter)writer, DataContainerConfiguration.KEY_EQUIVALENCE, (Enum)Attribute.KEY_EQUIVALENCE);
            attributes.write((XMLStreamWriter)writer, DataContainerConfiguration.VALUE_EQUIVALENCE, (Enum)Attribute.VALUE_EQUIVALENCE);
            SerializeUtils.writeTypedProperties(writer, dataContainer.properties());
            writer.writeEndElement();
        }
    }

    private void writeIndexing(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        IndexingConfiguration indexing = configuration.indexing();
        AttributeSet attributes = indexing.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.INDEXING);
            attributes.write((XMLStreamWriter)writer, IndexingConfiguration.INDEX, (Enum)Attribute.INDEX);
            attributes.write((XMLStreamWriter)writer, IndexingConfiguration.AUTO_CONFIG, (Enum)Attribute.AUTO_CONFIG);
            SerializeUtils.writeTypedProperties(writer, indexing.properties());
            writer.writeEndElement();
        }
    }

    private void writePersistence(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        PersistenceConfiguration persistence = configuration.persistence();
        AttributeSet attributes = persistence.attributes();
        if (attributes.isModified() || persistence.stores().size() > 0) {
            writer.writeStartElement(Element.PERSISTENCE);
            attributes.write((XMLStreamWriter)writer, PersistenceConfiguration.PASSIVATION, (Enum)Attribute.PASSIVATION);
            for (StoreConfiguration store : persistence.stores()) {
                this.writeStore(writer, store);
            }
            writer.writeEndElement();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeStore(XMLExtendedStreamWriter writer, StoreConfiguration configuration) throws XMLStreamException {
        if (configuration instanceof SingleFileStoreConfiguration) {
            this.writeFileStore(writer, (SingleFileStoreConfiguration)configuration);
            return;
        }
        if (configuration instanceof ClusterLoaderConfiguration) {
            this.writeClusterLoader(writer, (ClusterLoaderConfiguration)configuration);
            return;
        }
        if (configuration instanceof CustomStoreConfiguration) {
            this.writeCustomStore(writer, (CustomStoreConfiguration)configuration);
            return;
        }
        SerializedWith serializedWith = configuration.getClass().getAnnotation(SerializedWith.class);
        if (serializedWith == null) {
            ConfigurationFor configurationFor = configuration.getClass().getAnnotation(ConfigurationFor.class);
            if (!(configuration instanceof AbstractStoreConfiguration) || configurationFor == null) throw new UnsupportedOperationException("Cannot serialize store configuration " + configuration.getClass().getName());
            writer.writeComment("A serializer for the store configuration class " + configuration.getClass().getName() + " was not found. Using custom store mode");
            AbstractStoreConfiguration asc = (AbstractStoreConfiguration)configuration;
            this.writeGenericStore(writer, configurationFor.value().getName(), asc);
            return;
        }
        try {
            ConfigurationSerializer serializer = (ConfigurationSerializer)Util.getInstanceStrict(serializedWith.value());
            serializer.serialize(writer, configuration);
            return;
        }
        catch (Exception e) {
            log.unableToInstantiateSerializer(serializedWith.value());
        }
    }

    private void writeBackup(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        SitesConfiguration sites = configuration.sites();
        if (sites.allBackups().size() > 0) {
            writer.writeStartElement(Element.BACKUPS);
            for (BackupConfiguration backup : sites.allBackups()) {
                AttributeSet takeOffline;
                writer.writeStartElement(Element.BACKUP);
                AttributeSet attributes = backup.attributes();
                attributes.write((XMLStreamWriter)writer, BackupConfiguration.ENABLED, (Enum)Attribute.ENABLED);
                attributes.write((XMLStreamWriter)writer, BackupConfiguration.SITE, (Enum)Attribute.SITE);
                attributes.write((XMLStreamWriter)writer, BackupConfiguration.STRATEGY, (Enum)Attribute.STRATEGY);
                attributes.write((XMLStreamWriter)writer, BackupConfiguration.REPLICATION_TIMEOUT, (Enum)Attribute.TIMEOUT);
                attributes.write((XMLStreamWriter)writer, BackupConfiguration.USE_TWO_PHASE_COMMIT, (Enum)Attribute.USE_TWO_PHASE_COMMIT);
                attributes.write((XMLStreamWriter)writer, BackupConfiguration.FAILURE_POLICY_CLASS, (Enum)Attribute.FAILURE_POLICY_CLASS);
                AttributeSet stateTransfer = backup.stateTransfer().attributes();
                if (stateTransfer.isModified()) {
                    writer.writeStartElement(Element.STATE_TRANSFER);
                    stateTransfer.write((XMLStreamWriter)writer, XSiteStateTransferConfiguration.CHUNK_SIZE, (Enum)Attribute.CHUNK_SIZE);
                    stateTransfer.write((XMLStreamWriter)writer, XSiteStateTransferConfiguration.MAX_RETRIES, (Enum)Attribute.MAX_RETRIES);
                    stateTransfer.write((XMLStreamWriter)writer, XSiteStateTransferConfiguration.TIMEOUT, (Enum)Attribute.TIMEOUT);
                    stateTransfer.write((XMLStreamWriter)writer, XSiteStateTransferConfiguration.WAIT_TIME, (Enum)Attribute.WAIT_TIME);
                    writer.writeEndElement();
                }
                if ((takeOffline = backup.takeOffline().attributes()).isModified()) {
                    writer.writeStartElement(Element.TAKE_OFFLINE);
                    takeOffline.write((XMLStreamWriter)writer, TakeOfflineConfiguration.AFTER_FAILURES, (Enum)Attribute.TAKE_BACKUP_OFFLINE_AFTER_FAILURES);
                    takeOffline.write((XMLStreamWriter)writer, TakeOfflineConfiguration.MIN_TIME_TO_WAIT, (Enum)Attribute.TAKE_BACKUP_OFFLINE_MIN_WAIT);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeCollectionAsAttribute(XMLExtendedStreamWriter writer, Attribute attribute, Collection<String> collection) throws XMLStreamException {
        if (!collection.isEmpty()) {
            StringBuilder result = new StringBuilder();
            boolean separator = false;
            for (String item : collection) {
                if (separator) {
                    result.append(" ");
                }
                result.append(item);
                separator = true;
            }
            writer.writeAttribute(attribute, result.toString());
        }
    }

    private void writeFileStore(XMLExtendedStreamWriter writer, SingleFileStoreConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.FILE_STORE);
        configuration.attributes().write((XMLStreamWriter)writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }

    private void writeClusterLoader(XMLExtendedStreamWriter writer, ClusterLoaderConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.CLUSTER_LOADER);
        configuration.attributes().write((XMLStreamWriter)writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }

    private void writeCustomStore(XMLExtendedStreamWriter writer, CustomStoreConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.STORE);
        configuration.attributes().write((XMLStreamWriter)writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }

    private void writeGenericStore(XMLExtendedStreamWriter writer, String storeClassName, AbstractStoreConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.STORE);
        writer.writeAttribute(Attribute.CLASS.getLocalName(), storeClassName);
        configuration.attributes().write((XMLStreamWriter)writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }

    static {
        THREAD_POOL_FACTORIES.put(CachedThreadPoolExecutorFactory.class.getName(), Element.CACHED_THREAD_POOL);
        THREAD_POOL_FACTORIES.put(BlockingThreadPoolExecutorFactory.class.getName(), Element.BLOCKING_BOUNDED_QUEUE_THREAD_POOL);
        THREAD_POOL_FACTORIES.put(ScheduledThreadPoolExecutorFactory.class.getName(), Element.SCHEDULED_THREAD_POOL);
    }
}

