/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.group.GroupFilter;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.filter.CollectionKeyFilter;
import org.infinispan.filter.CompositeKeyFilter;
import org.infinispan.interceptors.DDSequentialInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.Metadata;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;

public class EntryWrappingInterceptor
extends DDSequentialInterceptor {
    private EntryFactory entryFactory;
    protected DataContainer<Object, Object> dataContainer;
    protected ClusteringDependentLogic cdl;
    protected final EntryWrappingVisitor entryWrappingVisitor = new EntryWrappingVisitor();
    private CommandsFactory commandFactory;
    private boolean isUsingLockDelegation;
    private boolean isInvalidation;
    private StateConsumer stateConsumer;
    private StateTransferLock stateTransferLock;
    private XSiteStateConsumer xSiteStateConsumer;
    private GroupManager groupManager;
    private static final Log log = LogFactory.getLog(EntryWrappingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final EnumSet<Flag> EVICT_FLAGS = EnumSet.of(Flag.SKIP_OWNERSHIP_CHECK, Flag.CACHE_MODE_LOCAL);

    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(EntryFactory entryFactory, DataContainer<Object, Object> dataContainer, ClusteringDependentLogic cdl, CommandsFactory commandFactory, StateConsumer stateConsumer, StateTransferLock stateTransferLock, XSiteStateConsumer xSiteStateConsumer, GroupManager groupManager) {
        this.entryFactory = entryFactory;
        this.dataContainer = dataContainer;
        this.cdl = cdl;
        this.commandFactory = commandFactory;
        this.stateConsumer = stateConsumer;
        this.stateTransferLock = stateTransferLock;
        this.xSiteStateConsumer = xSiteStateConsumer;
        this.groupManager = groupManager;
    }

    @Start
    public void start() {
        this.isUsingLockDelegation = !this.cacheConfiguration.transaction().transactionMode().isTransactional() && (this.cacheConfiguration.clustering().cacheMode().isDistributed() || this.cacheConfiguration.clustering().cacheMode().isReplicated());
        this.isInvalidation = this.cacheConfiguration.clustering().cacheMode().isInvalidation();
    }

    @Override
    public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        this.wrapEntriesForPrepare(ctx, command);
        Object result = ctx.forkInvocationSync(command);
        if (this.shouldCommitDuringPrepare(command, ctx)) {
            this.commitContextEntries(ctx, null, null);
        }
        return ctx.shortCircuit(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        try {
            CompletableFuture<Void> completableFuture = ctx.shortCircuit(ctx.forkInvocationSync(command));
            return completableFuture;
        }
        finally {
            this.commitContextEntries(ctx, null, null);
        }
    }

    @Override
    public final CompletableFuture<Void> visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public final CompletableFuture<Void> visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> visitDataReadCommand(InvocationContext ctx, AbstractDataCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForReading(ctx, command.getKey(), null);
            CompletableFuture<Void> completableFuture = ctx.shortCircuit(ctx.forkInvocationSync(command));
            return completableFuture;
        }
        finally {
            if (!ctx.isInTxScope()) {
                this.commitContextEntries(ctx, command, null);
            } else {
                CacheEntry entry = ctx.lookupEntry(command.getKey());
                if (entry != null) {
                    entry.setSkipLookup(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        try {
            for (Object key : command.getKeys()) {
                this.entryFactory.wrapEntryForReading(ctx, key, null);
            }
            CompletableFuture<Void> completableFuture = ctx.shortCircuit(ctx.forkInvocationSync(command));
            return completableFuture;
        }
        finally {
            if (ctx.isInTxScope()) {
                for (Object key : command.getKeys()) {
                    CacheEntry entry = ctx.lookupEntry(key);
                    if (entry == null) continue;
                    entry.setSkipLookup(true);
                }
            }
        }
    }

    @Override
    public final CompletableFuture<Void> visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        if (command.getKeys() != null) {
            for (Object key : command.getKeys()) {
                this.entryFactory.wrapEntryForWriting(ctx, key, EntryFactory.Wrap.WRAP_NON_NULL, false, true);
            }
        }
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, null);
    }

    @Override
    public final CompletableFuture<Void> visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return ctx.shortCircuit(this.invokeNextAndApplyChanges(ctx, command, command.getMetadata()));
    }

    @Override
    public CompletableFuture<Void> visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        for (Object key : command.getKeys()) {
            this.entryFactory.wrapEntryForWriting(ctx, key, EntryFactory.Wrap.WRAP_NON_NULL, false, true);
            if (!trace) continue;
            log.tracef("Entry to be removed: %s", Util.toStr((Object)key));
        }
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, null);
    }

    @Override
    public final CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        this.wrapEntryForPutIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, command.getMetadata());
    }

    private void wrapEntryForPutIfNeeded(InvocationContext ctx, AbstractDataWriteCommand command) throws Throwable {
        if (this.shouldWrap(command.getKey(), ctx, command)) {
            boolean skipRead = command.hasFlag(Flag.IGNORE_RETURN_VALUES) && !command.isConditional();
            this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), EntryFactory.Wrap.WRAP_ALL, skipRead, false);
        }
    }

    private boolean shouldWrap(Object key, InvocationContext ctx, FlagAffectedCommand command) {
        if (command.hasFlag(Flag.SKIP_OWNERSHIP_CHECK)) {
            if (trace) {
                log.tracef("Skipping ownership check and wrapping key %s", Util.toStr((Object)key));
            }
            return true;
        }
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            if (trace) {
                log.tracef("CACHE_MODE_LOCAL is set. Wrapping key %s", Util.toStr((Object)key));
            }
            return true;
        }
        boolean isTransactional = this.cacheConfiguration.transaction().transactionMode().isTransactional();
        boolean isPutForExternalRead = command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ);
        boolean result = this.isInvalidation || isTransactional && !isPutForExternalRead ? true : (this.isUsingLockDelegation || isTransactional ? this.cdl.localNodeIsPrimaryOwner(key) || this.cdl.localNodeIsOwner(key) && !ctx.isOriginLocal() : this.cdl.localNodeIsOwner(key));
        if (trace) {
            log.tracef("Wrapping entry '%s'? %s", Util.toStr((Object)key), result);
        }
        return result;
    }

    @Override
    public CompletableFuture<Void> visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        this.entryFactory.wrapEntryForDelta(ctx, command.getKey(), command.getDelta());
        return ctx.continueInvocation();
    }

    @Override
    public final CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        this.wrapEntryForRemoveIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, null);
    }

    private void wrapEntryForRemoveIfNeeded(InvocationContext ctx, RemoveCommand command) throws InterruptedException {
        if (this.shouldWrap(command.getKey(), ctx, command)) {
            boolean forceWrap = command.getValueMatcher().nonExistentEntryCanMatch();
            EntryFactory.Wrap wrap = forceWrap ? EntryFactory.Wrap.WRAP_ALL : EntryFactory.Wrap.WRAP_NON_NULL;
            boolean skipRead = command.hasFlag(Flag.IGNORE_RETURN_VALUES) && !command.isConditional();
            this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), wrap, skipRead, false);
        }
    }

    @Override
    public final CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        this.wrapEntryForReplaceIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, command.getMetadata());
    }

    private void wrapEntryForReplaceIfNeeded(InvocationContext ctx, ReplaceCommand command) throws InterruptedException {
        if (this.shouldWrap(command.getKey(), ctx, command)) {
            EntryFactory.Wrap wrap = command.getValueMatcher().nonExistentEntryCanMatch() ? EntryFactory.Wrap.WRAP_ALL : EntryFactory.Wrap.WRAP_NON_NULL;
            this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), wrap, false, false);
        }
    }

    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        for (Object key : command.getMap().keySet()) {
            if (!this.shouldWrap(key, ctx, command)) continue;
            this.entryFactory.wrapEntryForWriting(ctx, key, EntryFactory.Wrap.WRAP_ALL, true, false);
        }
        return this.setSkipRemoteGetsAndInvokeNextForPutMapCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        command.addFlags(EVICT_FLAGS);
        return this.visitRemoveCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        String groupName = command.getGroupName();
        if (!command.isGroupOwner()) {
            return ctx.continueInvocation();
        }
        CompositeKeyFilter keyFilter = new CompositeKeyFilter(new GroupFilter(groupName, this.groupManager), new CollectionKeyFilter<Object>(ctx.getLookedUpEntries().keySet()));
        this.dataContainer.executeTask(keyFilter, (o, internalCacheEntry) -> {
            InvocationContext invocationContext = ctx;
            synchronized (invocationContext) {
                this.entryFactory.wrapExternalEntry(ctx, internalCacheEntry.getKey(), (CacheEntry)internalCacheEntry, EntryFactory.Wrap.STORE, false);
            }
        });
        return ctx.continueInvocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        try {
            CacheEntry entry = this.entryFactory.wrapEntryForReading(ctx, command.getKey(), null);
            if (entry == null && this.cdl.localNodeIsOwner(command.getKey())) {
                this.entryFactory.wrapEntryForReading(ctx, command.getKey(), NullCacheEntry.getInstance());
            }
            CompletableFuture<Void> completableFuture = ctx.shortCircuit(ctx.forkInvocationSync(command));
            return completableFuture;
        }
        finally {
            if (!ctx.isInTxScope()) {
                this.commitContextEntries(ctx, command, null);
            } else {
                CacheEntry entry = ctx.lookupEntry(command.getKey());
                if (entry != null) {
                    entry.setSkipLookup(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        try {
            for (Object key : command.getKeys()) {
                this.entryFactory.wrapEntryForReading(ctx, key, null);
            }
            CompletableFuture<Void> completableFuture = ctx.shortCircuit(ctx.forkInvocationSync(command));
            return completableFuture;
        }
        finally {
            if (ctx.isInTxScope()) {
                for (Object key : command.getKeys()) {
                    CacheEntry entry = ctx.lookupEntry(key);
                    if (entry == null) continue;
                    entry.setSkipLookup(true);
                }
            }
        }
    }

    @Override
    public CompletableFuture<Void> visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        this.wrapEntryForPutIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, command.getMetadata());
    }

    @Override
    public CompletableFuture<Void> visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        this.wrapEntryForPutIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, command.getMetadata());
    }

    @Override
    public CompletableFuture<Void> visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        this.wrapEntryForPutIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, command.getMetadata());
    }

    @Override
    public CompletableFuture<Void> visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        for (Object key : command.getEntries().keySet()) {
            if (!this.shouldWrap(key, ctx, command)) continue;
            this.entryFactory.wrapEntryForWriting(ctx, key, EntryFactory.Wrap.WRAP_ALL, true, false);
        }
        return this.setSkipRemoteGetsAndInvokeNextForPutMapCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        for (Object key : command.getKeys()) {
            if (!this.shouldWrap(key, ctx, command)) continue;
            this.entryFactory.wrapEntryForWriting(ctx, key, EntryFactory.Wrap.WRAP_ALL, true, false);
        }
        return this.setSkipRemoteGetsAndInvokeNextForPutMapCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        this.wrapEntryForPutIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, command.getMetadata());
    }

    @Override
    public CompletableFuture<Void> visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        for (Object key : command.getKeys()) {
            if (!this.shouldWrap(key, ctx, command)) continue;
            this.entryFactory.wrapEntryForWriting(ctx, key, EntryFactory.Wrap.WRAP_ALL, false, false);
        }
        return this.setSkipRemoteGetsAndInvokeNextForPutMapCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        for (Object key : command.getEntries().keySet()) {
            if (!this.shouldWrap(key, ctx, command)) continue;
            this.entryFactory.wrapEntryForWriting(ctx, key, EntryFactory.Wrap.WRAP_ALL, false, false);
        }
        return this.setSkipRemoteGetsAndInvokeNextForPutMapCommand(ctx, command);
    }

    private Flag extractStateTransferFlag(InvocationContext ctx, FlagAffectedCommand command) {
        if (command == null) {
            return ctx instanceof TxInvocationContext ? ((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).getStateTransferFlag() : null;
        }
        if (command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER)) {
            return Flag.PUT_FOR_STATE_TRANSFER;
        }
        if (command.hasFlag(Flag.PUT_FOR_X_SITE_STATE_TRANSFER)) {
            return Flag.PUT_FOR_X_SITE_STATE_TRANSFER;
        }
        return null;
    }

    protected final void commitContextEntries(InvocationContext ctx, FlagAffectedCommand command, Metadata metadata) {
        Flag stateTransferFlag = this.extractStateTransferFlag(ctx, command);
        if (stateTransferFlag == null) {
            this.stopStateTransferIfNeeded(command);
        }
        if (ctx instanceof SingleKeyNonTxInvocationContext) {
            SingleKeyNonTxInvocationContext singleKeyCtx = (SingleKeyNonTxInvocationContext)ctx;
            this.commitEntryIfNeeded(ctx, command, singleKeyCtx.getCacheEntry(), stateTransferFlag, metadata);
        } else {
            Set<Map.Entry<Object, CacheEntry>> entries = ctx.getLookedUpEntries().entrySet();
            Iterator<Map.Entry<Object, CacheEntry>> it = entries.iterator();
            Log log = this.getLog();
            while (it.hasNext()) {
                Map.Entry<Object, CacheEntry> e = it.next();
                CacheEntry entry = e.getValue();
                if (this.commitEntryIfNeeded(ctx, command, entry, stateTransferFlag, metadata) || !trace) continue;
                if (entry == null) {
                    log.tracef("Entry for key %s is null : not calling commitUpdate", Util.toStr((Object)e.getKey()));
                    continue;
                }
                log.tracef("Entry for key %s is not changed(%s): not calling commitUpdate", Util.toStr((Object)e.getKey()), entry);
            }
        }
    }

    protected void commitContextEntry(CacheEntry entry, InvocationContext ctx, FlagAffectedCommand command, Metadata metadata, Flag stateTransferFlag, boolean l1Invalidation) {
        this.cdl.commitEntry(entry, metadata, command, ctx, stateTransferFlag, l1Invalidation);
    }

    private void stopStateTransferIfNeeded(FlagAffectedCommand command) {
        if (command instanceof ClearCommand) {
            if (this.stateConsumer != null) {
                this.stateConsumer.stopApplyingState();
            }
            if (this.xSiteStateConsumer != null) {
                this.xSiteStateConsumer.endStateTransfer(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeNextAndApplyChanges(InvocationContext ctx, FlagAffectedCommand command, Metadata metadata) throws Throwable {
        Object result = ctx.forkInvocationSync(command);
        if (!ctx.isInTxScope()) {
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                if (command instanceof WriteCommand) {
                    boolean isSync;
                    WriteCommand writeCommand = (WriteCommand)command;
                    boolean bl = isSync = this.cacheConfiguration.clustering().cacheMode().isSynchronous() && !command.hasFlag(Flag.FORCE_ASYNCHRONOUS) || command.hasFlag(Flag.FORCE_SYNCHRONOUS);
                    if (writeCommand.isSuccessful() && this.stateConsumer != null && this.stateConsumer.getCacheTopology() != null) {
                        int commandTopologyId = command.getTopologyId();
                        int currentTopologyId = this.stateConsumer.getCacheTopology().getTopologyId();
                        if (isSync && currentTopologyId != commandTopologyId && commandTopologyId != -1 && (!ctx.isOriginLocal() || !(command instanceof DataCommand) || ctx.hasLockedKey(((DataCommand)((Object)command)).getKey()))) {
                            if (trace) {
                                log.tracef("Cache topology changed while the command was executing: expected %d, got %d", commandTopologyId, currentTopologyId);
                            }
                            writeCommand.setValueMatcher(writeCommand.getValueMatcher().matcherForRetry());
                            throw new OutdatedTopologyException("Cache topology changed while the command was executing: expected " + commandTopologyId + ", got " + currentTopologyId);
                        }
                    }
                }
                this.commitContextEntries(ctx, command, metadata);
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
        }
        if (trace) {
            log.tracef("The return value is %s", Util.toStr((Object)result));
        }
        return result;
    }

    private CompletableFuture<Void> setSkipRemoteGetsAndInvokeNextForPutMapCommand(InvocationContext context, WriteCommand command) throws Throwable {
        Object retVal = this.invokeNextAndApplyChanges(context, command, command.getMetadata());
        if (context.isInTxScope()) {
            for (Object key : command.getAffectedKeys()) {
                CacheEntry entry = context.lookupEntry(key);
                if (entry == null) continue;
                entry.setSkipLookup(true);
            }
        }
        return context.shortCircuit(retVal);
    }

    private CompletableFuture<Void> setSkipRemoteGetsAndInvokeNextForDataCommand(InvocationContext context, DataWriteCommand command, Metadata metadata) throws Throwable {
        CacheEntry entry;
        Object retVal = this.invokeNextAndApplyChanges(context, command, metadata);
        if (context.isInTxScope() && (entry = context.lookupEntry(command.getKey())) != null) {
            entry.setSkipLookup(true);
        }
        return context.shortCircuit(retVal);
    }

    private boolean commitEntryIfNeeded(InvocationContext ctx, FlagAffectedCommand command, CacheEntry entry, Flag stateTransferFlag, Metadata metadata) {
        if (entry == null) {
            return false;
        }
        boolean l1Invalidation = command instanceof InvalidateL1Command;
        if (entry.isChanged()) {
            if (trace) {
                log.tracef("About to commit entry %s", entry);
            }
            this.commitContextEntry(entry, ctx, command, metadata, stateTransferFlag, l1Invalidation);
            return true;
        }
        return false;
    }

    protected boolean shouldCommitDuringPrepare(PrepareCommand command, TxInvocationContext ctx) {
        boolean isTotalOrder = this.cacheConfiguration.transaction().transactionProtocol().isTotalOrder();
        return isTotalOrder ? !(!command.isOnePhaseCommit() || ctx.isOriginLocal() && command.hasModifications()) : command.isOnePhaseCommit();
    }

    protected final void wrapEntriesForPrepare(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!ctx.isOriginLocal() || command.isReplayEntryWrapping()) {
            for (WriteCommand c : command.getModifications()) {
                c.acceptVisitor(ctx, this.entryWrappingVisitor);
                if (!c.hasFlag(Flag.PUT_FOR_X_SITE_STATE_TRANSFER)) continue;
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).setStateTransferFlag(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
            }
        }
    }

    private final class EntryWrappingVisitor
    extends AbstractVisitor {
        private EntryWrappingVisitor() {
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            HashMap<Object, Object> newMap = new HashMap<Object, Object>(4);
            for (Map.Entry<Object, Object> e : command.getMap().entrySet()) {
                Object key = e.getKey();
                if (!EntryWrappingInterceptor.this.cdl.localNodeIsOwner(key)) continue;
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, key, EntryFactory.Wrap.WRAP_ALL, true, false);
                newMap.put(key, e.getValue());
            }
            if (newMap.size() > 0) {
                PutMapCommand clonedCommand = EntryWrappingInterceptor.this.commandFactory.buildPutMapCommand(newMap, command.getMetadata(), command.getFlagsBitSet());
                ctx.forkInvocationSync(clonedCommand);
            }
            return null;
        }

        @Override
        public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
            if (command.getKeys() != null) {
                for (Object key : command.getKeys()) {
                    if (!EntryWrappingInterceptor.this.cdl.localNodeIsOwner(key)) continue;
                    EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, key, EntryFactory.Wrap.WRAP_NON_NULL, false, false);
                    ctx.forkInvocationSync(command);
                }
            }
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                boolean forceWrap = command.getValueMatcher().nonExistentEntryCanMatch();
                EntryFactory.Wrap wrap = forceWrap ? EntryFactory.Wrap.WRAP_ALL : EntryFactory.Wrap.WRAP_NON_NULL;
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), wrap, false, false);
                ctx.forkInvocationSync(command);
            }
            return null;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), EntryFactory.Wrap.WRAP_ALL, false, false);
                ctx.forkInvocationSync(command);
            }
            return null;
        }

        @Override
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForDelta(ctx, command.getKey(), command.getDelta());
                ctx.forkInvocationSync(command);
            }
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                boolean forceWrap = command.getValueMatcher().nonExistentEntryCanMatch();
                EntryFactory.Wrap wrap = forceWrap ? EntryFactory.Wrap.WRAP_ALL : EntryFactory.Wrap.WRAP_NON_NULL;
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), wrap, false, false);
                ctx.forkInvocationSync(command);
            }
            return null;
        }
    }
}

