/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.util.concurrent.locks.LockUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PessimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    private CommandsFactory cf;
    private StateTransferManager stateTransferManager;
    private static final Log log = LogFactory.getLog(PessimisticLockingInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(CommandsFactory factory, StateTransferManager stateTransferManager) {
        this.cf = factory;
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    protected final CompletableFuture<Void> visitDataReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        try {
            Object key;
            if (ctx.isInTxScope() && command.hasFlag(Flag.FORCE_WRITE_LOCK) && !this.hasSkipLocking(command)) {
                key = command.getKey();
                this.acquireRemoteIfNeeded(ctx, key, command);
                this.lockOrRegisterBackupLock((TxInvocationContext)ctx, key, this.getLockTimeoutMillis(command));
                ((TxInvocationContext)ctx).addAffectedKey(key);
            }
            key = ctx.shortCircuit(ctx.forkInvocationSync(command));
            return key;
        }
        catch (Throwable t) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw t;
        }
        finally {
            if (!ctx.isInTxScope()) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    @Override
    public CompletableFuture<Void> visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        try {
            if (ctx.isInTxScope() && command.hasFlag(Flag.FORCE_WRITE_LOCK) && !this.hasSkipLocking(command)) {
                this.acquireAllRemoteIfNeeded(ctx, command.getKeys(), command);
                this.lockAllOrRegisterBackupLock((TxInvocationContext)ctx, command.getKeys(), this.getLockTimeoutMillis(command));
            }
            return ctx.shortCircuit(ctx.forkInvocationSync(command));
        }
        catch (Throwable t) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw t;
        }
    }

    @Override
    public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        return ctx.shortCircuit(this.invokeNextAndCommitIf1Pc(ctx, command));
    }

    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        try {
            if (!this.hasSkipLocking(command)) {
                Set<Object> affectedKeys = command.getMap().keySet();
                this.acquireAllRemoteIfNeeded(ctx, affectedKeys, command);
                this.lockAllOrRegisterBackupLock((TxInvocationContext)ctx, affectedKeys, this.getLockTimeoutMillis(command));
            }
            return ctx.shortCircuit(ctx.forkInvocationSync(command));
        }
        catch (Throwable te) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw te;
        }
    }

    @Override
    protected CompletableFuture<Void> visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        try {
            Object key = command.getKey();
            if (!this.hasSkipLocking(command)) {
                this.acquireRemoteIfNeeded(ctx, key, command);
                this.lockOrRegisterBackupLock((TxInvocationContext)ctx, key, this.getLockTimeoutMillis(command));
            }
            ((TxInvocationContext)ctx).addAffectedKey(key);
            return ctx.shortCircuit(ctx.forkInvocationSync(command));
        }
        catch (OutdatedTopologyException e) {
            throw e;
        }
        catch (Throwable te) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw te;
        }
    }

    @Override
    public CompletableFuture<Void> visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        Object[] compositeKeys = command.getCompositeKeys();
        try {
            if (!this.hasSkipLocking(command)) {
                HashSet<Object> keysToLock = new HashSet<Object>(Arrays.asList(compositeKeys));
                this.acquireAllRemoteIfNeeded(ctx, keysToLock, command);
                if (this.cdl.localNodeIsOwner(command.getKey())) {
                    this.lockAllAndRecord(ctx, keysToLock, this.getLockTimeoutMillis(command));
                }
            }
            return ctx.shortCircuit(ctx.forkInvocationSync(command));
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public CompletableFuture<Void> visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (!ctx.isInTxScope()) {
            throw new IllegalStateException("Locks should only be acquired within the scope of a transaction!");
        }
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            if (skipLocking) {
                return ctx.shortCircuit(ctx.forkInvocationSync(command));
            }
            if (ctx.isOriginLocal()) {
                boolean needBackupLocks;
                boolean isSingleKeyAndLocal = !command.multipleKeys() && this.cdl.localNodeIsPrimaryOwner(command.getSingleKey());
                boolean bl = needBackupLocks = !isSingleKeyAndLocal || this.isStateTransferInProgress();
                if (needBackupLocks && !command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
                    LocalTransaction localTx = (LocalTransaction)ctx.getCacheTransaction();
                    if (!localTx.getAffectedKeys().containsAll(command.getKeys())) {
                        ctx.forkInvocationSync(command);
                    } else {
                        log.tracef("Already own locks on keys: %s, skipping remote call", command.getKeys());
                    }
                }
                ctx.addAllAffectedKeys(command.getKeys());
            }
            if (command.isUnlock()) {
                if (ctx.isOriginLocal()) {
                    throw new AssertionError((Object)"There's no advancedCache.unlock so this must have originated remotely.");
                }
                this.releaseLocksOnFailureBeforePrepare(ctx);
                return ctx.shortCircuit(Boolean.FALSE);
            }
            this.lockAllOrRegisterBackupLock(ctx, command.getKeys(), this.getLockTimeoutMillis(command));
            return ctx.shortCircuit(Boolean.TRUE);
        }
        catch (Throwable te) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw te;
        }
    }

    private void acquireAllRemoteIfNeeded(InvocationContext ctx, Collection<?> keys, LocalFlagAffectedCommand command) throws Throwable {
        boolean needBackupLocks;
        boolean bl = needBackupLocks = ctx.isOriginLocal() && (!this.isLockOwner(keys) || this.isStateTransferInProgress());
        if (needBackupLocks && !command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            if (localTransaction.getAffectedKeys().containsAll(keys)) {
                log.tracef("We already have lock for keys %s, skip remote lock acquisition", keys);
                return;
            }
            LockControlCommand lcc = this.cf.buildLockControlCommand(keys, command.getFlagsBitSet(), txContext.getGlobalTransaction());
            ctx.forkInvocationSync(lcc);
        }
        ((TxInvocationContext)ctx).addAllAffectedKeys(keys);
    }

    private void acquireRemoteIfNeeded(InvocationContext ctx, Object key, LocalFlagAffectedCommand command) throws Throwable {
        boolean needBackupLocks;
        boolean bl = needBackupLocks = ctx.isOriginLocal() && (!this.isLockOwner(key) || this.isStateTransferInProgress());
        if (needBackupLocks && !command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            if (localTransaction.getAffectedKeys().contains(key)) {
                log.tracef("We already have lock for key %s, skip remote lock acquisition", key);
                return;
            }
            LockControlCommand lcc = this.cf.buildLockControlCommand(key, command.getFlagsBitSet(), txContext.getGlobalTransaction());
            ctx.forkInvocationSync(lcc);
        }
    }

    private boolean isLockOwner(Collection<?> keys) {
        for (Object key : keys) {
            if (LockUtil.getLockOwnership(key, this.cdl) == LockUtil.LockOwnership.PRIMARY) continue;
            return false;
        }
        return true;
    }

    private boolean isLockOwner(Object key) {
        return LockUtil.getLockOwnership(key, this.cdl) == LockUtil.LockOwnership.PRIMARY;
    }

    private boolean isStateTransferInProgress() {
        return this.stateTransferManager != null && this.stateTransferManager.isStateTransferInProgress();
    }

    private void releaseLocksOnFailureBeforePrepare(InvocationContext ctx) {
        this.lockManager.unlockAll(ctx);
        if (ctx.isOriginLocal() && ctx.isInTxScope() && this.rpcManager != null) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            TxCompletionNotificationCommand command = this.cf.buildTxCompletionNotificationCommand(null, txContext.getGlobalTransaction());
            LocalTransaction cacheTransaction = (LocalTransaction)txContext.getCacheTransaction();
            this.rpcManager.invokeRemotely(cacheTransaction.getRemoteLocksAcquired(), command, this.rpcManager.getDefaultRpcOptions(false, DeliverOrder.NONE));
        }
    }
}

