/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.locks.TransactionalRemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PrepareCommand
extends AbstractTransactionBoundaryCommand
implements TransactionalRemoteLockCommand {
    private static final Log log = LogFactory.getLog(PrepareCommand.class);
    private boolean trace = log.isTraceEnabled();
    public static final byte COMMAND_ID = 12;
    protected WriteCommand[] modifications;
    protected boolean onePhaseCommit;
    protected CacheNotifier notifier;
    protected RecoveryManager recoveryManager;
    private transient boolean replayEntryWrapping = false;
    protected boolean retriedCommand;
    private static final WriteCommand[] EMPTY_WRITE_COMMAND_ARRAY = new WriteCommand[0];

    public void initialize(CacheNotifier notifier, RecoveryManager recoveryManager) {
        this.notifier = notifier;
        this.recoveryManager = recoveryManager;
    }

    private PrepareCommand() {
        super(null);
    }

    public PrepareCommand(ByteString cacheName, GlobalTransaction gtx, boolean onePhaseCommit, WriteCommand ... modifications) {
        super(cacheName);
        this.globalTx = gtx;
        this.modifications = modifications;
        this.onePhaseCommit = onePhaseCommit;
    }

    public PrepareCommand(ByteString cacheName, GlobalTransaction gtx, List<WriteCommand> commands, boolean onePhaseCommit) {
        super(cacheName);
        this.globalTx = gtx;
        this.modifications = commands == null || commands.isEmpty() ? null : commands.toArray(new WriteCommand[commands.size()]);
        this.onePhaseCommit = onePhaseCommit;
    }

    public PrepareCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public Object perform(InvocationContext ignored) throws Throwable {
        if (ignored != null) {
            throw new IllegalStateException("Expected null context!");
        }
        RemoteTxInvocationContext ctx = this.createContext();
        if (ctx == null) {
            return null;
        }
        if (this.trace) {
            log.tracef("Invoking remotely originated prepare: %s with invocation context: %s", this, ctx);
        }
        this.notifier.notifyTransactionRegistered(ctx.getGlobalTransaction(), false);
        return this.invoker.invoke(ctx, this);
    }

    public RemoteTxInvocationContext createContext() {
        if (this.recoveryManager != null && this.recoveryManager.isTransactionPrepared(this.globalTx)) {
            log.tracef("The transaction %s is already prepared. Skipping prepare call.", this.globalTx);
            return null;
        }
        RemoteTransaction remoteTransaction = this.getRemoteTransaction();
        if (this.hasModifications()) {
            remoteTransaction.setModifications(Arrays.asList(this.modifications));
        }
        return this.icf.createRemoteTxInvocationContext(remoteTransaction, this.getOrigin());
    }

    @Override
    public Collection<Object> getKeysToLock() {
        if (this.modifications == null || this.modifications.length == 0) {
            return Collections.emptyList();
        }
        HashSet<Object> set = new HashSet<Object>(this.modifications.length);
        InfinispanCollections.forEach((Object[])this.modifications, writeCommand -> {
            if (writeCommand.hasFlag(Flag.SKIP_LOCKING)) {
                return;
            }
            switch (writeCommand.getCommandId()) {
                case 8: 
                case 10: 
                case 11: 
                case 58: {
                    set.add(((DataWriteCommand)writeCommand).getKey());
                    break;
                }
                case 9: {
                    set.addAll(writeCommand.getAffectedKeys());
                    break;
                }
                case 25: {
                    ApplyDeltaCommand command = (ApplyDeltaCommand)writeCommand;
                    Object[] compositeKeys = command.getCompositeKeys();
                    set.addAll(Arrays.asList(compositeKeys));
                    break;
                }
            }
        });
        return set;
    }

    @Override
    public Object getKeyLockOwner() {
        return this.globalTx;
    }

    @Override
    public boolean hasZeroLockAcquisition() {
        return false;
    }

    @Override
    public boolean hasSkipLocking() {
        return false;
    }

    @Override
    protected RemoteTransaction getRemoteTransaction() {
        return this.txTable.getOrCreateRemoteTransaction(this.globalTx, this.modifications);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPrepareCommand((TxInvocationContext)ctx, this);
    }

    public WriteCommand[] getModifications() {
        return this.modifications == null ? EMPTY_WRITE_COMMAND_ARRAY : this.modifications;
    }

    public boolean isOnePhaseCommit() {
        return this.onePhaseCommit;
    }

    @Override
    public byte getCommandId() {
        return 12;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        output.writeBoolean(this.onePhaseCommit);
        output.writeBoolean(this.retriedCommand);
        MarshallUtil.marshallArray((Object[])this.modifications, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        this.onePhaseCommit = input.readBoolean();
        this.retriedCommand = input.readBoolean();
        this.modifications = (WriteCommand[])MarshallUtil.unmarshallArray((ObjectInput)input, WriteCommand[]::new);
    }

    public PrepareCommand copy() {
        PrepareCommand copy = new PrepareCommand(this.cacheName);
        copy.globalTx = this.globalTx;
        copy.modifications = this.modifications == null ? null : (WriteCommand[])this.modifications.clone();
        copy.onePhaseCommit = this.onePhaseCommit;
        return copy;
    }

    @Override
    public String toString() {
        return "PrepareCommand {modifications=" + (this.modifications == null ? null : Arrays.asList(this.modifications)) + ", onePhaseCommit=" + this.onePhaseCommit + ", retried=" + this.retriedCommand + ", " + super.toString();
    }

    public boolean hasModifications() {
        return this.modifications != null && this.modifications.length > 0;
    }

    public Set<Object> getAffectedKeys() {
        if (this.modifications == null || this.modifications.length == 0) {
            return Collections.emptySet();
        }
        if (this.modifications.length == 1) {
            return this.modifications[0].getAffectedKeys();
        }
        HashSet<Object> keys = new HashSet<Object>(this.modifications.length);
        for (WriteCommand wc : this.modifications) {
            keys.addAll(wc.getAffectedKeys());
        }
        return keys;
    }

    public boolean isReplayEntryWrapping() {
        return this.replayEntryWrapping;
    }

    public void setReplayEntryWrapping(boolean replayEntryWrapping) {
        this.replayEntryWrapping = replayEntryWrapping;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    public boolean isRetriedCommand() {
        return this.retriedCommand;
    }

    public void setRetriedCommand(boolean retriedCommand) {
        this.retriedCommand = retriedCommand;
    }
}

