/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.compat;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.StreamSupport;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.Caches;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorMapper;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.compat.TypeConverter;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDSequentialInterceptor;
import org.infinispan.interceptors.compat.TypeConverterStream;
import org.infinispan.metadata.Metadata;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingEntryCacheSet;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingKeyCacheSet;
import org.infinispan.stream.impl.local.EntryStreamSupplier;
import org.infinispan.stream.impl.local.KeyStreamSupplier;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.stream.impl.spliterators.IteratorAsSpliterator;

public abstract class BaseTypeConverterInterceptor<K, V>
extends DDSequentialInterceptor {
    private InternalEntryFactory entryFactory;
    private VersionGenerator versionGenerator;
    private Cache<K, V> cache;

    @Inject
    protected void init(InternalEntryFactory entryFactory, VersionGenerator versionGenerator, Cache<K, V> cache) {
        this.entryFactory = entryFactory;
        this.versionGenerator = versionGenerator;
        this.cache = cache;
    }

    protected abstract TypeConverter<Object, Object, Object, Object> determineTypeConverter(Set<Flag> var1);

    @Override
    public CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
            command.setValue(converter.boxValue(command.getValue()));
        }
        Object ret = ctx.forkInvocationSync(command);
        return ctx.shortCircuit(converter.unboxValue(ret));
    }

    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            Map<Object, Object> map = command.getMap();
            TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
            HashMap<Object, Object> convertedMap = new HashMap<Object, Object>(map.size());
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                convertedMap.put(converter.boxKey(entry.getKey()), converter.boxValue(entry.getValue()));
            }
            command.setMap(convertedMap);
        }
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object ret;
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
        }
        if ((ret = ctx.forkInvocationSync(command)) != null) {
            if (this.needsUnboxing(ctx)) {
                return ctx.shortCircuit(converter.unboxValue(ret));
            }
            return ctx.shortCircuit(ret);
        }
        return ctx.shortCircuit(null);
    }

    @Override
    public CompletableFuture<Void> visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        Object ret;
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
        }
        if ((ret = ctx.forkInvocationSync(command)) != null) {
            CacheEntry entry = (CacheEntry)ret;
            Object returnValue = entry.getValue();
            if (this.needsUnboxing(ctx)) {
                returnValue = converter.unboxValue(entry.getValue());
            }
            return ctx.shortCircuit(this.entryFactory.create(entry.getKey(), returnValue, entry.getMetadata(), entry.getLifespan(), entry.getMaxIdle()));
        }
        return ctx.shortCircuit(null);
    }

    private boolean needsUnboxing(InvocationContext ctx) {
        return ctx.isOriginLocal();
    }

    @Override
    public CompletableFuture<Void> visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        Object ret;
        Collection<?> keys = command.getKeys();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        if (ctx.isOriginLocal()) {
            LinkedHashSet<Object> boxedKeys = new LinkedHashSet<Object>(keys.size());
            for (Object key : keys) {
                boxedKeys.add(converter.boxKey(key));
            }
            command.setKeys(boxedKeys);
        }
        if ((ret = ctx.forkInvocationSync(command)) != null && !this.needsUnboxing(ctx)) {
            return ctx.shortCircuit(ret);
        }
        if (ret != null) {
            Map<Object, Object> unboxed;
            Map map;
            if (command.isReturnEntries()) {
                map = (Map)ret;
                unboxed = command.createMap();
                for (Map.Entry entry : map.entrySet()) {
                    CacheEntry cacheEntry = (CacheEntry)entry.getValue();
                    if (cacheEntry == null) {
                        unboxed.put(entry.getKey(), null);
                        continue;
                    }
                    if (command.getRemotelyFetched() == null || !command.getRemotelyFetched().containsKey(entry.getKey())) {
                        unboxed.put(converter.unboxKey(entry.getKey()), this.entryFactory.create(entry.getKey(), converter.unboxValue(cacheEntry.getValue()), cacheEntry.getMetadata(), cacheEntry.getLifespan(), cacheEntry.getMaxIdle()));
                        continue;
                    }
                    unboxed.put(converter.unboxKey(entry.getKey()), cacheEntry);
                }
                return ctx.shortCircuit(unboxed);
            }
            map = (Map)ret;
            unboxed = command.createMap();
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry == null ? null : (Object)entry.getValue();
                unboxed.put(converter.unboxKey(entry.getKey()), entry == null ? null : converter.unboxValue(value));
            }
            return ctx.shortCircuit(unboxed);
        }
        return ctx.shortCircuit(null);
    }

    @Override
    public CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        Object oldValue = command.getOldValue();
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
            command.setOldValue(converter.boxValue(oldValue));
            command.setNewValue(converter.boxValue(command.getNewValue()));
        }
        this.addVersionIfNeeded(command);
        Object ret = ctx.forkInvocationSync(command);
        if (oldValue != null && ret instanceof Boolean) {
            return ctx.shortCircuit(ret);
        }
        return ctx.shortCircuit(converter.unboxValue(ret));
    }

    private void addVersionIfNeeded(MetadataAwareCommand cmd) {
        Metadata metadata = cmd.getMetadata();
        if (metadata.version() == null) {
            Metadata newMetadata = metadata.builder().version(this.versionGenerator.generateNew()).build();
            cmd.setMetadata(newMetadata);
        }
    }

    @Override
    public CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        Object conditionalValue = command.getValue();
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
            command.setValue(converter.boxValue(conditionalValue));
        }
        Object ret = ctx.forkInvocationSync(command);
        if (conditionalValue != null && ret instanceof Boolean) {
            return ctx.shortCircuit(ret);
        }
        return ctx.shortCircuit(ctx.isOriginLocal() ? converter.unboxValue(ret) : ret);
    }

    @Override
    public CompletableFuture<Void> visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            final TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
            CacheSet set = (CacheSet)ctx.forkInvocationSync(command);
            return ctx.shortCircuit(new AbstractDelegatingKeyCacheSet<K, V>(Caches.getCacheWithFlags(this.cache, command), set){

                @Override
                public CloseableIterator<K> iterator() {
                    return new CloseableIteratorMapper(super.iterator(), k -> converter.unboxKey(k));
                }

                @Override
                public CloseableSpliterator<K> spliterator() {
                    return new IteratorAsSpliterator.Builder(this.iterator()).setEstimateRemaining(super.spliterator().estimateSize()).setCharacteristics(4353).get();
                }

                @Override
                protected CacheStream<K> getStream(boolean parallel) {
                    DistributionManager dm = BaseTypeConverterInterceptor.this.cache.getAdvancedCache().getDistributionManager();
                    CloseableSpliterator closeableSpliterator = super.spliterator();
                    LocalCacheStream stream = new LocalCacheStream(new KeyStreamSupplier(BaseTypeConverterInterceptor.this.cache, dm != null ? dm.getConsistentHash() : null, () -> StreamSupport.stream(closeableSpliterator, parallel)), parallel, BaseTypeConverterInterceptor.this.cache.getAdvancedCache().getComponentRegistry());
                    stream.onClose(() -> closeableSpliterator.close());
                    return new TypeConverterStream(stream, converter, BaseTypeConverterInterceptor.this.entryFactory);
                }
            });
        }
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            final TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
            CacheSet set = (CacheSet)ctx.forkInvocationSync(command);
            return ctx.shortCircuit(new AbstractDelegatingEntryCacheSet<K, V>(Caches.getCacheWithFlags(this.cache, command), set){

                @Override
                public CloseableIterator<CacheEntry<K, V>> iterator() {
                    return new TypeConverterIterator(super.iterator(), converter, BaseTypeConverterInterceptor.this.entryFactory);
                }

                @Override
                public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
                    return new IteratorAsSpliterator.Builder(this.iterator()).setEstimateRemaining(super.spliterator().estimateSize()).setCharacteristics(4353).get();
                }

                @Override
                protected CacheStream<CacheEntry<K, V>> getStream(boolean parallel) {
                    DistributionManager dm = BaseTypeConverterInterceptor.this.cache.getAdvancedCache().getDistributionManager();
                    CloseableSpliterator closeableSpliterator = super.spliterator();
                    LocalCacheStream stream = new LocalCacheStream(new EntryStreamSupplier(BaseTypeConverterInterceptor.this.cache, dm != null ? dm.getConsistentHash() : null, () -> StreamSupport.stream(closeableSpliterator, parallel)), parallel, BaseTypeConverterInterceptor.this.cache.getAdvancedCache().getComponentRegistry());
                    stream.onClose(() -> closeableSpliterator.close());
                    return new TypeConverterStream(stream, converter, BaseTypeConverterInterceptor.this.entryFactory);
                }
            });
        }
        return ctx.continueInvocation();
    }

    private static <K, V> CacheEntry<K, V> convert(CacheEntry<K, V> entry, TypeConverter<Object, Object, Object, Object> converter, InternalEntryFactory entryFactory) {
        Object newKey = converter.unboxKey(entry.getKey());
        Object newValue = converter.unboxValue(entry.getValue());
        if (newKey != entry.getKey() || newValue != entry.getValue()) {
            return entryFactory.create(newKey, newValue, entry.getMetadata());
        }
        return entry;
    }

    private static class TypeConverterIterator<K, V>
    implements CloseableIterator<CacheEntry<K, V>> {
        private final CloseableIterator<CacheEntry<K, V>> iterator;
        private final TypeConverter<Object, Object, Object, Object> converter;
        private final InternalEntryFactory entryFactory;

        private TypeConverterIterator(CloseableIterator<CacheEntry<K, V>> iterator, TypeConverter<Object, Object, Object, Object> converter, InternalEntryFactory entryFactory) {
            this.iterator = iterator;
            this.converter = converter;
            this.entryFactory = entryFactory;
        }

        public void close() {
            this.iterator.close();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public CacheEntry<K, V> next() {
            CacheEntry entry = (CacheEntry)this.iterator.next();
            return BaseTypeConverterInterceptor.convert(entry, this.converter, this.entryFactory);
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

