/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.concurrent.CompletableFuture;
import org.infinispan.InvalidCacheUsageException;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTransactionalLockingInterceptor
extends AbstractLockingInterceptor {
    private static final Log log = LogFactory.getLog(NonTransactionalLockingInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final CompletableFuture<Void> visitDataReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            CompletableFuture<Void> completableFuture = ctx.shortCircuit(ctx.forkInvocationSync(command));
            return completableFuture;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    protected CompletableFuture<Void> visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        return this.visitNonTxDataWriteCommand(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            CompletableFuture<Void> completableFuture = ctx.shortCircuit(ctx.forkInvocationSync(command));
            return completableFuture;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            if (!command.isForwarded() && !this.hasSkipLocking(command)) {
                this.lockAllAndRecord(ctx, command.getMap().keySet().stream().filter(this::shouldLockKey), this.getLockTimeoutMillis(command));
            }
            CompletableFuture<Void> completableFuture = ctx.shortCircuit(ctx.forkInvocationSync(command));
            return completableFuture;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    private void assertNonTransactional(InvocationContext ctx) {
        if (ctx.isInTxScope()) {
            throw new InvalidCacheUsageException("This is a non-transactional cache and cannot be accessed with a transactional InvocationContext.");
        }
    }
}

