/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Sort;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.QueryTimeoutException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.AbstractQueryImpl;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.filter.FullTextFilter;
import org.hibernate.search.hcore.util.impl.ContextHelper;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.IteratorImpl;
import org.hibernate.search.query.hibernate.impl.Loader;
import org.hibernate.search.query.hibernate.impl.ObjectInitializer;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderBuilder;
import org.hibernate.search.query.hibernate.impl.ProjectionLoader;
import org.hibernate.search.query.hibernate.impl.ScrollableResultsImpl;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.transform.ResultTransformer;

public class FullTextQueryImpl
extends AbstractQueryImpl
implements FullTextQuery {
    private static final Log log = LoggerFactory.make();
    private ObjectLookupMethod objectLookupMethod;
    private DatabaseRetrievalMethod databaseRetrievalMethod;
    private Criteria criteria;
    private ResultTransformer resultTransformer;
    private int fetchSize = 1;
    private final HSQuery hSearchQuery;
    private static final Loader noLoader = new Loader(){

        @Override
        public void init(Session session, ExtendedSearchIntegrator extendedIntegrator, ObjectInitializer objectInitializer, TimeoutManager timeoutManager) {
        }

        @Override
        public Object load(EntityInfo entityInfo) {
            throw new UnsupportedOperationException("noLoader should not be used");
        }

        @Override
        public Object loadWithoutTiming(EntityInfo entityInfo) {
            throw new UnsupportedOperationException("noLoader should not be used");
        }

        @Override
        public List load(List<EntityInfo> entityInfos) {
            throw new UnsupportedOperationException("noLoader should not be used");
        }

        @Override
        public boolean isSizeSafe() {
            return false;
        }
    };
    private static final TimeoutExceptionFactory exceptionFactory = new TimeoutExceptionFactory(){

        public RuntimeException createTimeoutException(String message, String queryDescription) {
            return new QueryTimeoutException(message, null, queryDescription);
        }
    };

    public FullTextQueryImpl(QueryDescriptor query, Class<?>[] classes, SessionImplementor session, ParameterMetadata parameterMetadata) {
        super(query.toString(), null, session, parameterMetadata);
        ExtendedSearchIntegrator extendedIntegrator = this.getExtendedSearchIntegrator();
        this.objectLookupMethod = extendedIntegrator.getDefaultObjectLookupMethod();
        this.databaseRetrievalMethod = extendedIntegrator.getDefaultDatabaseRetrievalMethod();
        this.hSearchQuery = query.createHSQuery(extendedIntegrator);
        this.hSearchQuery.timeoutExceptionFactory(exceptionFactory).tenantIdentifier(session.getTenantIdentifier()).targetedEntities(Arrays.asList(classes));
    }

    @Override
    public FullTextQuery setSort(Sort sort) {
        this.hSearchQuery.sort(sort);
        return this;
    }

    @Override
    public FullTextQuery setFilter(Filter filter) {
        this.hSearchQuery.filter(filter);
        return this;
    }

    public Iterator iterate() {
        this.hSearchQuery.getTimeoutManager().start();
        List entityInfos = this.hSearchQuery.queryEntityInfos();
        this.hSearchQuery.getTimeoutManager().stop();
        if (entityInfos.size() == 0) {
            IteratorImpl iterator = new IteratorImpl(entityInfos, noLoader);
            return iterator;
        }
        Loader loader = this.getLoader();
        IteratorImpl iterator = new IteratorImpl(entityInfos, loader);
        this.hSearchQuery.getTimeoutManager().stop();
        return iterator;
    }

    private Loader getLoader() {
        ObjectLoaderBuilder loaderBuilder = new ObjectLoaderBuilder().criteria(this.criteria).targetedEntities(this.hSearchQuery.getTargetedEntities()).indexedTargetedEntities(this.hSearchQuery.getIndexedTargetedEntities()).session(this.session).searchFactory(this.hSearchQuery.getExtendedSearchIntegrator()).timeoutManager(this.hSearchQuery.getTimeoutManager()).lookupMethod(this.objectLookupMethod).retrievalMethod(this.databaseRetrievalMethod);
        if (this.hSearchQuery.getProjectedFields() != null) {
            return this.getProjectionLoader(loaderBuilder);
        }
        return loaderBuilder.buildLoader();
    }

    private Loader getProjectionLoader(ObjectLoaderBuilder loaderBuilder) {
        ProjectionLoader loader = new ProjectionLoader();
        loader.init((Session)this.session, this.hSearchQuery.getExtendedSearchIntegrator(), this.resultTransformer, loaderBuilder, this.hSearchQuery.getProjectedFields(), this.hSearchQuery.getTimeoutManager(), this.hSearchQuery.hasThisProjection());
        return loader;
    }

    public ScrollableResults scroll() {
        this.hSearchQuery.getTimeoutManager().start();
        DocumentExtractor documentExtractor = this.hSearchQuery.queryDocumentExtractor();
        this.hSearchQuery.getTimeoutManager().stop();
        Loader loader = this.getLoader();
        return new ScrollableResultsImpl(this.fetchSize, documentExtractor, loader, this.session, this.hSearchQuery.hasThisProjection());
    }

    public ScrollableResults scroll(ScrollMode scrollMode) {
        return this.scroll();
    }

    public List list() {
        this.hSearchQuery.getTimeoutManager().start();
        List entityInfos = this.hSearchQuery.queryEntityInfos();
        Loader loader = this.getLoader();
        List list = loader.load(entityInfos);
        if (this.resultTransformer != null && !(loader instanceof ProjectionLoader)) {
            list = this.resultTransformer.transformList(list);
        }
        this.hSearchQuery.getTimeoutManager().stop();
        return list;
    }

    @Override
    public Explanation explain(int documentId) {
        return this.hSearchQuery.explain(documentId);
    }

    @Override
    public int getResultSize() {
        if (this.getLoader().isSizeSafe()) {
            return this.hSearchQuery.queryResultSize();
        }
        throw log.cannotGetResultSizeWithCriteriaAndRestriction(this.criteria.toString());
    }

    @Override
    public FullTextQuery setCriteriaQuery(Criteria criteria) {
        this.criteria = criteria;
        return this;
    }

    @Override
    public FullTextQuery setProjection(String ... fields) {
        this.hSearchQuery.projection(fields);
        return this;
    }

    @Override
    public FullTextQuery setSpatialParameters(Coordinates center, String fieldName) {
        this.hSearchQuery.setSpatialParameters(center, fieldName);
        return this;
    }

    @Override
    public FullTextQuery setSpatialParameters(double latitude, double longitude, String fieldName) {
        this.setSpatialParameters((Coordinates)Point.fromDegrees((double)latitude, (double)longitude), fieldName);
        return this;
    }

    @Override
    public FullTextQuery setFirstResult(int firstResult) {
        this.hSearchQuery.firstResult(firstResult);
        return this;
    }

    @Override
    public FullTextQuery setMaxResults(int maxResults) {
        this.hSearchQuery.maxResults(maxResults);
        return this;
    }

    @Override
    public FullTextQuery setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("'fetch size' parameter less than or equals to 0");
        }
        this.fetchSize = fetchSize;
        return this;
    }

    public Query setLockOptions(LockOptions lockOptions) {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    @Override
    public FullTextQuery setResultTransformer(ResultTransformer transformer) {
        super.setResultTransformer(transformer);
        this.resultTransformer = transformer;
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        if (type == org.apache.lucene.search.Query.class) {
            return (T)this.hSearchQuery.getLuceneQuery();
        }
        throw new IllegalArgumentException("Cannot unwrap " + type.getName());
    }

    public LockOptions getLockOptions() {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    public int executeUpdate() {
        throw new UnsupportedOperationException("executeUpdate is not supported in Hibernate Search queries");
    }

    public Query setLockMode(String alias, LockMode lockMode) {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    protected Map getLockModes() {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        return this.hSearchQuery.enableFullTextFilter(name);
    }

    @Override
    public void disableFullTextFilter(String name) {
        this.hSearchQuery.disableFullTextFilter(name);
    }

    @Override
    public FacetManager getFacetManager() {
        return this.hSearchQuery.getFacetManager();
    }

    public FullTextQuery setTimeout(int timeout) {
        return this.setTimeout(timeout, TimeUnit.SECONDS);
    }

    @Override
    public FullTextQuery setTimeout(long timeout, TimeUnit timeUnit) {
        super.setTimeout((int)timeUnit.toSeconds(timeout));
        this.hSearchQuery.getTimeoutManager().setTimeout(timeout, timeUnit);
        this.hSearchQuery.getTimeoutManager().raiseExceptionOnTimeout();
        return this;
    }

    @Override
    public FullTextQuery limitExecutionTimeTo(long timeout, TimeUnit timeUnit) {
        this.hSearchQuery.getTimeoutManager().setTimeout(timeout, timeUnit);
        this.hSearchQuery.getTimeoutManager().limitFetchingOnTimeout();
        return this;
    }

    @Override
    public boolean hasPartialResults() {
        return this.hSearchQuery.getTimeoutManager().hasPartialResults();
    }

    @Override
    public FullTextQuery initializeObjectsWith(ObjectLookupMethod lookupMethod, DatabaseRetrievalMethod retrievalMethod) {
        this.objectLookupMethod = lookupMethod;
        this.databaseRetrievalMethod = retrievalMethod;
        return this;
    }

    private ExtendedSearchIntegrator getExtendedSearchIntegrator() {
        return ContextHelper.getSearchIntegratorBySessionImplementor(this.session);
    }
}

