/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded;

import java.util.concurrent.Callable;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.infinispan.Cache;
import org.infinispan.cdi.common.util.CDIHelper;
import org.infinispan.cdi.embedded.ContextInputCache;
import org.infinispan.distexec.spi.DistributedTaskLifecycle;

public class DelegatingDistributedTaskLifecycle
implements DistributedTaskLifecycle {
    private final DistributedTaskLifecycle delegate = CDIHelper.isCDIAvailable() ? new CDIDistributedTaskLifecycle() : new NoCDIDistributedTaskLifecycle();

    public <T, K, V> void onPreExecute(Callable<T> task, Cache<K, V> inputDataCache) {
        this.delegate.onPreExecute(task, inputDataCache);
    }

    public <T> void onPostExecute(Callable<T> task) {
        this.delegate.onPostExecute(task);
    }

    static class CDIDistributedTaskLifecycle
    implements DistributedTaskLifecycle {
        CDIDistributedTaskLifecycle() {
        }

        public <T, K, V> void onPreExecute(Callable<T> task, Cache<K, V> inputDataCache) {
            BeanManager bm = CDIHelper.getBeanManager();
            if (bm == null) {
                return;
            }
            ContextInputCache.set(inputDataCache);
            Class<?> clazz = task.getClass();
            AnnotatedType type = bm.createAnnotatedType(clazz);
            InjectionTarget it = bm.createInjectionTarget(type);
            CreationalContext ctx = bm.createCreationalContext(null);
            it.inject(task, ctx);
            it.postConstruct(task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> void onPostExecute(Callable<T> task) {
            try {
                BeanManager bm = CDIHelper.getBeanManager();
                if (bm == null) {
                    return;
                }
                Class<?> clazz = task.getClass();
                AnnotatedType type = bm.createAnnotatedType(clazz);
                InjectionTarget it = bm.createInjectionTarget(type);
                it.preDestroy(task);
                it.dispose(task);
            }
            finally {
                ContextInputCache.clean();
            }
        }
    }

    static class NoCDIDistributedTaskLifecycle
    implements DistributedTaskLifecycle {
        NoCDIDistributedTaskLifecycle() {
        }

        public <T, K, V> void onPreExecute(Callable<T> task, Cache<K, V> inputDataCache) {
        }

        public <T> void onPostExecute(Callable<T> task) {
        }
    }
}

