/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.infinispan.commands.CancellationService;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CancelCommand
extends BaseRpcCommand {
    private static final Log log = LogFactory.getLog(CancelCommand.class);
    public static final byte COMMAND_ID = 34;
    private UUID commandToCancel;
    private CancellationService service;

    private CancelCommand() {
        super(null);
    }

    public CancelCommand(ByteString ownerCacheName) {
        super(ownerCacheName);
    }

    public CancelCommand(ByteString ownerCacheName, UUID commandToCancel) {
        super(ownerCacheName);
        this.commandToCancel = commandToCancel;
    }

    public void init(CancellationService service) {
        this.service = service;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        log.trace("Cancelling " + this.commandToCancel);
        this.service.cancel(this.commandToCancel);
        log.trace("Cancelled " + this.commandToCancel);
        return true;
    }

    @Override
    public byte getCommandId() {
        return 34;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallUUID((UUID)this.commandToCancel, (ObjectOutput)output, (boolean)false);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandToCancel = MarshallUtil.unmarshallUUID((ObjectInput)input, (boolean)false);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.commandToCancel == null ? 0 : this.commandToCancel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelCommand)) {
            return false;
        }
        CancelCommand other = (CancelCommand)obj;
        return !(this.commandToCancel == null ? other.commandToCancel != null : !this.commandToCancel.equals(other.commandToCancel));
    }

    @Override
    public String toString() {
        return "CancelCommand [uuid=" + this.commandToCancel + "]";
    }
}

