/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;

public class AbstractStoreConfiguration
implements StoreConfiguration {
    public static final AttributeDefinition<Boolean> FETCH_PERSISTENT_STATE = AttributeDefinition.builder((String)"fetchPersistentState", (Object)false).xmlName("fetch-state").immutable().build();
    public static final AttributeDefinition<Boolean> PURGE_ON_STARTUP = AttributeDefinition.builder((String)"purgeOnStartup", (Object)false).immutable().xmlName("purge").build();
    public static final AttributeDefinition<Boolean> IGNORE_MODIFICATIONS = AttributeDefinition.builder((String)"ignoreModifications", (Object)false).immutable().xmlName("read-only").build();
    public static final AttributeDefinition<Boolean> PRELOAD = AttributeDefinition.builder((String)"preload", (Object)false).immutable().build();
    public static final AttributeDefinition<Boolean> SHARED = AttributeDefinition.builder((String)"shared", (Object)false).immutable().build();
    public static final AttributeDefinition<TypedProperties> PROPERTIES = AttributeDefinition.builder((String)"properties", null, TypedProperties.class).initializer(() -> new TypedProperties()).autoPersist(false).immutable().build();
    private final Attribute<Boolean> fetchPersistentState;
    private final Attribute<Boolean> purgeOnStartup;
    private final Attribute<Boolean> ignoreModifications;
    private final Attribute<Boolean> preload;
    private final Attribute<Boolean> shared;
    private final Attribute<TypedProperties> properties;
    protected final AttributeSet attributes;
    private final AsyncStoreConfiguration async;
    private final SingletonStoreConfiguration singletonStore;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AbstractStoreConfiguration.class, new AttributeDefinition[]{FETCH_PERSISTENT_STATE, PURGE_ON_STARTUP, IGNORE_MODIFICATIONS, PRELOAD, SHARED, PROPERTIES});
    }

    @Deprecated
    public AbstractStoreConfiguration(boolean purgeOnStartup, boolean fetchPersistentState, boolean ignoreModifications, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore, boolean preload, boolean shared, Properties properties) {
        this.attributes = AbstractStoreConfiguration.attributeDefinitionSet();
        this.attributes.attribute(PURGE_ON_STARTUP).set((Object)purgeOnStartup);
        this.attributes.attribute(FETCH_PERSISTENT_STATE).set((Object)fetchPersistentState);
        this.attributes.attribute(IGNORE_MODIFICATIONS).set((Object)ignoreModifications);
        this.attributes.attribute(PRELOAD).set((Object)preload);
        this.attributes.attribute(SHARED).set((Object)shared);
        this.attributes.attribute(PROPERTIES).set((Object)TypedProperties.toTypedProperties((Properties)properties));
        this.async = async;
        this.singletonStore = singletonStore;
        this.fetchPersistentState = this.attributes.attribute(FETCH_PERSISTENT_STATE);
        this.purgeOnStartup = this.attributes.attribute(PURGE_ON_STARTUP);
        this.ignoreModifications = this.attributes.attribute(IGNORE_MODIFICATIONS);
        this.preload = this.attributes.attribute(PRELOAD);
        this.shared = this.attributes.attribute(SHARED);
        this.properties = this.attributes.attribute(PROPERTIES);
    }

    public AbstractStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        this.attributes = attributes.checkProtection();
        this.async = async;
        this.singletonStore = singletonStore;
        this.fetchPersistentState = attributes.attribute(FETCH_PERSISTENT_STATE);
        this.purgeOnStartup = attributes.attribute(PURGE_ON_STARTUP);
        this.ignoreModifications = attributes.attribute(IGNORE_MODIFICATIONS);
        this.preload = attributes.attribute(PRELOAD);
        this.shared = attributes.attribute(SHARED);
        this.properties = attributes.attribute(PROPERTIES);
    }

    @Override
    public AsyncStoreConfiguration async() {
        return this.async;
    }

    @Override
    public SingletonStoreConfiguration singletonStore() {
        return this.singletonStore;
    }

    @Override
    public boolean purgeOnStartup() {
        return (Boolean)this.purgeOnStartup.get();
    }

    @Override
    public boolean shared() {
        return (Boolean)this.shared.get();
    }

    @Override
    public boolean fetchPersistentState() {
        return (Boolean)this.fetchPersistentState.get();
    }

    @Override
    public boolean ignoreModifications() {
        return (Boolean)this.ignoreModifications.get();
    }

    @Override
    public boolean preload() {
        return (Boolean)this.preload.get();
    }

    @Override
    public Properties properties() {
        return (Properties)this.properties.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "AbstractStoreConfiguration [attributes=" + this.attributes + ", async=" + this.async + ", singletonStore=" + this.singletonStore + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.async == null ? 0 : this.async.hashCode());
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.singletonStore == null ? 0 : this.singletonStore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractStoreConfiguration other = (AbstractStoreConfiguration)obj;
        if (this.async == null ? other.async != null : !this.async.equals(other.async)) {
            return false;
        }
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes)) {
            return false;
        }
        return !(this.singletonStore == null ? other.singletonStore != null : !this.singletonStore.equals(other.singletonStore));
    }
}

