/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.AbstractInvocationContextFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;

public class TransactionalInvocationContextFactory
extends AbstractInvocationContextFactory {
    private TransactionManager tm;
    private TransactionTable transactionTable;
    private BatchContainer batchContainer;
    private boolean batchingEnabled;

    @Inject
    public void init(TransactionManager tm, TransactionTable transactionTable, Configuration config, BatchContainer batchContainer, AsyncInterceptorChain interceptorChain) {
        super.init(config, interceptorChain);
        this.tm = tm;
        this.transactionTable = transactionTable;
        this.batchContainer = batchContainer;
        this.batchingEnabled = config.invocationBatching().enabled();
    }

    @Override
    public NonTxInvocationContext createNonTxInvocationContext() {
        return this.newNonTxInvocationContext(null);
    }

    @Override
    public InvocationContext createSingleKeyNonTxInvocationContext() {
        return new SingleKeyNonTxInvocationContext(null, (Equivalence<Object>)this.keyEq);
    }

    @Override
    public InvocationContext createInvocationContext(boolean isWrite, int keyCount) {
        Transaction runningTx = this.getRunningTx();
        if (runningTx == null && !isWrite) {
            if (keyCount == 1) {
                return this.createSingleKeyNonTxInvocationContext();
            }
            return this.newNonTxInvocationContext(null);
        }
        return this.createInvocationContext(runningTx, false);
    }

    @Override
    public InvocationContext createInvocationContext(Transaction tx, boolean implicitTransaction) {
        if (tx == null) {
            throw new IllegalArgumentException("Cannot create a transactional context without a valid Transaction instance.");
        }
        LocalTransaction localTransaction = this.transactionTable.getOrCreateLocalTransaction(tx, implicitTransaction);
        return new LocalTxInvocationContext(localTransaction);
    }

    @Override
    public LocalTxInvocationContext createTxInvocationContext(LocalTransaction localTransaction) {
        return new LocalTxInvocationContext(localTransaction);
    }

    @Override
    public RemoteTxInvocationContext createRemoteTxInvocationContext(RemoteTransaction tx, Address origin) {
        RemoteTxInvocationContext ctx = new RemoteTxInvocationContext(tx);
        return ctx;
    }

    @Override
    public NonTxInvocationContext createRemoteInvocationContext(Address origin) {
        return this.newNonTxInvocationContext(origin);
    }

    private Transaction getRunningTx() {
        try {
            Transaction transaction = null;
            if (this.batchingEnabled) {
                transaction = this.batchContainer.getBatchTransaction();
            }
            if (transaction == null) {
                transaction = this.tm.getTransaction();
            }
            return transaction;
        }
        catch (SystemException e) {
            throw new CacheException((Throwable)e);
        }
    }

    protected final NonTxInvocationContext newNonTxInvocationContext(Address origin) {
        NonTxInvocationContext ctx = new NonTxInvocationContext(origin, (Equivalence<Object>)this.keyEq);
        return ctx;
    }
}

