/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.CancelCommand;
import org.infinispan.commands.CancellationService;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distexec.DistributedExecutionCompletionService;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.distexec.DistributedTask;
import org.infinispan.distexec.DistributedTaskBuilder;
import org.infinispan.distexec.DistributedTaskExecutionPolicy;
import org.infinispan.distexec.DistributedTaskFailoverPolicy;
import org.infinispan.distexec.FailoverContext;
import org.infinispan.distexec.SecurityActions;
import org.infinispan.distexec.spi.DistributedTaskLifecycleService;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DefaultExecutorService
extends AbstractExecutorService
implements DistributedExecutorService {
    private static final NodeFilter SAME_MACHINE_FILTER = new NodeFilter(){

        @Override
        public boolean include(TopologyAwareAddress thisAddress, TopologyAwareAddress otherAddress) {
            return thisAddress.isSameMachine(otherAddress);
        }
    };
    private static final NodeFilter SAME_RACK_FILTER = new NodeFilter(){

        @Override
        public boolean include(TopologyAwareAddress thisAddress, TopologyAwareAddress otherAddress) {
            return thisAddress.isSameRack(otherAddress);
        }
    };
    private static final NodeFilter SAME_SITE_FILTER = new NodeFilter(){

        @Override
        public boolean include(TopologyAwareAddress thisAddress, TopologyAwareAddress otherAddress) {
            return thisAddress.isSameSite(otherAddress);
        }
    };
    private static final NodeFilter ALL_FILTER = new NodeFilter(){

        @Override
        public boolean include(TopologyAwareAddress thisAddress, TopologyAwareAddress otherAddress) {
            return true;
        }
    };
    public static final DistributedTaskFailoverPolicy NO_FAILOVER = new NoTaskFailoverPolicy();
    public static final DistributedTaskFailoverPolicy RANDOM_NODE_FAILOVER = new RandomNodeTaskFailoverPolicy();
    private static final Log log = LogFactory.getLog(DefaultExecutorService.class);
    private static final boolean trace = log.isTraceEnabled();
    protected final AtomicBoolean isShutdown;
    protected final AdvancedCache cache;
    protected final RpcManager rpc;
    protected final AsyncInterceptorChain invoker;
    protected final CommandsFactory factory;
    protected final Marshaller marshaller;
    protected final ExecutorService localExecutorService;
    protected final CancellationService cancellationService;
    protected final ClusteringDependentLogic clusterDependentLogic;
    protected final boolean takeExecutorOwnership;
    private final TimeService timeService;

    public DefaultExecutorService(Cache<?, ?> masterCacheNode) {
        this(masterCacheNode, Executors.newSingleThreadExecutor(), true);
    }

    public DefaultExecutorService(Cache<?, ?> masterCacheNode, ExecutorService localExecutorService) {
        this(masterCacheNode, localExecutorService, false);
    }

    public DefaultExecutorService(Cache<?, ?> masterCacheNode, ExecutorService localExecutorService, boolean takeExecutorOwnership) {
        block5: {
            this.isShutdown = new AtomicBoolean(false);
            if (masterCacheNode == null) {
                throw new IllegalArgumentException("Can not use null cache for DefaultExecutorService");
            }
            if (localExecutorService == null) {
                throw new IllegalArgumentException("Can not use null instance of ExecutorService");
            }
            try {
                if (localExecutorService.isShutdown()) {
                    throw new IllegalArgumentException("Can not use an instance of ExecutorService which is shutdown");
                }
            }
            catch (IllegalStateException e) {
                if (!takeExecutorOwnership) break block5;
                throw new IllegalArgumentException("Can not take ownership of a ManagedExecutorService");
            }
        }
        this.cache = masterCacheNode.getAdvancedCache();
        ComponentRegistry registry = SecurityActions.getCacheComponentRegistry(this.cache);
        this.ensureAccessPermissions(this.cache);
        this.ensureProperCacheState(this.cache);
        this.ensureFullCache(this.cache);
        this.rpc = SecurityActions.getCacheRpcManager(this.cache);
        this.invoker = registry.getComponent(AsyncInterceptorChain.class);
        this.factory = registry.getComponent(CommandsFactory.class);
        this.marshaller = (Marshaller)registry.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
        this.cancellationService = registry.getComponent(CancellationService.class);
        this.localExecutorService = localExecutorService;
        this.takeExecutorOwnership = takeExecutorOwnership;
        this.timeService = registry.getTimeService();
        this.clusterDependentLogic = registry.getComponent(ClusteringDependentLogic.class);
    }

    @Override
    public <T> DistributedTaskBuilder<T> createDistributedTaskBuilder(Callable<T> callable) {
        Configuration cacheConfiguration = SecurityActions.getCacheConfiguration(this.cache);
        long to = cacheConfiguration.clustering().remoteTimeout();
        DefaultDistributedTaskBuilder<T> dtb = new DefaultDistributedTaskBuilder<T>(to);
        dtb.callable(callable);
        return dtb;
    }

    public <T> CompletableFuture<T> submit(Runnable task, T result) {
        return (CompletableFuture)super.submit(task, result);
    }

    public <T> CompletableFuture<T> submit(Callable<T> task) {
        return (CompletableFuture)super.submit(task);
    }

    @Override
    public void shutdown() {
        this.realShutdown(false);
    }

    protected List<Address> getMembers() {
        if (this.rpc != null) {
            return this.rpc.getMembers();
        }
        return Collections.singletonList(this.getAddress());
    }

    protected <T> List<Address> executionCandidates(DistributedTask<T> task) {
        return this.filterMembers(task.getTaskExecutionPolicy(), this.getMembers());
    }

    private Address getAddress() {
        return this.clusterDependentLogic.getAddress();
    }

    private List<Runnable> realShutdown(boolean interrupt) {
        this.isShutdown.set(true);
        if (this.takeExecutorOwnership) {
            if (interrupt) {
                this.localExecutorService.shutdownNow();
            } else {
                this.localExecutorService.shutdown();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.realShutdown(true);
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown.get();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(tasks, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(tasks, true, unit.toNanos(timeout));
    }

    private <T> T doInvokeAny(Collection<? extends Callable<T>> tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException ee;
        ArrayList<Future<T>> futures;
        block18: {
            if (tasks == null) {
                throw new NullPointerException();
            }
            int ntasks = tasks.size();
            if (ntasks == 0) {
                throw new IllegalArgumentException();
            }
            futures = new ArrayList<Future<T>>(ntasks);
            DistributedExecutionCompletionService<T> ecs = new DistributedExecutionCompletionService<T>(this);
            ee = null;
            long lastTime = timed ? this.timeService.time() : 0L;
            Iterator<Callable<T>> it = tasks.iterator();
            futures.add(ecs.submit(it.next()));
            --ntasks;
            int active = 1;
            while (true) {
                Object now22;
                Future f;
                if ((f = ecs.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(ecs.submit(it.next()));
                        ++active;
                    } else {
                        if (active == 0) break;
                        if (timed) {
                            f = ecs.poll(nanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            long now22 = this.timeService.time();
                            nanos -= this.timeService.timeDuration(lastTime, now22, TimeUnit.NANOSECONDS);
                            lastTime = now22;
                        } else {
                            f = ecs.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    now22 = f.get();
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (ExecutionException eex) {
                    ee = eex;
                    continue;
                }
                catch (RuntimeException rex) {
                    ee = new ExecutionException(rex);
                    continue;
                }
                return (T)now22;
                break;
            }
            if (ee != null) break block18;
            ee = new ExecutionException(){
                private static final long serialVersionUID = 200818694545553992L;
            };
        }
        throw ee;
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Runnable command) {
        DistributedTaskPart cmd;
        if (this.isShutdown.get()) throw new RejectedExecutionException();
        if (command instanceof DistributedTaskPart) {
            cmd = (DistributedTaskPart)command;
        } else {
            if (!(command instanceof Serializable)) throw new IllegalArgumentException("Runnable command is not Serializable  " + command);
            cmd = (DistributedTaskPart)this.newTaskFor(command, null);
        }
        cmd.execute();
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableAdapter<T> adapter = new RunnableAdapter<T>(runnable, value);
        return this.newTaskFor(adapter);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        DistributedTaskBuilder<T> distributedTaskBuilder = this.createDistributedTaskBuilder(callable);
        DistributedTask<T> task = distributedTaskBuilder.build();
        DistributedExecuteCommand<T> executeCommand = this.factory.buildDistributedExecuteCommand(callable, this.getAddress(), null);
        return this.createDistributedTaskPart(task, executeCommand, this.selectExecutionNode(task), 0);
    }

    @Override
    public <T> CompletableFuture<T> submit(Address target, Callable<T> task) {
        DistributedTaskBuilder<T> distributedTaskBuilder = this.createDistributedTaskBuilder(task);
        DistributedTask<T> distributedTask = distributedTaskBuilder.build();
        return this.submit(target, distributedTask);
    }

    @Override
    public <T> CompletableFuture<T> submit(Address target, DistributedTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (target == null) {
            throw new NullPointerException();
        }
        List<Address> members = this.getMembers();
        if (!members.contains(target)) {
            return CompletableFutures.completedExceptionFuture((Throwable)((Object)new SuspectException("Target node " + target + " is not a cluster member, members are " + members)));
        }
        Address me = this.getAddress();
        DistributedExecuteCommand<T> c = null;
        c = target.equals(me) ? this.factory.buildDistributedExecuteCommand(this.clone(task.getCallable()), me, null) : this.factory.buildDistributedExecuteCommand(task.getCallable(), me, null);
        DistributedTaskPart<T> part = this.createDistributedTaskPart(task, c, target, 0);
        part.execute();
        return part;
    }

    @Override
    public <T, K> CompletableFuture<T> submit(Callable<T> task, K ... input) {
        DistributedTaskBuilder<T> distributedTaskBuilder = this.createDistributedTaskBuilder(task);
        DistributedTask<T> distributedTask = distributedTaskBuilder.build();
        return this.submit(distributedTask, input);
    }

    @Override
    public <T, K> CompletableFuture<T> submit(DistributedTask<T> task, K ... input) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.inputKeysSpecified(input)) {
            Map<Address, List<K>> nodesKeysMap = this.keysToExecutionNodes(task.getTaskExecutionPolicy(), input);
            this.checkExecutionPolicy(task, nodesKeysMap, input);
            Address me = this.getAddress();
            DistributedExecuteCommand<T> c = this.factory.buildDistributedExecuteCommand(task.getCallable(), me, Arrays.asList(input));
            ArrayList<Address> nodes = new ArrayList<Address>(nodesKeysMap.keySet());
            DistributedTaskPart<T> part = this.createDistributedTaskPart(task, c, Arrays.asList(input), this.selectExecutionNode(nodes), 0);
            part.execute();
            return part;
        }
        return this.submit((Callable)task.getCallable());
    }

    @Override
    public <T> List<CompletableFuture<T>> submitEverywhere(Callable<T> task) {
        DistributedTaskBuilder<T> distributedTaskBuilder = this.createDistributedTaskBuilder(task);
        DistributedTask<T> distributedTask = distributedTaskBuilder.build();
        return this.submitEverywhere(distributedTask);
    }

    @Override
    public <T> List<CompletableFuture<T>> submitEverywhere(DistributedTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        List<Address> members = this.executionCandidates(task);
        ArrayList<CompletableFuture<T>> futures = new ArrayList<CompletableFuture<T>>(members.size());
        Address me = this.getAddress();
        for (Address target : members) {
            DistributedExecuteCommand<T> c = null;
            c = target.equals(me) ? this.factory.buildDistributedExecuteCommand(this.clone(task.getCallable()), me, null) : this.factory.buildDistributedExecuteCommand(task.getCallable(), me, null);
            DistributedTaskPart<T> part = this.createDistributedTaskPart(task, c, target, 0);
            futures.add(part);
            part.execute();
        }
        return futures;
    }

    @Override
    public <T, K> List<CompletableFuture<T>> submitEverywhere(Callable<T> task, K ... input) {
        DistributedTaskBuilder<T> distributedTaskBuilder = this.createDistributedTaskBuilder(task);
        DistributedTask<T> distributedTask = distributedTaskBuilder.build();
        return this.submitEverywhere(distributedTask, input);
    }

    @Override
    public <T, K> List<CompletableFuture<T>> submitEverywhere(DistributedTask<T> task, K ... input) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.inputKeysSpecified(input)) {
            ArrayList<CompletableFuture<T>> futures = new ArrayList<CompletableFuture<T>>(input.length * 2);
            Address me = this.getAddress();
            Map<Address, List<K>> nodesKeysMap = this.keysToExecutionNodes(task.getTaskExecutionPolicy(), input);
            this.checkExecutionPolicy(task, nodesKeysMap, input);
            for (Map.Entry<Address, List<K>> e : nodesKeysMap.entrySet()) {
                Address target = e.getKey();
                DistributedExecuteCommand<T> c = null;
                c = target.equals(me) ? this.factory.buildDistributedExecuteCommand(this.clone(task.getCallable()), me, e.getValue()) : this.factory.buildDistributedExecuteCommand(task.getCallable(), me, e.getValue());
                DistributedTaskPart<T> part = this.createDistributedTaskPart(task, c, e.getValue(), target, 0);
                futures.add(part);
                part.execute();
            }
            return futures;
        }
        return this.submitEverywhere(task);
    }

    protected <T> Callable<T> clone(Callable<T> task) {
        return (Callable)Util.cloneWithMarshaller((Marshaller)this.marshaller, task);
    }

    protected <T, K> DistributedTaskPart<T> createDistributedTaskPart(DistributedTask<T> task, DistributedExecuteCommand<T> c, List<K> inputKeys, Address target, int failoverCount) {
        return this.getAddress().equals(target) ? new LocalDistributedTaskPart<T>(task, c, inputKeys, failoverCount) : new RemoteDistributedTaskPart<T>(task, c, inputKeys, target, failoverCount);
    }

    protected <T, K> DistributedTaskPart<T> createDistributedTaskPart(DistributedTask<T> task, DistributedExecuteCommand<T> c, Address target, int failoverCount) {
        return this.createDistributedTaskPart(task, c, Collections.emptyList(), target, failoverCount);
    }

    private <T, K> void checkExecutionPolicy(DistributedTask<T> task, Map<Address, List<K>> nodesKeysMap, K ... input) {
        if (nodesKeysMap == null || nodesKeysMap.isEmpty()) {
            throw new IllegalStateException("DistributedTaskExecutionPolicy " + (Object)((Object)task.getTaskExecutionPolicy()) + " for task " + task + " returned invalid keysToExecutionNodes " + nodesKeysMap + " execution policy plan for a given input " + Arrays.toString(input));
        }
    }

    private <K> boolean inputKeysSpecified(K ... input) {
        return input != null && input.length > 0;
    }

    protected Address selectExecutionNode(List<Address> candidates) {
        List<Address> list = this.randomClusterMembers(candidates, 1);
        return list.get(0);
    }

    protected <T> Address selectExecutionNode(DistributedTask<T> task) {
        return this.selectExecutionNode(this.executionCandidates(task));
    }

    protected List<Address> randomClusterMembers(List<Address> members, int numNeeded) {
        if (members == null || members.isEmpty()) {
            throw new IllegalArgumentException("Invalid member list " + members);
        }
        if (members.size() < numNeeded) {
            log.cannotSelectRandomMembers(numNeeded, members);
            numNeeded = members.size();
        }
        ArrayList<Address> membersCopy = new ArrayList<Address>(members);
        ArrayList<Address> chosen = new ArrayList<Address>(numNeeded);
        Random r = new Random();
        while (!membersCopy.isEmpty() && numNeeded >= chosen.size()) {
            int count = membersCopy.size();
            Address address = (Address)membersCopy.remove(r.nextInt(count));
            chosen.add(address);
        }
        return chosen;
    }

    protected <K> Map<Address, List<K>> keysToExecutionNodes(DistributedTaskExecutionPolicy policy, K ... input) {
        DistributionManager dm = this.cache.getDistributionManager();
        HashMap<Address, List<Address>> addressToKey = new HashMap<Address, List<Address>>(input.length * 2);
        boolean usingREPLMode = dm == null;
        for (K key : input) {
            Address ownerOfKey = null;
            if (usingREPLMode) {
                List<Address> members = new ArrayList<Address>(this.getMembers());
                members = this.filterMembers(policy, members);
                Collections.shuffle(members);
                ownerOfKey = members.get(0);
            } else {
                List<Address> owners = dm.locate(key);
                List<Address> filtered = this.filterMembers(policy, owners);
                ownerOfKey = !filtered.isEmpty() ? filtered.get(0) : owners.get(0);
            }
            LinkedList<K> keysAtNode = (LinkedList<K>)addressToKey.get(ownerOfKey);
            if (keysAtNode == null) {
                keysAtNode = new LinkedList<K>();
                addressToKey.put(ownerOfKey, keysAtNode);
            }
            keysAtNode.add(key);
        }
        return addressToKey;
    }

    private List<Address> filterMembers(DistributedTaskExecutionPolicy policy, List<Address> members) {
        NodeFilter filter = null;
        switch (policy) {
            case SAME_MACHINE: {
                filter = SAME_MACHINE_FILTER;
                break;
            }
            case SAME_SITE: {
                filter = SAME_SITE_FILTER;
                break;
            }
            case SAME_RACK: {
                filter = SAME_RACK_FILTER;
                break;
            }
            case ALL: {
                filter = ALL_FILTER;
                break;
            }
            default: {
                filter = ALL_FILTER;
            }
        }
        ArrayList<Address> result = new ArrayList<Address>();
        for (Address address : members) {
            if (address instanceof TopologyAwareAddress) {
                TopologyAwareAddress taa = (TopologyAwareAddress)address;
                if (!filter.include(taa, (TopologyAwareAddress)this.getAddress())) continue;
                result.add(address);
                continue;
            }
            result.add(address);
        }
        return result;
    }

    private void ensureAccessPermissions(AdvancedCache<?, ?> cache) {
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager(cache);
        if (authorizationManager != null) {
            authorizationManager.checkPermission(AuthorizationPermission.EXEC);
        }
    }

    private void ensureProperCacheState(AdvancedCache<?, ?> cache) throws NullPointerException, IllegalStateException {
        if (cache.getStatus() != ComponentStatus.RUNNING && cache.getStatus() != ComponentStatus.INITIALIZING) {
            throw new IllegalStateException("Invalid cache state " + (Object)((Object)cache.getStatus()));
        }
    }

    private void ensureFullCache(AdvancedCache<?, ?> cache) {
        List<AsyncInterceptor> interceptors = SecurityActions.getInterceptorChain(cache);
        if (interceptors == null || interceptors.isEmpty()) {
            throw log.distributedExecutorsNotSupported();
        }
    }

    private static final class RunnableAdapter<T>
    implements Callable<T>,
    Serializable {
        private static final long serialVersionUID = 6629286923873531028L;
        protected Runnable task;
        protected T result;

        protected RunnableAdapter() {
        }

        protected RunnableAdapter(Runnable task, T result) {
            this.task = task;
            this.result = result;
        }

        @Override
        public T call() {
            this.task.run();
            return this.result;
        }
    }

    private class LocalDistributedTaskPart<V>
    extends DistributedTaskPart<V> {
        public LocalDistributedTaskPart(DistributedTask<V> task, DistributedExecuteCommand<V> command, List<Object> inputKeys, int failoverCount) {
            super(inputKeys, command, task, failoverCount);
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.isCancelled() && super.cancel(true)) {
                CancelCommand ccc = DefaultExecutorService.this.factory.buildCancelCommandCommand(this.distCommand.getUUID());
                ccc.init(DefaultExecutorService.this.cancellationService);
                try {
                    ccc.perform(null);
                }
                catch (Throwable e) {
                    log.couldNotExecuteCancellationLocally(e.getLocalizedMessage());
                }
                return true;
            }
            return false;
        }

        @Override
        public Address getExecutionTarget() {
            return DefaultExecutorService.this.getAddress();
        }

        @Override
        public void execute() {
            log.debugf("Sending %s to self", this);
            try {
                Callable call = new Callable<V>(){

                    @Override
                    public V call() throws Exception {
                        LocalDistributedTaskPart.this.getCommand().init(DefaultExecutorService.this.cache);
                        DistributedTaskLifecycleService lifecycle = DistributedTaskLifecycleService.getInstance();
                        try {
                            lifecycle.onPreExecute(LocalDistributedTaskPart.this.getCommand().getCallable(), DefaultExecutorService.this.cache);
                            DefaultExecutorService.this.cancellationService.register(Thread.currentThread(), LocalDistributedTaskPart.this.getCommand().getUUID());
                            Object result = LocalDistributedTaskPart.this.getCommand().perform(null);
                            LocalDistributedTaskPart.this.complete(result);
                            Object v = result;
                            return v;
                        }
                        catch (Exception e) {
                            LocalDistributedTaskPart.this.completeExceptionally(e);
                            throw e;
                        }
                        finally {
                            lifecycle.onPostExecute(LocalDistributedTaskPart.this.getCommand().getCallable());
                            DefaultExecutorService.this.cancellationService.unregister(LocalDistributedTaskPart.this.getCommand().getUUID());
                        }
                    }
                };
                DefaultExecutorService.this.localExecutorService.submit(call);
            }
            catch (Throwable e1) {
                log.localExecutionFailed(e1);
            }
        }
    }

    private class RemoteDistributedTaskPart<V>
    extends DistributedTaskPart<V> {
        private final Address executionTarget;

        public RemoteDistributedTaskPart(DistributedTask<V> task, DistributedExecuteCommand<V> command, List<Object> inputKeys, Address executionTarget, int failoverCount) {
            super(inputKeys, command, task, failoverCount);
            if (DefaultExecutorService.this.getAddress().equals(executionTarget)) {
                throw new IllegalArgumentException("This task should be executed as local.");
            }
            this.executionTarget = executionTarget;
        }

        @Override
        public Address getExecutionTarget() {
            return this.executionTarget;
        }

        @Override
        public void execute() {
            if (trace) {
                log.tracef("Sending %s to remote execution at node %s", this, this.getExecutionTarget());
            }
            try {
                DefaultExecutorService.this.rpc.invokeRemotelyAsync(Collections.singletonList(this.getExecutionTarget()), this.getCommand(), DefaultExecutorService.this.rpc.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS).timeout(this.getOwningTask().timeout(), TimeUnit.MILLISECONDS).build()).whenComplete((T v, U t) -> {
                    if (t != null) {
                        this.completeExceptionally((Throwable)t);
                    } else {
                        try {
                            this.complete(this.retrieveResult((Map<Address, Response>)v));
                        }
                        catch (Exception e) {
                            this.completeExceptionally(e);
                        }
                    }
                });
            }
            catch (Throwable e) {
                log.remoteExecutionFailed(this.getExecutionTarget(), e);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.isCancelled() && super.cancel(true)) {
                CancelCommand ccc = DefaultExecutorService.this.factory.buildCancelCommandCommand(this.distCommand.getUUID());
                DefaultExecutorService.this.rpc.invokeRemotely(Collections.singletonList(this.getExecutionTarget()), ccc, DefaultExecutorService.this.rpc.getDefaultRpcOptions(true));
                return true;
            }
            return false;
        }

        private V retrieveResult(Map<Address, Response> response) throws Exception {
            Object result = null;
            if (response == null) {
                throw new IllegalStateException("Invalid response received " + response);
            }
            if (response.size() == 1) {
                for (Map.Entry<Address, Response> e : response.entrySet()) {
                    Response value = e.getValue();
                    if (value instanceof SuccessfulResponse) {
                        result = ((SuccessfulResponse)value).getResponseValue();
                        continue;
                    }
                    throw new ExecutionException(new Exception(value != null ? value.toString() : "Unknown cause"));
                }
            } else {
                throw new IllegalStateException("Invalid response " + response);
            }
            return (V)result;
        }
    }

    private abstract class DistributedTaskPart<V>
    extends CompletableFuture<V>
    implements RunnableFuture<V> {
        protected final DistributedExecuteCommand<V> distCommand;
        private final List<Object> inputKeys;
        private final DistributedTask<V> owningTask;
        private int failedOverCount;
        private volatile boolean cancelled;

        protected DistributedTaskPart(List<Object> inputKeys, DistributedExecuteCommand<V> command, DistributedTask<V> task, int failedOverCount) {
            this.inputKeys = inputKeys;
            this.distCommand = command;
            this.owningTask = task;
            this.failedOverCount = failedOverCount;
        }

        public List<Object> getInputKeys() {
            return this.inputKeys;
        }

        public DistributedExecuteCommand<V> getCommand() {
            return this.distCommand;
        }

        public DistributedTask<V> getOwningTask() {
            return this.owningTask;
        }

        public abstract Address getExecutionTarget();

        public abstract void execute();

        @Override
        public V get() throws InterruptedException, ExecutionException {
            try {
                return this.innerGet(0L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.innerGet(timeout, unit);
        }

        protected V innerGet(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException, InterruptedException {
            if (this.isCancelled()) {
                throw new CancellationException("Task already cancelled");
            }
            long timeoutNanos = this.computeTimeoutNanos(timeout, unit);
            try {
                return this.getResult(timeoutNanos);
            }
            catch (TimeoutException te) {
                throw te;
            }
            catch (Exception e) {
                boolean canFailover;
                if (e instanceof ExecutionException && e.getCause() instanceof org.infinispan.util.concurrent.TimeoutException) {
                    if (trace) {
                        log.tracef("Distributed task timed out, throwing a TimeoutException and ignoring exception", e);
                    }
                    throw new TimeoutException();
                }
                boolean bl = canFailover = this.failedOverCount++ < this.getOwningTask().getTaskFailoverPolicy().maxFailoverAttempts();
                if (canFailover) {
                    try {
                        return this.failoverExecution(e, timeoutNanos, TimeUnit.NANOSECONDS);
                    }
                    catch (Exception failedOver) {
                        throw this.wrapIntoExecutionException(failedOver);
                    }
                }
                throw this.wrapIntoExecutionException(e);
            }
        }

        protected V getResult(long timeoutNanos) throws Exception {
            if (timeoutNanos > 0L) {
                return (V)super.get(timeoutNanos, TimeUnit.NANOSECONDS);
            }
            return (V)super.get();
        }

        protected long computeTimeoutNanos(long timeout, TimeUnit unit) {
            long taskTimeout = TimeUnit.MILLISECONDS.toNanos(this.getOwningTask().timeout());
            long futureTimeout = TimeUnit.NANOSECONDS.convert(timeout, unit);
            long actualTimeout = taskTimeout > 0L && futureTimeout > 0L ? Math.min(taskTimeout, futureTimeout) : Math.max(taskTimeout, futureTimeout);
            return actualTimeout;
        }

        protected ExecutionException wrapIntoExecutionException(Exception e) {
            if (e instanceof ExecutionException) {
                return (ExecutionException)e;
            }
            return new ExecutionException(e);
        }

        protected V failoverExecution(final Exception cause, long timeout, TimeUnit unit) throws Exception {
            final List<Address> executionCandidates = DefaultExecutorService.this.executionCandidates(this.getOwningTask());
            FailoverContext fc = new FailoverContext(){

                @Override
                public <K> List<K> inputKeys() {
                    return DistributedTaskPart.this.getInputKeys();
                }

                @Override
                public Address executionFailureLocation() {
                    return DistributedTaskPart.this.getExecutionTarget();
                }

                @Override
                public List<Address> executionCandidates() {
                    return executionCandidates;
                }

                @Override
                public Throwable cause() {
                    return cause;
                }
            };
            Address failoverTarget = this.getOwningTask().getTaskFailoverPolicy().failover(fc);
            log.distributedTaskFailover(fc.executionFailureLocation(), failoverTarget, cause);
            DistributedTaskPart<V> part = DefaultExecutorService.this.createDistributedTaskPart(this.owningTask, this.distCommand, this.getInputKeys(), failoverTarget, this.failedOverCount);
            part.execute();
            return part.get(timeout, unit);
        }

        @Override
        public void run() {
            this.execute();
        }
    }

    private class DefaultDistributedTaskBuilder<T>
    implements DistributedTaskBuilder<T>,
    DistributedTask<T> {
        private Callable<T> callable;
        private long timeout;
        private DistributedTaskExecutionPolicy executionPolicy = DistributedTaskExecutionPolicy.ALL;
        private DistributedTaskFailoverPolicy failoverPolicy = NO_FAILOVER;

        public DefaultDistributedTaskBuilder(long taskTimeout) {
            this.timeout = taskTimeout;
        }

        @Override
        public DistributedTaskBuilder<T> callable(Callable<T> callable) {
            if (callable == null) {
                throw new IllegalArgumentException("Callable cannot be null");
            }
            this.callable = callable;
            return this;
        }

        @Override
        public DistributedTaskBuilder<T> timeout(long t, TimeUnit tu) {
            this.timeout = TimeUnit.MILLISECONDS.convert(t, tu);
            return this;
        }

        @Override
        public DistributedTaskBuilder<T> executionPolicy(DistributedTaskExecutionPolicy policy) {
            if (policy == null) {
                throw new IllegalArgumentException("DistributedTaskExecutionPolicy cannot be null");
            }
            this.executionPolicy = policy;
            return this;
        }

        @Override
        public DistributedTaskBuilder<T> failoverPolicy(DistributedTaskFailoverPolicy policy) {
            this.failoverPolicy = policy == null ? NO_FAILOVER : policy;
            return this;
        }

        @Override
        public DistributedTask<T> build() {
            DefaultDistributedTaskBuilder<T> task = new DefaultDistributedTaskBuilder<T>(this.timeout);
            task.callable(this.callable);
            task.executionPolicy(this.executionPolicy);
            task.failoverPolicy(this.failoverPolicy);
            return task;
        }

        @Override
        public long timeout() {
            return this.timeout;
        }

        @Override
        public DistributedTaskExecutionPolicy getTaskExecutionPolicy() {
            return this.executionPolicy;
        }

        @Override
        public DistributedTaskFailoverPolicy getTaskFailoverPolicy() {
            return this.failoverPolicy;
        }

        @Override
        public Callable<T> getCallable() {
            return this.callable;
        }
    }

    static interface NodeFilter {
        public boolean include(TopologyAwareAddress var1, TopologyAwareAddress var2);
    }

    private static class NoTaskFailoverPolicy
    implements DistributedTaskFailoverPolicy {
        @Override
        public Address failover(FailoverContext fc) {
            return fc.executionFailureLocation();
        }

        @Override
        public int maxFailoverAttempts() {
            return 0;
        }
    }

    private static class RandomNodeTaskFailoverPolicy
    implements DistributedTaskFailoverPolicy {
        @Override
        public Address failover(FailoverContext fc) {
            return this.randomNode(fc.executionCandidates(), fc.executionFailureLocation());
        }

        protected Address randomNode(List<Address> candidates, Address failedExecutionLocation) {
            Random r = new Random();
            candidates.remove(failedExecutionLocation);
            if (candidates.isEmpty()) {
                throw new IllegalStateException("There are no candidates for failover: " + candidates);
            }
            int tIndex = r.nextInt(candidates.size());
            return candidates.get(tIndex);
        }

        @Override
        public int maxFailoverAttempts() {
            return 1;
        }
    }
}

