/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.compat;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Util;
import org.infinispan.compat.TypeConverter;
import org.infinispan.context.Flag;
import org.infinispan.interceptors.compat.BaseTypeConverterInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TypeConverterInterceptor<K, V>
extends BaseTypeConverterInterceptor<K, V> {
    private TypeConverter<Object, Object, Object, Object> hotRodConverter;
    private TypeConverter<Object, Object, Object, Object> memcachedConverter;
    private TypeConverter<Object, Object, Object, Object> embeddedConverter;

    public TypeConverterInterceptor(Marshaller marshaller) {
        Collection converters = ServiceFinder.load(TypeConverter.class, (ClassLoader[])new ClassLoader[0]);
        for (TypeConverter converter : converters) {
            if (converter.supportsInvocation(Flag.OPERATION_HOTROD)) {
                this.hotRodConverter = this.setConverterMarshaller(converter, marshaller);
                continue;
            }
            if (!converter.supportsInvocation(Flag.OPERATION_MEMCACHED)) continue;
            this.memcachedConverter = this.setConverterMarshaller(converter, marshaller);
        }
        this.embeddedConverter = this.setConverterMarshaller(new EmbeddedTypeConverter(), marshaller);
    }

    private TypeConverter setConverterMarshaller(TypeConverter converter, Marshaller marshaller) {
        if (marshaller != null) {
            converter.setMarshaller(marshaller);
        }
        return converter;
    }

    @Override
    protected TypeConverter<Object, Object, Object, Object> determineTypeConverter(Set<Flag> flags) {
        if (flags != null) {
            if (flags.contains((Object)Flag.OPERATION_HOTROD)) {
                return this.hotRodConverter;
            }
            if (flags.contains((Object)Flag.OPERATION_MEMCACHED)) {
                return this.memcachedConverter;
            }
        }
        return this.embeddedConverter;
    }

    private static class EmbeddedTypeConverter
    implements TypeConverter<Object, Object, Object, Object> {
        private static final Log log = LogFactory.getLog(EmbeddedTypeConverter.class);
        private Marshaller marshaller;

        private EmbeddedTypeConverter() {
        }

        @Override
        public Object boxKey(Object key) {
            return key;
        }

        @Override
        public Object boxValue(Object value) {
            return value;
        }

        @Override
        public Object unboxKey(Object target) {
            return this.unboxValue(target);
        }

        @Override
        public Object unboxValue(Object target) {
            block6: {
                if (this.marshaller != null && target instanceof byte[]) {
                    try {
                        return this.marshaller.objectFromByteBuffer((byte[])target);
                    }
                    catch (Exception e) {
                        throw new CacheException("Unable to unmarshall return value");
                    }
                }
                if (target instanceof byte[]) {
                    try {
                        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream((byte[])target));
                        return ois.readObject();
                    }
                    catch (Exception ee) {
                        if (!log.isDebugEnabled()) break block6;
                        log.debugf("Standard deserialization not in use for %s", Util.printArray((byte[])((byte[])target)));
                    }
                }
            }
            return target;
        }

        @Override
        public boolean supportsInvocation(Flag flag) {
            return false;
        }

        @Override
        public void setMarshaller(Marshaller marshaller) {
            this.marshaller = marshaller;
        }
    }
}

