/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.totalorder;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderPrepareCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TotalOrderRemoteTransactionState;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.totalorder.TotalOrderManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TotalOrderInterceptor
extends DDAsyncInterceptor {
    private static final Log log = LogFactory.getLog(TotalOrderInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private TransactionTable transactionTable;
    private TotalOrderManager totalOrderManager;
    private ClusteringDependentLogic clusteringDependentLogic;
    private BlockingTaskAwareExecutorService executorService;

    @Inject
    public void inject(TransactionTable transactionTable, TotalOrderManager totalOrderManager, ClusteringDependentLogic clusteringDependentLogic, @ComponentName(value="org.infinispan.executors.remote") BlockingTaskAwareExecutorService executorService) {
        this.transactionTable = transactionTable;
        this.totalOrderManager = totalOrderManager;
        this.clusteringDependentLogic = clusteringDependentLogic;
        this.executorService = executorService;
    }

    @Override
    public final CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debugf("Prepare received. Transaction=%s, Affected keys=%s, Local=%s", command.getGlobalTransaction().globalId(), Util.toStr(command.getAffectedKeys()), ctx.isOriginLocal());
        }
        if (!(command instanceof TotalOrderPrepareCommand)) {
            throw new IllegalStateException("TotalOrderInterceptor can only handle TotalOrderPrepareCommand");
        }
        TotalOrderRemoteTransactionState state = this.getTransactionState(ctx);
        ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                PrepareCommand prepareCommand = (PrepareCommand)rCommand;
                if (log.isDebugEnabled()) {
                    log.debugf(throwable, "Exception while preparing for transaction %s. Local=%s", prepareCommand.getGlobalTransaction().globalId(), rCtx.isOriginLocal());
                }
                if (prepareCommand.isOnePhaseCommit()) {
                    this.transactionTable.remoteTransactionRollback(prepareCommand.getGlobalTransaction());
                }
            }
            return null;
        });
        this.simulateLocking(ctx, command, this.clusteringDependentLogic);
        if (ctx.isOriginLocal()) {
            return ctx.continueInvocation();
        }
        ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable == null && ((PrepareCommand)rCommand).isOnePhaseCommit()) {
                this.totalOrderManager.release(state);
            }
            state.prepared();
            return null;
        });
        state.preparing();
        if (state.isRollbackReceived()) {
            this.transactionTable.removeRemoteTransaction(command.getGlobalTransaction());
            throw new CacheException("Cannot prepare transaction" + command.getGlobalTransaction().globalId() + ". it was already marked as rollback");
        }
        if (state.isCommitReceived()) {
            log.tracef("Transaction %s marked for commit, skipping the write skew check and forcing 1PC", command.getGlobalTransaction().globalId());
            ((TotalOrderPrepareCommand)((Object)command)).markSkipWriteSkewCheck();
            ((TotalOrderPrepareCommand)((Object)command)).markAsOnePhaseCommit();
        }
        if (trace) {
            log.tracef("Validating transaction %s ", command.getGlobalTransaction().globalId());
        }
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.visitSecondPhaseCommand(ctx, command, false);
    }

    @Override
    public CompletableFuture<Void> visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.visitSecondPhaseCommand(ctx, command, true);
    }

    @Override
    public final CompletableFuture<Void> visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        throw new UnsupportedOperationException("Lock interface not supported with total order protocol");
    }

    private CompletableFuture<Void> visitSecondPhaseCommand(TxInvocationContext context, AbstractTransactionBoundaryCommand command, boolean commit) throws Throwable {
        GlobalTransaction gtx = command.getGlobalTransaction();
        if (trace) {
            log.tracef("Second phase command received. Commit?=%s Transaction=%s, Local=%s", commit, gtx.globalId(), context.isOriginLocal());
        }
        TotalOrderRemoteTransactionState state = this.getTransactionState(context);
        context.onReturn((ctx, command1, rv, throwable) -> {
            if (throwable != null && log.isDebugEnabled()) {
                log.debugf(throwable, "Exception while rollback transaction %s", gtx.globalId());
            }
            if (state != null && state.isFinished()) {
                this.totalOrderManager.release(state);
                if (commit) {
                    this.transactionTable.remoteTransactionCommitted(command.getGlobalTransaction(), false);
                } else {
                    this.transactionTable.remoteTransactionRollback(command.getGlobalTransaction());
                }
                if (context.isOriginLocal()) {
                    this.executorService.checkForReadyTasks();
                }
            }
            return null;
        });
        if (!this.processSecondCommand(state, commit) && !context.isOriginLocal()) {
            return context.shortCircuit(null);
        }
        return context.continueInvocation();
    }

    private TotalOrderRemoteTransactionState getTransactionState(TxInvocationContext context) {
        if (!context.isOriginLocal()) {
            return ((RemoteTransaction)context.getCacheTransaction()).getTransactionState();
        }
        RemoteTransaction remoteTransaction = this.transactionTable.getRemoteTransaction(context.getGlobalTransaction());
        return remoteTransaction == null ? null : remoteTransaction.getTransactionState();
    }

    private boolean processSecondCommand(TotalOrderRemoteTransactionState state, boolean commit) {
        if (state == null) {
            return true;
        }
        try {
            return state.waitUntilPrepared(commit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.timeoutWaitingUntilTransactionPrepared(state.getGlobalTransaction().globalId());
            return false;
        }
    }

    private void simulateLocking(TxInvocationContext context, PrepareCommand command, ClusteringDependentLogic clusteringDependentLogic) {
        Set<Object> affectedKeys = command.getAffectedKeys();
        context.addAllAffectedKeys(command.getAffectedKeys());
        context.clearLockedKeys();
        for (Object e : affectedKeys) {
            if (!clusteringDependentLogic.localNodeIsPrimaryOwner(e)) continue;
            context.addLockedKey(e);
        }
    }
}

