/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.Address;
import org.jgroups.util.Util;

public class Rsp<T> {
    protected static final byte RECEIVED = 1;
    protected static final byte SUSPECTED = 2;
    protected static final byte UNREACHABLE = 4;
    protected static final byte IS_EXCEPTION = 8;
    protected final Address sender;
    protected byte flags;
    protected Object value;

    public Rsp(Address sender) {
        this.sender = sender;
    }

    public Rsp(Address sender, T retval) {
        this.sender = sender;
        this.setValue(retval);
    }

    public Rsp(Address sender, Throwable t) {
        this.sender = sender;
        this.setException(t);
    }

    public T getValue() {
        return (T)(this.hasException() ? null : this.value);
    }

    public Rsp<T> setValue(T val) {
        this.value = val;
        this.setReceived();
        this.flags = Util.clearFlags(this.flags, (byte)8);
        return this;
    }

    public boolean hasException() {
        return Util.isFlagSet(this.flags, (byte)8);
    }

    public Throwable getException() {
        return this.hasException() ? (Throwable)this.value : null;
    }

    public Rsp<T> setException(Throwable t) {
        if (t != null) {
            this.value = t;
            this.setReceived();
            this.flags = Util.setFlag(this.flags, (byte)8);
        }
        return this;
    }

    public Address getSender() {
        return this.sender;
    }

    public boolean wasReceived() {
        return Util.isFlagSet(this.flags, (byte)1);
    }

    public Rsp<T> setReceived() {
        this.flags = Util.setFlag(this.flags, (byte)1);
        return this;
    }

    public boolean wasSuspected() {
        return Util.isFlagSet(this.flags, (byte)2);
    }

    public boolean setSuspected() {
        boolean changed = !this.wasSuspected();
        this.flags = Util.setFlag(this.flags, (byte)2);
        return changed;
    }

    public boolean wasUnreachable() {
        return Util.isFlagSet(this.flags, (byte)4);
    }

    public boolean setUnreachable() {
        boolean changed = !this.wasUnreachable();
        this.flags = Util.setFlag(this.flags, (byte)4);
        return changed;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        Rsp other = (Rsp)obj;
        return this.value == other.value || this.value != null && this.value.equals(other.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sender=").append(this.sender);
        if (this.value != null) {
            if (!this.hasException()) {
                sb.append("value=").append(this.value);
            } else {
                sb.append("exception=").append(this.getException());
            }
        }
        sb.append(", received=").append(this.wasReceived()).append(", suspected=").append(this.wasSuspected());
        if (this.wasUnreachable()) {
            sb.append(" (unreachable)");
        }
        return sb.toString();
    }
}

