/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.Rectangle;

public abstract class SpatialHelper {
    private static final double LOG2 = Math.log(2.0);
    private static final String SPATIAL_FIELD_SUFFIX = "_HSSI_";
    private static final String SPATIAL_LATITUDE_SUFFIX = "_HSSI_Latitude";
    private static final String SPATIAL_LONGITUDE_SUFFIX = "_HSSI_Longitude";

    private SpatialHelper() {
    }

    public static int getCellIndex(double coordinate, double range, int spatialHashLevel) {
        return (int)Math.floor(Math.pow(2.0, spatialHashLevel) * coordinate / range);
    }

    public static String getSpatialHashCellId(Point point, int spatialHashLevel) {
        double[] indexablesCoordinates = SpatialHelper.projectToIndexSpace(point);
        int longitudeCellIndex = SpatialHelper.getCellIndex(indexablesCoordinates[0], Math.PI * 2, spatialHashLevel);
        int latitudeCellIndex = SpatialHelper.getCellIndex(indexablesCoordinates[1], Math.PI, spatialHashLevel);
        return SpatialHelper.formatSpatialHashCellId(longitudeCellIndex, latitudeCellIndex);
    }

    public static List<String> getSpatialHashCellsIds(Point lowerLeft, Point upperRight, int spatialHashLevel) {
        double[] projectedLowerLeft = SpatialHelper.projectToIndexSpace(lowerLeft);
        int lowerLeftXIndex = SpatialHelper.getCellIndex(projectedLowerLeft[0], Math.PI * 2, spatialHashLevel);
        int lowerLeftYIndex = SpatialHelper.getCellIndex(projectedLowerLeft[1], Math.PI, spatialHashLevel);
        double[] projectedUpperRight = SpatialHelper.projectToIndexSpace(upperRight);
        int upperRightXIndex = SpatialHelper.getCellIndex(projectedUpperRight[0], Math.PI * 2, spatialHashLevel);
        int upperRightYIndex = SpatialHelper.getCellIndex(projectedUpperRight[1], Math.PI, spatialHashLevel);
        double[] projectedLowerRight = SpatialHelper.projectToIndexSpace(Point.fromDegrees(lowerLeft.getLatitude(), upperRight.getLongitude()));
        int lowerRightXIndex = SpatialHelper.getCellIndex(projectedLowerRight[0], Math.PI * 2, spatialHashLevel);
        int lowerRightYIndex = SpatialHelper.getCellIndex(projectedLowerRight[1], Math.PI, spatialHashLevel);
        double[] projectedUpperLeft = SpatialHelper.projectToIndexSpace(Point.fromDegrees(upperRight.getLatitude(), lowerLeft.getLongitude()));
        int upperLeftXIndex = SpatialHelper.getCellIndex(projectedUpperLeft[0], Math.PI * 2, spatialHashLevel);
        int upperLeftYIndex = SpatialHelper.getCellIndex(projectedUpperLeft[1], Math.PI, spatialHashLevel);
        int startX = Math.min(Math.min(Math.min(lowerLeftXIndex, upperLeftXIndex), upperRightXIndex), lowerRightXIndex);
        int endX = Math.max(Math.max(Math.max(lowerLeftXIndex, upperLeftXIndex), upperRightXIndex), lowerRightXIndex);
        int startY = Math.min(Math.min(Math.min(lowerLeftYIndex, upperLeftYIndex), upperRightYIndex), lowerRightYIndex);
        int endY = Math.max(Math.max(Math.max(lowerLeftYIndex, upperLeftYIndex), upperRightYIndex), lowerRightYIndex);
        ArrayList<String> spatialHashCellsIds = new ArrayList<String>((endX + 1 - startX) * (endY + 1 - startY));
        for (int xIndex = startX; xIndex <= endX; ++xIndex) {
            for (int yIndex = startY; yIndex <= endY; ++yIndex) {
                spatialHashCellsIds.add(SpatialHelper.formatSpatialHashCellId(xIndex, yIndex));
            }
        }
        return spatialHashCellsIds;
    }

    public static List<String> getSpatialHashCellsIds(Coordinates center, double radius, int spatialHashLevel) {
        Rectangle boundingBox = Rectangle.fromBoundingCircle(center, radius);
        double lowerLeftLatitude = boundingBox.getLowerLeft().getLatitude();
        double lowerLeftLongitude = boundingBox.getLowerLeft().getLongitude();
        double upperRightLatitude = boundingBox.getUpperRight().getLatitude();
        double upperRightLongitude = boundingBox.getUpperRight().getLongitude();
        if (upperRightLongitude < lowerLeftLongitude) {
            List<String> spatialHashCellsIds = SpatialHelper.getSpatialHashCellsIds(Point.fromDegreesInclusive(lowerLeftLatitude, lowerLeftLongitude), Point.fromDegreesInclusive(upperRightLatitude, 180.0), spatialHashLevel);
            spatialHashCellsIds.addAll(SpatialHelper.getSpatialHashCellsIds(Point.fromDegreesInclusive(lowerLeftLatitude, -180.0), Point.fromDegreesInclusive(upperRightLatitude, upperRightLongitude), spatialHashLevel));
            return spatialHashCellsIds;
        }
        return SpatialHelper.getSpatialHashCellsIds(Point.fromDegreesInclusive(lowerLeftLatitude, lowerLeftLongitude), Point.fromDegreesInclusive(upperRightLatitude, upperRightLongitude), spatialHashLevel);
    }

    public static int findBestSpatialHashLevelForSearchRange(double searchRange) {
        double iterations = 40075.017 / (2.0 * searchRange);
        return (int)Math.max(0.0, Math.ceil(Math.log(iterations) / LOG2));
    }

    public static double[] projectToIndexSpace(Point point) {
        double[] projectedCoordinates = new double[]{point.getLongitudeRad() * Math.cos(point.getLatitudeRad()), point.getLatitudeRad()};
        return projectedCoordinates;
    }

    public static String formatFieldName(int spatialHashLevel, String fieldName) {
        return fieldName + SPATIAL_FIELD_SUFFIX + spatialHashLevel;
    }

    public static String formatLatitude(String fieldName) {
        return fieldName + SPATIAL_LATITUDE_SUFFIX;
    }

    public static String formatLongitude(String fieldName) {
        return fieldName + SPATIAL_LONGITUDE_SUFFIX;
    }

    public static boolean isSpatialField(String fieldName) {
        return fieldName.contains(SPATIAL_FIELD_SUFFIX);
    }

    public static boolean isSpatialFieldLatitude(String fieldName) {
        return fieldName.endsWith(SPATIAL_LATITUDE_SUFFIX);
    }

    public static boolean isSpatialFieldLongitude(String fieldName) {
        return fieldName.endsWith(SPATIAL_LONGITUDE_SUFFIX);
    }

    public static String getSpatialFieldRootName(String fieldName) {
        if (!SpatialHelper.isSpatialField(fieldName)) {
            throw new AssertionFailure("The field " + fieldName + " is not a spatial field.");
        }
        return fieldName.substring(0, fieldName.indexOf(SPATIAL_FIELD_SUFFIX));
    }

    public static String formatSpatialHashCellId(int xIndex, int yIndex) {
        return xIndex + "|" + yIndex;
    }
}

