/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.Predicates;
import org.infinispan.objectfilter.impl.predicateindex.Projections;
import org.infinispan.objectfilter.impl.predicateindex.be.PredicateNode;

public class AttributeNode<AttributeMetadata, AttributeId extends Comparable<AttributeId>> {
    public static final Object DUMMY_VALUE = new Object();
    private static final AttributeNode[] EMPTY_CHILDREN = new AttributeNode[0];
    private final AttributeId attribute;
    private final AttributeMetadata metadata;
    private final MetadataAdapter<?, AttributeMetadata, AttributeId> metadataAdapter;
    private final AttributeNode<AttributeMetadata, AttributeId> parent;
    private Map<AttributeId, AttributeNode<AttributeMetadata, AttributeId>> children;
    private AttributeNode<AttributeMetadata, AttributeId>[] childrenArray = EMPTY_CHILDREN;
    private Predicates predicates;
    private Projections projections;

    protected AttributeNode(MetadataAdapter<?, AttributeMetadata, AttributeId> metadataAdapter) {
        this.attribute = null;
        this.parent = null;
        this.metadataAdapter = metadataAdapter;
        this.metadata = null;
    }

    private AttributeNode(AttributeId attribute, AttributeNode<AttributeMetadata, AttributeId> parent) {
        this.attribute = attribute;
        this.parent = parent;
        this.metadataAdapter = parent.metadataAdapter;
        this.metadata = this.metadataAdapter.makeChildAttributeMetadata(parent.metadata, attribute);
    }

    public AttributeId getAttribute() {
        return this.attribute;
    }

    public AttributeMetadata getMetadata() {
        return this.metadata;
    }

    public AttributeNode<AttributeMetadata, AttributeId> getParent() {
        return this.parent;
    }

    public AttributeNode<AttributeMetadata, AttributeId>[] getChildren() {
        return this.childrenArray;
    }

    public AttributeNode<AttributeMetadata, AttributeId> getChild(AttributeId attribute) {
        if (this.children != null) {
            return this.children.get(attribute);
        }
        return null;
    }

    public int getNumChildren() {
        return this.childrenArray.length;
    }

    public boolean hasPredicates() {
        return this.predicates != null && !this.predicates.isEmpty();
    }

    public boolean hasProjections() {
        return this.projections != null && this.projections.hasProjections();
    }

    public void processValue(Object attributeValue, MatcherEvalContext<?, AttributeMetadata, AttributeId> ctx) {
        if (this.projections != null && attributeValue != DUMMY_VALUE) {
            this.projections.processProjections(ctx, attributeValue);
        }
        if (this.predicates != null) {
            this.predicates.notifyMatchingSubscribers(ctx, attributeValue);
        }
    }

    public AttributeNode<AttributeMetadata, AttributeId> addChild(AttributeId attribute) {
        AttributeNode<AttributeMetadata, AttributeId> child;
        if (this.children == null) {
            this.children = new HashMap<AttributeId, AttributeNode<AttributeMetadata, AttributeId>>();
            child = new AttributeNode<AttributeMetadata, AttributeId>(attribute, this);
            this.children.put(attribute, child);
            this.rebuildChildrenArray();
        } else {
            child = this.children.get(attribute);
            if (child == null) {
                child = new AttributeNode<AttributeMetadata, AttributeId>(attribute, this);
                this.children.put(attribute, child);
                this.rebuildChildrenArray();
            }
        }
        return child;
    }

    public void removeChild(AttributeId attribute) {
        if (this.children == null) {
            throw new IllegalArgumentException("No child found : " + attribute);
        }
        AttributeNode<AttributeMetadata, AttributeId> child = this.children.get(attribute);
        if (child == null) {
            throw new IllegalArgumentException("No child found : " + attribute);
        }
        this.children.remove(attribute);
        this.rebuildChildrenArray();
    }

    private void rebuildChildrenArray() {
        Collection<AttributeNode<AttributeMetadata, AttributeId>> childrenCollection = this.children.values();
        this.childrenArray = childrenCollection.toArray(new AttributeNode[childrenCollection.size()]);
    }

    public Predicates.Subscription<AttributeId> addPredicateSubscription(PredicateNode<AttributeId> predicateNode, FilterSubscriptionImpl filterSubscription) {
        if (this.predicates == null) {
            this.predicates = new Predicates(filterSubscription.isUseIntervals() && this.metadataAdapter.isComparableProperty(this.metadata));
        }
        return this.predicates.addPredicateSubscription(predicateNode, filterSubscription);
    }

    public void removePredicateSubscription(Predicates.Subscription<AttributeId> subscription) {
        if (this.predicates == null) {
            throw new IllegalStateException("Reached illegal state");
        }
        this.predicates.removePredicateSubscription(subscription);
    }

    public void addProjection(FilterSubscriptionImpl filterSubscription, int position) {
        if (this.projections == null) {
            this.projections = new Projections();
        }
        this.projections.addProjection(filterSubscription, position);
    }

    public void removeProjections(FilterSubscriptionImpl filterSubscription) {
        if (this.projections == null) {
            throw new IllegalStateException("Reached illegal state");
        }
        this.projections.removeProjections(filterSubscription);
    }

    public String toString() {
        return "AttributeNode(" + this.attribute + ')';
    }
}

