/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RepeatableReadEntry
extends ReadCommittedEntry {
    private static final Log log = LogFactory.getLog(RepeatableReadEntry.class);

    public RepeatableReadEntry(Object key, Object value, EntryVersion version, long lifespan) {
        super(key, value, version, lifespan);
    }

    @Override
    public void copyForUpdate(DataContainer container, boolean localModeWriteSkewCheck) {
        if (this.isFlagSet(ReadCommittedEntry.Flags.COPIED)) {
            return;
        }
        this.setFlag(ReadCommittedEntry.Flags.COPIED);
        if (localModeWriteSkewCheck) {
            this.performLocalWriteSkewCheck(container, false);
        }
        this.oldValue = this.value;
    }

    public void performLocalWriteSkewCheck(DataContainer container, boolean alreadyCopied) {
        Object valueToCompare;
        InternalCacheEntry ice = container.get(this.key);
        Object actualValue = ice == null ? null : ice.getValue();
        Object object = valueToCompare = alreadyCopied ? this.oldValue : this.value;
        if (actualValue != null && actualValue != valueToCompare) {
            log.unableToCopyEntryForUpdate(this.getKey());
            throw new WriteSkewException("Detected write skew.");
        }
        if (ice == null && !this.isCreated()) {
            log.unableToCopyEntryForUpdate(this.getKey());
            throw new WriteSkewException("Detected write skew - concurrent removal of entry!");
        }
    }
}

