/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.container.DataContainer;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Passivation", description="Component that handles passivating entries to a CacheStore on eviction.")
public class PassivationInterceptor
extends JmxStatsCommandInterceptor {
    PassivationManager passivator;
    private static final Log log = LogFactory.getLog(PassivationInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void setDependencies(PassivationManager passivator, DataContainer dataContainer) {
        this.passivator = passivator;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.passivator.resetPassivationCount();
    }

    @ManagedAttribute(description="Number of passivation events", displayName="Number of cache passivations", measurementType=MeasurementType.TRENDSUP)
    public String getPassivations() {
        if (!this.getStatisticsEnabled()) {
            return "N/A";
        }
        return String.valueOf(this.passivator.getPassivationCount());
    }
}

