/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.affinity;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyAffinityServiceImpl;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.remoting.transport.Address;

public class KeyAffinityServiceFactory {
    public static <K, V> KeyAffinityService<K> newKeyAffinityService(Cache<K, V> cache, Executor ex, KeyGenerator<K> keyGenerator, int keyBufferSize, boolean start) {
        return new KeyAffinityServiceImpl<K>(ex, cache, keyGenerator, keyBufferSize, null, start);
    }

    public static <K, V> KeyAffinityService<K> newKeyAffinityService(Cache<K, V> cache, Executor ex, KeyGenerator<K> keyGenerator, int keyBufferSize) {
        return KeyAffinityServiceFactory.newKeyAffinityService(cache, ex, keyGenerator, keyBufferSize, true);
    }

    public static <K, V> KeyAffinityService<K> newKeyAffinityService(Cache<K, V> cache, Collection<Address> filter, KeyGenerator<K> keyGenerator, Executor ex, int keyBufferSize, boolean start) {
        return new KeyAffinityServiceImpl<K>(ex, cache, keyGenerator, keyBufferSize, filter, start);
    }

    public static <K, V> KeyAffinityService<K> newKeyAffinityService(Cache<K, V> cache, Collection<Address> filter, KeyGenerator<K> keyGenerator, Executor ex, int keyBufferSize) {
        return KeyAffinityServiceFactory.newKeyAffinityService(cache, filter, keyGenerator, ex, keyBufferSize, true);
    }

    public static <K, V> KeyAffinityService<K> newLocalKeyAffinityService(Cache<K, V> cache, KeyGenerator<K> keyGenerator, Executor ex, int keyBufferSize, boolean start) {
        Address localAddress = cache.getAdvancedCache().getRpcManager().getTransport().getAddress();
        List<Address> forAddresses = Collections.singletonList(localAddress);
        return KeyAffinityServiceFactory.newKeyAffinityService(cache, forAddresses, keyGenerator, ex, keyBufferSize, start);
    }

    public static <K, V> KeyAffinityService<K> newLocalKeyAffinityService(Cache<K, V> cache, KeyGenerator<K> keyGenerator, Executor ex, int keyBufferSize) {
        return KeyAffinityServiceFactory.newLocalKeyAffinityService(cache, keyGenerator, ex, keyBufferSize, true);
    }
}

