/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration.as;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    BINARY_KEYED_JDBC_STORE("binary-keyed-jdbc-store"),
    BINARY_KEYED_TABLE("binary-keyed-table"),
    DATA_COLUMN("data-column"),
    ID_COLUMN("id-column"),
    MIXED_KEYED_JDBC_STORE("mixed-keyed-jdbc-store"),
    PROPERTY("property"),
    STRING_KEYED_TABLE("string-keyed-table"),
    STRING_KEYED_JDBC_STORE("string-keyed-jdbc-store"),
    TIMESTAMP_COLUMN("timestamp-column"),
    WRITE_BEHIND("write-behind");

    private static final Map<String, Element> MAP;
    private final String name;

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>(8);
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

