/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JdbcUtil {
    private static final Log log = (Log)LogFactory.getLog(JdbcUtil.class, Log.class);

    public static void safeClose(Statement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                log.sqlFailureUnexpected(e);
            }
        }
    }

    public static void safeClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.sqlFailureClosingConnection(connection, e);
            }
        }
    }

    public static void safeClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.sqlFailureUnexpected(e);
            }
        }
    }

    public static ByteBuffer marshall(StreamingMarshaller marshaller, Object bucket) throws CacheLoaderException, InterruptedException {
        try {
            return marshaller.objectToBuffer(bucket);
        }
        catch (IOException e) {
            log.errorMarshallingBucket(e, bucket);
            throw new CacheLoaderException("I/O failure while marshalling bucket: " + bucket, (Throwable)e);
        }
    }

    public static Object unmarshall(StreamingMarshaller marshaller, InputStream inputStream) throws CacheLoaderException {
        try {
            return marshaller.objectFromInputStream(inputStream);
        }
        catch (IOException e) {
            log.ioErrorUnmarshalling(e);
            throw new CacheLoaderException("I/O error while unmarshalling from stream", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.unexpectedClassNotFoundException(e);
            throw new CacheLoaderException("*UNEXPECTED* ClassNotFoundException. This should not happen as Bucket class exists", (Throwable)e);
        }
    }
}

