/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.mixed;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStore;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcBinaryCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcBinaryCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore;
import org.infinispan.loaders.spi.AbstractCacheStore;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JdbcMixedCacheStore
extends AbstractCacheStore {
    private static final Log log = LogFactory.getLog(JdbcMixedCacheStore.class);
    private JdbcMixedCacheStoreConfiguration configuration;
    private JdbcBinaryCacheStore binaryCacheStore = new JdbcBinaryCacheStore();
    private JdbcStringBasedCacheStore stringBasedCacheStore = new JdbcStringBasedCacheStore();
    private ConnectionFactory sharedConnectionFactory;

    public void init(CacheLoaderConfiguration configuration, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        this.configuration = (JdbcMixedCacheStoreConfiguration)this.validateConfigurationClass(configuration, JdbcMixedCacheStoreConfiguration.class);
        super.init(configuration, cache, m);
        this.binaryCacheStore.init((CacheLoaderConfiguration)this.buildBinaryStoreConfiguration(this.configuration), cache, m);
        this.stringBasedCacheStore.init((CacheLoaderConfiguration)this.buildStringStoreConfiguration(this.configuration), cache, m);
    }

    public void start() throws CacheLoaderException {
        super.start();
        ConnectionFactoryConfiguration factoryConfig = this.configuration.connectionFactory();
        this.sharedConnectionFactory = ConnectionFactory.getConnectionFactory(factoryConfig.connectionFactoryClass().getName(), ((Object)((Object)this.configuration)).getClass().getClassLoader());
        this.sharedConnectionFactory.start(factoryConfig, ((Object)((Object)this.configuration)).getClass().getClassLoader());
        this.binaryCacheStore.doConnectionFactoryInitialization(this.sharedConnectionFactory);
        this.binaryCacheStore.start();
        this.stringBasedCacheStore.doConnectionFactoryInitialization(this.sharedConnectionFactory);
        this.stringBasedCacheStore.start();
    }

    public void stop() throws CacheLoaderException {
        super.stop();
        Throwable cause = null;
        try {
            this.binaryCacheStore.stop();
        }
        catch (Throwable t) {
            if (cause == null) {
                cause = t;
            }
            log.debug((Object)"Exception while stopping", t);
        }
        try {
            this.stringBasedCacheStore.stop();
        }
        catch (Throwable t) {
            if (cause == null) {
                cause = t;
            }
            log.debug((Object)"Exception while stopping", t);
        }
        try {
            this.sharedConnectionFactory.stop();
        }
        catch (Throwable t) {
            if (cause == null) {
                cause = t;
            }
            log.debug((Object)"Exception while stopping", t);
        }
        if (cause != null) {
            throw new CacheLoaderException("Exceptions occurred while stopping store", cause);
        }
    }

    protected void purgeInternal() throws CacheLoaderException {
        this.binaryCacheStore.purgeInternal();
        this.stringBasedCacheStore.purgeInternal();
    }

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        return this.getCacheStore(key).load(key);
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        Set fromBuckets = this.binaryCacheStore.loadAll();
        Set fromStrings = this.stringBasedCacheStore.loadAll();
        if (log.isTraceEnabled()) {
            log.tracef("Loaded from bucket: %s", (Object)fromBuckets);
            log.tracef("Loaded from string: %s", (Object)fromStrings);
        }
        fromBuckets.addAll(fromStrings);
        return fromBuckets;
    }

    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        if (numEntries < 0) {
            return this.loadAll();
        }
        Set set = this.stringBasedCacheStore.load(numEntries);
        if (set.size() < numEntries) {
            Set otherSet = this.binaryCacheStore.load(numEntries - set.size());
            set.addAll(otherSet);
        }
        return set;
    }

    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        Set<Object> fromBuckets = this.binaryCacheStore.loadAllKeys(keysToExclude);
        Set fromStrings = this.stringBasedCacheStore.loadAllKeys(keysToExclude);
        fromBuckets.addAll(fromStrings);
        return fromBuckets;
    }

    public void store(InternalCacheEntry ed) throws CacheLoaderException {
        this.getCacheStore(ed.getKey()).store(ed);
    }

    public void fromStream(ObjectInput inputStream) throws CacheLoaderException {
        this.binaryCacheStore.fromStream(inputStream);
        this.stringBasedCacheStore.fromStream(inputStream);
    }

    public void toStream(ObjectOutput outputStream) throws CacheLoaderException {
        this.binaryCacheStore.toStream(outputStream);
        this.stringBasedCacheStore.toStream(outputStream);
    }

    public boolean remove(Object key) throws CacheLoaderException {
        return this.getCacheStore(key).remove(key);
    }

    public void clear() throws CacheLoaderException {
        this.binaryCacheStore.clear();
        this.stringBasedCacheStore.clear();
    }

    private CacheStore getCacheStore(Object key) {
        return this.stringBasedCacheStore.supportsKey(key.getClass()) ? this.stringBasedCacheStore : this.binaryCacheStore;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.sharedConnectionFactory;
    }

    public JdbcBinaryCacheStore getBinaryCacheStore() {
        return this.binaryCacheStore;
    }

    public JdbcStringBasedCacheStore getStringBasedCacheStore() {
        return this.stringBasedCacheStore;
    }

    private JdbcStringBasedCacheStoreConfiguration buildStringStoreConfiguration(JdbcMixedCacheStoreConfiguration configuration) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        JdbcStringBasedCacheStoreConfigurationBuilder stringBuilder = (JdbcStringBasedCacheStoreConfigurationBuilder)((JdbcStringBasedCacheStoreConfigurationBuilder)builder.loaders().addLoader(JdbcStringBasedCacheStoreConfigurationBuilder.class)).manageConnectionFactory(false);
        stringBuilder.key2StringMapper(configuration.key2StringMapper()).table().read(configuration.stringTable());
        return stringBuilder.create();
    }

    private JdbcBinaryCacheStoreConfiguration buildBinaryStoreConfiguration(JdbcMixedCacheStoreConfiguration configuration) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        JdbcBinaryCacheStoreConfigurationBuilder binaryBuilder = (JdbcBinaryCacheStoreConfigurationBuilder)((JdbcBinaryCacheStoreConfigurationBuilder)builder.loaders().addLoader(JdbcBinaryCacheStoreConfigurationBuilder.class)).manageConnectionFactory(false);
        binaryBuilder.table().read(configuration.binaryTable());
        return binaryBuilder.create();
    }
}

