/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import org.infinispan.Cache;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.loaders.manager.CacheLoaderManager;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.manager.EmbeddedCacheManager;

public class RemoveCacheCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 18;
    private EmbeddedCacheManager cacheManager;
    private GlobalComponentRegistry registry;
    private CacheLoaderManager cacheLoaderManager;

    private RemoveCacheCommand() {
        super(null);
    }

    public RemoveCacheCommand(String cacheName, EmbeddedCacheManager cacheManager, GlobalComponentRegistry registry, CacheLoaderManager cacheLoaderManager) {
        super(cacheName);
        this.cacheManager = cacheManager;
        this.registry = registry;
        this.cacheLoaderManager = cacheLoaderManager;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheStore store = this.cacheLoaderManager.getCacheStore();
        Cache cache = this.cacheManager.getCache(this.cacheName);
        CacheJmxRegistration jmx = cache.getAdvancedCache().getComponentRegistry().getComponent(CacheJmxRegistration.class);
        cache.stop();
        if (store != null) {
            store.clear();
        }
        if (jmx != null) {
            jmx.unregisterCacheMBean();
        }
        this.registry.removeCache(this.cacheName);
        return null;
    }

    @Override
    public byte getCommandId() {
        return 18;
    }

    @Override
    public Object[] getParameters() {
        return Util.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }
}

