/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.config.AdvancedExternalizerConfig;
import org.infinispan.config.FluentGlobalConfiguration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.marshall.AdvancedExternalizer;
import org.infinispan.marshall.Marshaller;
import org.infinispan.remoting.transport.Transport;

public class LegacyGlobalConfigurationAdaptor {
    private LegacyGlobalConfigurationAdaptor() {
    }

    public static GlobalConfiguration adapt(org.infinispan.configuration.global.GlobalConfiguration config) {
        org.infinispan.commons.marshall.Marshaller marshaller;
        if (config == null) {
            return null;
        }
        FluentGlobalConfiguration legacy = new GlobalConfiguration(config.classLoader()).fluent();
        legacy.transport().clusterName(config.transport().clusterName()).machineId(config.transport().machineId()).rackId(config.transport().rackId()).siteId(config.transport().siteId()).strictPeerToPeer(config.transport().strictPeerToPeer()).distributedSyncTimeout(config.transport().distributedSyncTimeout()).nodeName(config.transport().nodeName()).withProperties((Properties)config.transport().properties());
        if (config.transport().transport() != null) {
            legacy.transport().transportClass(config.transport().transport().getClass());
        }
        legacy.globalJmxStatistics().jmxDomain(config.globalJmxStatistics().domain()).mBeanServerLookup(config.globalJmxStatistics().mbeanServerLookup()).allowDuplicateDomains(config.globalJmxStatistics().allowDuplicateDomains()).cacheManagerName(config.globalJmxStatistics().cacheManagerName()).withProperties((Properties)config.globalJmxStatistics().properties());
        if (!config.globalJmxStatistics().enabled()) {
            legacy.globalJmxStatistics().disable();
        }
        if ((marshaller = config.serialization().marshaller()) instanceof Marshaller) {
            legacy.serialization().marshallerClass(((Marshaller)marshaller).getClass()).version(config.serialization().version());
        }
        for (Map.Entry<Integer, org.infinispan.commons.marshall.AdvancedExternalizer<?>> entry : config.serialization().advancedExternalizers().entrySet()) {
            org.infinispan.commons.marshall.AdvancedExternalizer<?> advancedExternalizer = entry.getValue();
            if (!(advancedExternalizer instanceof AdvancedExternalizer)) continue;
            legacy.serialization().addAdvancedExternalizer((int)entry.getKey(), (AdvancedExternalizer)advancedExternalizer);
        }
        legacy.serialization().classResolver(config.serialization().classResolver());
        legacy.asyncTransportExecutor().factory(config.asyncTransportExecutor().factory().getClass()).withProperties((Properties)config.asyncTransportExecutor().properties());
        legacy.asyncListenerExecutor().factory(config.asyncListenerExecutor().factory().getClass()).withProperties((Properties)config.asyncListenerExecutor().properties());
        legacy.evictionScheduledExecutor().factory(config.evictionScheduledExecutor().factory().getClass()).withProperties((Properties)config.evictionScheduledExecutor().properties());
        legacy.replicationQueueScheduledExecutor().factory(config.replicationQueueScheduledExecutor().factory().getClass()).withProperties((Properties)config.replicationQueueScheduledExecutor().properties());
        legacy.shutdown().hookBehavior(GlobalConfiguration.ShutdownHookBehavior.valueOf(config.shutdown().hookBehavior().name()));
        return legacy.build();
    }

    public static org.infinispan.configuration.global.GlobalConfiguration adapt(GlobalConfiguration legacy) {
        if (legacy == null) {
            return null;
        }
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        if (legacy.getTransportClass() != null) {
            builder.transport().clusterName(legacy.getClusterName()).machineId(legacy.getMachineId()).rackId(legacy.getRackId()).siteId(legacy.getSiteId()).strictPeerToPeer(legacy.isStrictPeerToPeer()).distributedSyncTimeout(legacy.getDistributedSyncTimeout()).transport((Transport)Util.getInstance((String)legacy.getTransportClass(), (ClassLoader)legacy.getClassLoader())).nodeName(legacy.getTransportNodeName()).withProperties(legacy.getTransportProperties());
        }
        builder.globalJmxStatistics().jmxDomain(legacy.getJmxDomain()).mBeanServerLookup(legacy.getMBeanServerLookupInstance()).allowDuplicateDomains(legacy.isAllowDuplicateDomains()).cacheManagerName(legacy.getCacheManagerName()).withProperties(legacy.getMBeanServerProperties());
        if (legacy.isExposeGlobalJmxStatistics()) {
            builder.globalJmxStatistics().enable();
        } else {
            builder.globalJmxStatistics().disable();
        }
        builder.serialization().marshaller((org.infinispan.commons.marshall.Marshaller)Util.getInstance((String)legacy.getMarshallerClass(), (ClassLoader)legacy.getClassLoader())).version(legacy.getMarshallVersion());
        for (AdvancedExternalizerConfig externalizerConfig : legacy.getExternalizers()) {
            Integer id;
            AdvancedExternalizer ext = externalizerConfig.getAdvancedExternalizer();
            if (ext == null) {
                ext = (AdvancedExternalizer)Util.getInstance((String)externalizerConfig.getExternalizerClass(), (ClassLoader)legacy.getClassLoader());
            }
            if ((id = externalizerConfig.getId()) != null) {
                builder.serialization().addAdvancedExternalizer((int)id, ext);
                continue;
            }
            builder.serialization().addAdvancedExternalizer(ext);
        }
        builder.serialization().classResolver(legacy.getClassResolver());
        builder.asyncTransportExecutor().factory((ExecutorFactory)Util.getInstance((String)legacy.getAsyncTransportExecutorFactoryClass(), (ClassLoader)legacy.getClassLoader())).withProperties(legacy.getAsyncTransportExecutorProperties());
        builder.asyncListenerExecutor().factory((ExecutorFactory)Util.getInstance((String)legacy.getAsyncListenerExecutorFactoryClass(), (ClassLoader)legacy.getClassLoader())).withProperties(legacy.getAsyncListenerExecutorProperties());
        builder.evictionScheduledExecutor().factory((ScheduledExecutorFactory)Util.getInstance((String)legacy.getEvictionScheduledExecutorFactoryClass(), (ClassLoader)legacy.getClassLoader())).withProperties(legacy.getEvictionScheduledExecutorProperties());
        builder.replicationQueueScheduledExecutor().factory((ScheduledExecutorFactory)Util.getInstance((String)legacy.getReplicationQueueScheduledExecutorFactoryClass(), (ClassLoader)legacy.getClassLoader())).withProperties(legacy.getReplicationQueueScheduledExecutorProperties());
        builder.shutdown().hookBehavior(ShutdownHookBehavior.valueOf(legacy.getShutdownHookBehavior().name()));
        return builder.build();
    }
}

