/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ClusterCacheLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyStoreConfigurationBuilder;
import org.infinispan.configuration.cache.RecoveryConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParsedCacheMode;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.loaders.cluster.ClusterCacheLoader;
import org.infinispan.loaders.file.FileCacheStore;
import org.infinispan.loaders.spi.CacheLoader;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:5.0", root="infinispan"), @Namespace(uri="urn:infinispan:config:5.1", root="infinispan")})
public class Parser51
implements ConfigurationParser {
    private static final Log log = LogFactory.getLog(Parser51.class);

    @Override
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DEFAULT: {
                    this.parseDefaultCache(reader, holder.getDefaultConfigurationBuilder(), holder.getClassLoader());
                    continue block5;
                }
                case GLOBAL: {
                    this.parseGlobal(reader, holder.getGlobalConfigurationBuilder(), holder.getClassLoader());
                    continue block5;
                }
                case NAMED_CACHE: {
                    this.parseNamedCache(reader, holder);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseNamedCache(XMLStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
        String name = "";
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ConfigurationBuilder builder = holder.getNamedConfigurationBuilders().get(name);
        if (builder == null) {
            builder = holder.newConfigurationBuilder(name);
        }
        this.parseCache(reader, builder, holder.getClassLoader());
    }

    private void parseDefaultCache(XMLStreamReader reader, ConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        this.parseCache(reader, builder, cl);
    }

    private void parseCache(XMLStreamReader reader, ConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTERING: {
                    this.parseClustering(reader, builder, cl);
                    continue block17;
                }
                case CUSTOM_INTERCEPTORS: {
                    this.parseCustomInterceptors(reader, builder, cl);
                    continue block17;
                }
                case DATA_CONTAINER: {
                    this.parseDataContainer(reader, builder, cl);
                    continue block17;
                }
                case DEADLOCK_DETECTION: {
                    this.parseDeadlockDetection(reader, builder);
                    continue block17;
                }
                case EVICTION: {
                    this.parseEviction(reader, builder);
                    continue block17;
                }
                case EXPIRATION: {
                    this.parseExpiration(reader, builder);
                    continue block17;
                }
                case INDEXING: {
                    this.parseIndexing(reader, builder);
                    continue block17;
                }
                case INVOCATION_BATCHING: {
                    this.parseInvocationBatching(reader, builder);
                    continue block17;
                }
                case JMX_STATISTICS: {
                    this.parseJmxStatistics(reader, builder);
                    continue block17;
                }
                case LOADERS: {
                    this.parseLoaders(reader, builder, cl);
                    continue block17;
                }
                case LOCKING: {
                    this.parseLocking(reader, builder);
                    continue block17;
                }
                case LAZY_DESERIALIZATION: 
                case STORE_AS_BINARY: {
                    this.parseStoreAsBinary(reader, builder);
                    continue block17;
                }
                case TRANSACTION: {
                    this.parseTransaction(reader, builder, cl);
                    continue block17;
                }
                case UNSAFE: {
                    this.parseUnsafe(reader, builder);
                    continue block17;
                }
                case VERSIONING: {
                    this.parseVersioning(reader, builder);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseVersioning(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        builder.versioning().disable();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSIONING_SCHEME: {
                    builder.versioning().scheme(VersioningScheme.valueOf(value));
                    continue block4;
                }
                case ENABLED: {
                    builder.versioning().enable();
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseTransaction(XMLStreamReader reader, ConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        boolean forceSetTransactional = false;
        boolean transactionModeSpecified = false;
        block16: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUTO_COMMIT: {
                    builder.transaction().autoCommit(Boolean.parseBoolean(value));
                    continue block16;
                }
                case CACHE_STOP_TIMEOUT: {
                    builder.transaction().cacheStopTimeout(Long.parseLong(value));
                    continue block16;
                }
                case EAGER_LOCK_SINGLE_NODE: {
                    builder.transaction().eagerLockingSingleNode(Boolean.parseBoolean(value));
                    continue block16;
                }
                case LOCKING_MODE: {
                    builder.transaction().lockingMode(LockingMode.valueOf(value));
                    continue block16;
                }
                case SYNC_COMMIT_PHASE: {
                    builder.transaction().syncCommitPhase(Boolean.parseBoolean(value));
                    continue block16;
                }
                case SYNC_ROLLBACK_PHASE: {
                    builder.transaction().syncRollbackPhase(Boolean.parseBoolean(value));
                    continue block16;
                }
                case TRANSACTION_MANAGER_LOOKUP_CLASS: {
                    builder.transaction().transactionManagerLookup((TransactionManagerLookup)Util.getInstance((String)value, (ClassLoader)cl));
                    forceSetTransactional = true;
                    continue block16;
                }
                case TRANSACTION_MODE: {
                    builder.transaction().transactionMode(TransactionMode.valueOf(value));
                    transactionModeSpecified = true;
                    continue block16;
                }
                case USE_EAGER_LOCKING: {
                    builder.transaction().useEagerLocking(Boolean.parseBoolean(value));
                    continue block16;
                }
                case USE_SYNCHRONIZAION: {
                    builder.transaction().useSynchronization(Boolean.parseBoolean(value));
                    continue block16;
                }
                case USE_1PC_FOR_AUTOCOMMIT_TX: {
                    builder.transaction().use1PcForAutoCommitTransactions(Boolean.parseBoolean(value));
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!transactionModeSpecified && forceSetTransactional) {
            builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case RECOVERY: {
                    this.parseRecovery(reader, builder);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseRecovery(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        RecoveryConfigurationBuilder recovery = builder.transaction().recovery();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        recovery.enable();
                        continue block4;
                    }
                    recovery.disable();
                    continue block4;
                }
                case RECOVERY_INFO_CACHE_NAME: {
                    recovery.recoveryInfoCacheName(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseUnsafe(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case UNRELIABLE_RETURN_VALUES: {
                    builder.unsafe().unreliableReturnValues(Boolean.parseBoolean(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseStoreAsBinary(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.storeAsBinary().enable();
                        continue block5;
                    }
                    builder.storeAsBinary().disable();
                    continue block5;
                }
                case STORE_KEYS_AS_BINARY: {
                    builder.storeAsBinary().storeKeysAsBinary(Boolean.parseBoolean(value));
                    continue block5;
                }
                case STORE_VALUES_AS_BINARY: {
                    builder.storeAsBinary().storeValuesAsBinary(Boolean.parseBoolean(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseLocking(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONCURRENCY_LEVEL: {
                    builder.locking().concurrencyLevel(Integer.parseInt(value));
                    continue block7;
                }
                case ISOLATION_LEVEL: {
                    builder.locking().isolationLevel(IsolationLevel.valueOf(value));
                    continue block7;
                }
                case LOCK_ACQUISITION_TIMEOUT: {
                    builder.locking().lockAcquisitionTimeout(Long.parseLong(value));
                    continue block7;
                }
                case USE_LOCK_STRIPING: {
                    builder.locking().useLockStriping(Boolean.parseBoolean(value));
                    continue block7;
                }
                case WRITE_SKEW_CHECK: {
                    builder.locking().writeSkewCheck(Boolean.parseBoolean(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseLoaders(XMLStreamReader reader, ConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PASSIVATION: {
                    builder.loaders().passivation(Boolean.parseBoolean(value));
                    continue block8;
                }
                case PRELOAD: {
                    builder.loaders().preload(Boolean.parseBoolean(value));
                    continue block8;
                }
                case SHARED: {
                    builder.loaders().shared(Boolean.parseBoolean(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOADER: {
                    this.parseLoader(reader, builder, cl);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseLoader(XMLStreamReader reader, ConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        CacheLoader loader = null;
        Boolean fetchPersistentState = null;
        Boolean ignoreModifications = null;
        Boolean purgeOnStartup = null;
        Integer purgerThreads = null;
        Boolean purgeSynchronously = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    loader = (CacheLoader)Util.getInstance((String)value, (ClassLoader)cl);
                    continue block8;
                }
                case FETCH_PERSISTENT_STATE: {
                    fetchPersistentState = Boolean.valueOf(value);
                    continue block8;
                }
                case IGNORE_MODIFICATIONS: {
                    ignoreModifications = Boolean.valueOf(value);
                    continue block8;
                }
                case PURGE_ON_STARTUP: {
                    purgeOnStartup = Boolean.valueOf(value);
                    continue block8;
                }
                case PURGER_THREADS: {
                    purgerThreads = Integer.valueOf(value);
                    continue block8;
                }
                case PURGE_SYNCHRONOUSLY: {
                    purgeSynchronously = Boolean.valueOf(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (loader != null) {
            if (loader instanceof FileCacheStore) {
                FileCacheStoreConfigurationBuilder fcscb = builder.loaders().addFileCacheStore();
                if (fetchPersistentState != null) {
                    fcscb.fetchPersistentState(fetchPersistentState);
                }
                if (ignoreModifications != null) {
                    fcscb.ignoreModifications(ignoreModifications);
                }
                if (purgeOnStartup != null) {
                    fcscb.purgeOnStartup(purgeOnStartup);
                }
                if (purgeSynchronously != null) {
                    fcscb.purgeSynchronously(purgeSynchronously);
                }
                this.parseStoreChildren(reader, fcscb);
            } else if (loader instanceof CacheStore) {
                LegacyStoreConfigurationBuilder scb = builder.loaders().addStore();
                scb.cacheStore((CacheStore)loader);
                if (fetchPersistentState != null) {
                    scb.fetchPersistentState(fetchPersistentState);
                }
                if (ignoreModifications != null) {
                    scb.ignoreModifications(ignoreModifications);
                }
                if (purgerThreads != null) {
                    scb.purgerThreads(purgerThreads);
                }
                if (purgeOnStartup != null) {
                    scb.purgeOnStartup(purgeOnStartup);
                }
                if (purgeSynchronously != null) {
                    scb.purgeSynchronously(purgeSynchronously);
                }
                this.parseStoreChildren(reader, scb);
            } else if (loader instanceof ClusterCacheLoader) {
                ClusterCacheLoaderConfigurationBuilder cclb = builder.loaders().addClusterCacheLoader();
                this.parseLoaderChildren(reader, cclb);
            } else {
                LegacyLoaderConfigurationBuilder lcb = builder.loaders().addLoader();
                lcb.cacheLoader(loader);
                this.parseLoaderChildren(reader, lcb);
            }
        }
    }

    private void parseLoaderChildren(XMLStreamReader reader, CacheLoaderConfigurationBuilder<?, ?> loaderBuilder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    loaderBuilder.withProperties(Parser51.parseProperties(reader));
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseStoreChildren(XMLStreamReader reader, CacheStoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC: {
                    this.parseAsyncStore(reader, storeBuilder);
                    continue block5;
                }
                case PROPERTIES: {
                    storeBuilder.withProperties(Parser51.parseProperties(reader));
                    continue block5;
                }
                case SINGLETON_STORE: {
                    this.parseSingletonStore(reader, storeBuilder);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseSingletonStore(XMLStreamReader reader, CacheStoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        storeBuilder.singletonStore().enable();
                        continue block5;
                    }
                    storeBuilder.singletonStore().disable();
                    continue block5;
                }
                case PUSH_STATE_TIMEOUT: {
                    storeBuilder.singletonStore().pushStateTimeout(Long.parseLong(value));
                    continue block5;
                }
                case PUSH_STATE_WHEN_COORDINATOR: {
                    storeBuilder.singletonStore().pushStateWhenCoordinator(Boolean.parseBoolean(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseAsyncStore(XMLStreamReader reader, CacheStoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        storeBuilder.async().enable();
                        continue block7;
                    }
                    storeBuilder.async().disable();
                    continue block7;
                }
                case FLUSH_LOCK_TIMEOUT: {
                    storeBuilder.async().flushLockTimeout(Long.parseLong(value));
                    continue block7;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    storeBuilder.async().modificationQueueSize(Integer.parseInt(value));
                    continue block7;
                }
                case SHUTDOWN_TIMEOUT: {
                    storeBuilder.async().shutdownTimeout(Long.parseLong(value));
                    continue block7;
                }
                case THREAD_POOL_SIZE: {
                    storeBuilder.async().threadPoolSize(Integer.parseInt(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseJmxStatistics(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.jmxStatistics().enable();
                        continue block3;
                    }
                    builder.jmxStatistics().disable();
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseInvocationBatching(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.invocationBatching().enable();
                        continue block3;
                    }
                    builder.invocationBatching().disable();
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseIndexing(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.indexing().enable();
                        continue block7;
                    }
                    builder.indexing().disable();
                    continue block7;
                }
                case INDEX_LOCAL_ONLY: {
                    builder.indexing().indexLocalOnly(Boolean.parseBoolean(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        Properties indexingProperties = null;
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    indexingProperties = Parser51.parseProperties(reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        IndexingConfigurationBuilder indexing = builder.indexing();
        if (indexingProperties != null) {
            indexing.withProperties(indexingProperties);
        }
    }

    private void parseExpiration(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case LIFESPAN: {
                    builder.expiration().lifespan(Long.parseLong(value));
                    continue block6;
                }
                case MAX_IDLE: {
                    builder.expiration().maxIdle(Long.parseLong(value));
                    continue block6;
                }
                case REAPER_ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.expiration().enableReaper();
                        continue block6;
                    }
                    builder.expiration().disableReaper();
                    continue block6;
                }
                case WAKE_UP_INTERVAL: {
                    builder.expiration().wakeUpInterval(Long.parseLong(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseEviction(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_ENTRIES: {
                    builder.eviction().maxEntries(Integer.parseInt(value));
                    continue block6;
                }
                case STRATEGY: {
                    builder.eviction().strategy(EvictionStrategy.valueOf(value));
                    continue block6;
                }
                case THREAD_POLICY: {
                    builder.eviction().threadPolicy(EvictionThreadPolicy.valueOf(value));
                    continue block6;
                }
                case WAKE_UP_INTERVAL: {
                    Long wakeUpInterval = Long.valueOf(value);
                    log.evictionWakeUpIntervalDeprecated(wakeUpInterval);
                    builder.expiration().wakeUpInterval(wakeUpInterval);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseDeadlockDetection(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.deadlockDetection().enable();
                        continue block4;
                    }
                    builder.deadlockDetection().disable();
                    continue block4;
                }
                case SPIN_DURATION: {
                    builder.deadlockDetection().spinDuration(Long.parseLong(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseDataContainer(XMLStreamReader reader, ConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    builder.dataContainer().dataContainer((DataContainer)Util.getInstance((String)value, (ClassLoader)cl));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.dataContainer().withProperties(Parser51.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseCustomInterceptors(XMLStreamReader reader, ConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERCEPTOR: {
                    this.parseInterceptor(reader, builder, cl);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseInterceptor(XMLStreamReader reader, ConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AFTER: {
                    interceptorBuilder.after(Util.loadClass((String)value, (ClassLoader)cl));
                    continue block10;
                }
                case BEFORE: {
                    interceptorBuilder.before(Util.loadClass((String)value, (ClassLoader)cl));
                    continue block10;
                }
                case CLASS: {
                    interceptorBuilder.interceptor((CommandInterceptor)Util.getInstance((String)value, (ClassLoader)cl));
                    continue block10;
                }
                case INDEX: {
                    interceptorBuilder.index(Integer.parseInt(value));
                    continue block10;
                }
                case POSITION: {
                    interceptorBuilder.position(InterceptorConfiguration.Position.valueOf(value.toUpperCase()));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    interceptorBuilder.withProperties(Parser51.parseProperties(reader));
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseClustering(XMLStreamReader reader, ConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        String clusteringMode = null;
        boolean synchronous = false;
        boolean asynchronous = false;
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MODE: {
                    clusteringMode = value;
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC: {
                    asynchronous = true;
                    this.setMode(builder, clusteringMode, asynchronous, synchronous, reader);
                    this.parseAsync(reader, builder, cl);
                    continue block12;
                }
                case HASH: {
                    this.parseHash(reader, builder, cl);
                    continue block12;
                }
                case L1: {
                    this.parseL1reader(reader, builder);
                    continue block12;
                }
                case STATE_RETRIEVAL: {
                    this.parseStateRetrieval(reader, builder);
                    continue block12;
                }
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, builder);
                    continue block12;
                }
                case SYNC: {
                    synchronous = true;
                    this.setMode(builder, clusteringMode, asynchronous, synchronous, reader);
                    this.parseSync(reader, builder);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (!synchronous && !asynchronous) {
            this.setMode(builder, clusteringMode, asynchronous, asynchronous, reader);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setMode(ConfigurationBuilder builder, String clusteringMode, boolean asynchronous, boolean synchronous, XMLStreamReader reader) {
        if (synchronous && asynchronous) {
            throw new CacheConfigurationException("Cannot configure <sync> and <async> on the same cluster, " + reader.getLocation());
        }
        if (clusteringMode != null) {
            String mode = clusteringMode.toUpperCase();
            if (ParsedCacheMode.REPL.matches(mode)) {
                if (!asynchronous) {
                    builder.clustering().cacheMode(CacheMode.REPL_SYNC);
                    return;
                } else {
                    builder.clustering().cacheMode(CacheMode.REPL_ASYNC);
                }
                return;
            } else if (ParsedCacheMode.INVALIDATION.matches(mode)) {
                if (!asynchronous) {
                    builder.clustering().cacheMode(CacheMode.INVALIDATION_SYNC);
                    return;
                } else {
                    builder.clustering().cacheMode(CacheMode.INVALIDATION_ASYNC);
                }
                return;
            } else if (ParsedCacheMode.DIST.matches(mode)) {
                if (!asynchronous) {
                    builder.clustering().cacheMode(CacheMode.DIST_SYNC);
                    return;
                } else {
                    builder.clustering().cacheMode(CacheMode.DIST_ASYNC);
                }
                return;
            } else {
                if (!ParsedCacheMode.LOCAL.matches(mode)) throw new CacheConfigurationException("Invalid clustering mode " + clusteringMode + ", " + reader.getLocation());
                builder.clustering().cacheMode(CacheMode.LOCAL);
            }
            return;
        } else if (synchronous) {
            builder.clustering().cacheMode(CacheMode.DIST_SYNC);
            return;
        } else {
            if (!asynchronous) return;
            builder.clustering().cacheMode(CacheMode.DIST_ASYNC);
        }
    }

    private void parseSync(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REPL_TIMEOUT: {
                    builder.clustering().sync().replTimeout(Long.parseLong(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseStateRetrieval(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            log.stateRetrievalConfigurationDeprecated();
            switch (attribute) {
                case ALWAYS_PROVIDE_IN_MEMORY_STATE: {
                    log.alwaysProvideInMemoryStateDeprecated();
                    continue block10;
                }
                case FETCH_IN_MEMORY_STATE: {
                    builder.clustering().stateTransfer().fetchInMemoryState(Boolean.parseBoolean(value));
                    continue block10;
                }
                case INITIAL_RETRY_WAIT_TIME: {
                    log.initialRetryWaitTimeDeprecated();
                    continue block10;
                }
                case LOG_FLUSH_TIMEOUT: {
                    log.logFlushTimeoutDeprecated();
                    continue block10;
                }
                case MAX_NON_PROGRESSING_LOG_WRITES: {
                    log.maxProgressingLogWritesDeprecated();
                    continue block10;
                }
                case NUM_RETRIES: {
                    log.numRetriesDeprecated();
                    continue block10;
                }
                case RETRY_WAIT_TIME_INCREASE_FACTOR: {
                    log.retryWaitTimeIncreaseFactorDeprecated();
                    continue block10;
                }
                case TIMEOUT: {
                    builder.clustering().stateTransfer().timeout(Long.parseLong(value));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseStateTransfer(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FETCH_IN_MEMORY_STATE: {
                    builder.clustering().stateTransfer().fetchInMemoryState(Boolean.parseBoolean(value));
                    continue block5;
                }
                case TIMEOUT: {
                    builder.clustering().stateTransfer().timeout(Long.parseLong(value));
                    continue block5;
                }
                case CHUNK_SIZE: {
                    builder.clustering().stateTransfer().chunkSize(Integer.parseInt(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseL1reader(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.clustering().l1().enable();
                        continue block7;
                    }
                    builder.clustering().l1().disable();
                    continue block7;
                }
                case INVALIDATION_THRESHOLD: {
                    builder.clustering().l1().invalidationThreshold(Integer.parseInt(value));
                    continue block7;
                }
                case LIFESPAN: {
                    builder.clustering().l1().lifespan(Long.parseLong(value));
                    continue block7;
                }
                case INVALIDATION_CLEANUP_TASK_FREQUENCY: {
                    builder.clustering().l1().cleanupTaskFrequency(Long.parseLong(value));
                    continue block7;
                }
                case ON_REHASH: {
                    if (Boolean.parseBoolean(value)) {
                        builder.clustering().l1().enableOnRehash();
                        continue block7;
                    }
                    builder.clustering().l1().disableOnRehash();
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseHash(XMLStreamReader reader, ConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: 
                case HASH_FUNCTION_CLASS: {
                    builder.clustering().hash().consistentHash((ConsistentHash)Util.getInstance((String)value, (ClassLoader)cl));
                    continue block11;
                }
                case NUM_OWNERS: {
                    builder.clustering().hash().numOwners(Integer.parseInt(value));
                    continue block11;
                }
                case NUM_VIRTUAL_NODES: {
                    builder.clustering().hash().numVirtualNodes(Integer.parseInt(value));
                    continue block11;
                }
                case REHASH_ENABLED: {
                    log.hashRehashEnabledDeprecated();
                    builder.clustering().stateTransfer().fetchInMemoryState(Boolean.parseBoolean(value));
                    continue block11;
                }
                case REHASH_RPC_TIMEOUT: {
                    log.hashRehashRpcTimeoutDeprecated();
                    builder.clustering().stateTransfer().timeout(Long.parseLong(value));
                    continue block11;
                }
                case REHASH_WAIT: {
                    log.hashRehashWaitDeprecated();
                    builder.clustering().stateTransfer().timeout(Long.parseLong(value));
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPS: {
                    this.parseGroups(reader, builder, cl);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseGroups(XMLStreamReader reader, ConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        String value;
        ParseUtils.requireSingleAttribute(reader, "enabled");
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.clustering().hash().groups().enabled();
                        continue block6;
                    }
                    builder.clustering().hash().groups().disabled();
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPER: {
                    value = ParseUtils.readStringAttributeElement(reader, "class");
                    builder.clustering().hash().groups().addGrouper((Grouper)Util.getInstance((String)value, (ClassLoader)cl));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAsync(XMLStreamReader reader, ConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ASYNC_MARSHALLING: {
                    if (Boolean.parseBoolean(value)) {
                        builder.clustering().async().asyncMarshalling();
                        continue block7;
                    }
                    builder.clustering().async().syncMarshalling();
                    continue block7;
                }
                case REPL_QUEUE_CLASS: {
                    builder.clustering().async().replQueue((ReplicationQueue)Util.getInstance((String)value, (ClassLoader)cl));
                    continue block7;
                }
                case REPL_QUEUE_INTERVAL: {
                    builder.clustering().async().replQueueInterval(Long.parseLong(value));
                    continue block7;
                }
                case REPL_QUEUE_MAX_ELEMENTS: {
                    builder.clustering().async().replQueueMaxElements(Integer.parseInt(value));
                    continue block7;
                }
                case USE_REPL_QUEUE: {
                    builder.clustering().async().useReplQueue(Boolean.parseBoolean(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseGlobal(XMLStreamReader reader, GlobalConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        boolean transportParsed = false;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC_LISTENER_EXECUTOR: {
                    this.parseAsyncListenerExectuor(reader, builder, cl);
                    continue block10;
                }
                case ASYNC_TRANSPORT_EXECUTOR: {
                    this.parseAsyncTransportExecutor(reader, builder, cl);
                    continue block10;
                }
                case EVICTION_SCHEDULED_EXECUTOR: {
                    this.parseEvictionScheduledExecutor(reader, builder, cl);
                    continue block10;
                }
                case GLOBAL_JMX_STATISTICS: {
                    this.parseGlobalJMXStatistics(reader, builder, cl);
                    continue block10;
                }
                case REPLICATION_QUEUE_SCHEDULED_EXECUTOR: {
                    this.parseReplicationQueueScheduledExecutor(reader, builder, cl);
                    continue block10;
                }
                case SERIALIZATION: {
                    this.parseSerialization(reader, builder, cl);
                    continue block10;
                }
                case SHUTDOWN: {
                    this.parseShutdown(reader, builder);
                    continue block10;
                }
                case TRANSPORT: {
                    this.parseTransport(reader, builder, cl);
                    transportParsed = true;
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (!transportParsed) {
            builder.transport().transport(null);
        } else if (builder.transport().getTransport() == null) {
            builder.transport().defaultTransport();
        }
    }

    private void parseTransport(XMLStreamReader reader, GlobalConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLUSTER_NAME: {
                    builder.transport().clusterName(value);
                    continue block13;
                }
                case DISTRIBUTED_SYNC_TIMEOUT: {
                    builder.transport().distributedSyncTimeout(Long.parseLong(value));
                    continue block13;
                }
                case MACHINE_ID: {
                    builder.transport().machineId(value);
                    continue block13;
                }
                case NODE_NAME: {
                    builder.transport().nodeName(value);
                    continue block13;
                }
                case RACK_ID: {
                    builder.transport().rackId(value);
                    continue block13;
                }
                case SITE_ID: {
                    builder.transport().siteId(value);
                    continue block13;
                }
                case STRICT_PEER_TO_PEER: {
                    builder.transport().strictPeerToPeer(Boolean.valueOf(value));
                    continue block13;
                }
                case TRANSPORT_CLASS: {
                    builder.transport().transport((Transport)Util.getInstance((String)value, (ClassLoader)cl));
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.transport().withProperties(Parser51.parseProperties(reader));
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseShutdown(XMLStreamReader reader, GlobalConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOOK_BEHAVIOR: {
                    builder.shutdown().hookBehavior(ShutdownHookBehavior.valueOf(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseSerialization(XMLStreamReader reader, GlobalConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MARSHALLER_CLASS: {
                    builder.serialization().marshaller((Marshaller)Util.getInstance((String)value, (ClassLoader)cl));
                    continue block7;
                }
                case VERSION: {
                    builder.serialization().version(value);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADVANCED_EXTERNALIZERS: {
                    this.parseAdvancedExternalizers(reader, builder, cl);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAdvancedExternalizers(XMLStreamReader reader, GlobalConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADVANCED_EXTERNALIZER: {
                    int attributes = reader.getAttributeCount();
                    AdvancedExternalizer advancedExternalizer = null;
                    Integer id = null;
                    ParseUtils.requireAttributes(reader, Attribute.EXTERNALIZER_CLASS.getLocalName());
                    block8: for (int i = 0; i < attributes; ++i) {
                        String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case EXTERNALIZER_CLASS: {
                                advancedExternalizer = (AdvancedExternalizer)Util.getInstance((String)value, (ClassLoader)cl);
                                continue block8;
                            }
                            case ID: {
                                id = Integer.valueOf(value);
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent(reader);
                    if (id != null) {
                        builder.serialization().addAdvancedExternalizer((int)id, advancedExternalizer);
                        continue block7;
                    }
                    builder.serialization().addAdvancedExternalizer(advancedExternalizer);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseReplicationQueueScheduledExecutor(XMLStreamReader reader, GlobalConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.replicationQueueScheduledExecutor().factory((ScheduledExecutorFactory)Util.getInstance((String)value, (ClassLoader)cl));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.replicationQueueScheduledExecutor().withProperties(Parser51.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseGlobalJMXStatistics(XMLStreamReader reader, GlobalConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ALLOW_DUPLICATE_DOMAINS: {
                    builder.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(value));
                    continue block10;
                }
                case CACHE_MANAGER_NAME: {
                    builder.globalJmxStatistics().cacheManagerName(value);
                    continue block10;
                }
                case ENABLED: {
                    if (!Boolean.parseBoolean(value)) {
                        builder.globalJmxStatistics().disable();
                        continue block10;
                    }
                    builder.globalJmxStatistics().enable();
                    continue block10;
                }
                case JMX_DOMAIN: {
                    builder.globalJmxStatistics().jmxDomain(value);
                    continue block10;
                }
                case MBEAN_SERVER_LOOKUP: {
                    builder.globalJmxStatistics().mBeanServerLookup((MBeanServerLookup)Util.getInstance((String)value, (ClassLoader)cl));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.globalJmxStatistics().withProperties(Parser51.parseProperties(reader));
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseEvictionScheduledExecutor(XMLStreamReader reader, GlobalConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.evictionScheduledExecutor().factory((ScheduledExecutorFactory)Util.getInstance((String)value, (ClassLoader)cl));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.evictionScheduledExecutor().withProperties(Parser51.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAsyncTransportExecutor(XMLStreamReader reader, GlobalConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.asyncTransportExecutor().factory((ExecutorFactory)Util.getInstance((String)value, (ClassLoader)cl));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.asyncTransportExecutor().withProperties(Parser51.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAsyncListenerExectuor(XMLStreamReader reader, GlobalConfigurationBuilder builder, ClassLoader cl) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.asyncListenerExecutor().factory((ExecutorFactory)Util.getInstance((String)value, (ClassLoader)cl));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.asyncListenerExecutor().withProperties(Parser51.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public static Properties parseProperties(XMLStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        Properties p = new Properties();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    int attributes = reader.getAttributeCount();
                    ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName());
                    String key = null;
                    String propertyValue = null;
                    block8: for (int i = 0; i < attributes; ++i) {
                        String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                key = value;
                                continue block8;
                            }
                            case VALUE: {
                                propertyValue = value;
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                        }
                    }
                    p.put(key, propertyValue);
                    ParseUtils.requireNoContent(reader);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return p;
    }
}

