/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.manager.CacheLoaderManager;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.CoreImmutables;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.BoundedConcurrentHashMap;

@ThreadSafe
public class DefaultDataContainer
implements DataContainer {
    protected final ConcurrentMap<Object, InternalCacheEntry> entries;
    protected InternalEntryFactory entryFactory;
    protected final DefaultEvictionListener evictionListener;
    private EvictionManager evictionManager;
    private PassivationManager passivator;
    private ActivationManager activator;
    private CacheLoaderManager clm;
    private TimeService timeService;

    public DefaultDataContainer(int concurrencyLevel) {
        this.entries = CollectionFactory.makeConcurrentMap((int)128, (int)concurrencyLevel);
        this.evictionListener = null;
    }

    public DefaultDataContainer(int concurrencyLevel, Equivalence keyEq, Equivalence valueEq) {
        this.entries = CollectionFactory.makeConcurrentMap((int)128, (int)concurrencyLevel, (Equivalence)keyEq, (Equivalence)valueEq);
        this.evictionListener = null;
    }

    protected DefaultDataContainer(int concurrencyLevel, int maxEntries, EvictionStrategy strategy, EvictionThreadPolicy policy, Equivalence keyEquivalence, Equivalence valueEquivalence) {
        BoundedConcurrentHashMap.Eviction eviction;
        switch (policy) {
            case PIGGYBACK: 
            case DEFAULT: {
                this.evictionListener = new DefaultEvictionListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("No such eviction thread policy " + (Object)((Object)strategy));
            }
        }
        switch (strategy) {
            case FIFO: 
            case UNORDERED: 
            case LRU: {
                eviction = BoundedConcurrentHashMap.Eviction.LRU;
                break;
            }
            case LIRS: {
                eviction = BoundedConcurrentHashMap.Eviction.LIRS;
                break;
            }
            default: {
                throw new IllegalArgumentException("No such eviction strategy " + (Object)((Object)strategy));
            }
        }
        this.entries = new BoundedConcurrentHashMap<Object, InternalCacheEntry>(maxEntries, concurrencyLevel, eviction, this.evictionListener, keyEquivalence, valueEquivalence);
    }

    @Inject
    public void initialize(EvictionManager evictionManager, PassivationManager passivator, InternalEntryFactory entryFactory, ActivationManager activator, CacheLoaderManager clm, TimeService timeService) {
        this.evictionManager = evictionManager;
        this.passivator = passivator;
        this.entryFactory = entryFactory;
        this.activator = activator;
        this.clm = clm;
        this.timeService = timeService;
    }

    public static DataContainer boundedDataContainer(int concurrencyLevel, int maxEntries, EvictionStrategy strategy, EvictionThreadPolicy policy, Equivalence keyEquivalence, Equivalence valueEquivalence) {
        return new DefaultDataContainer(concurrencyLevel, maxEntries, strategy, policy, keyEquivalence, valueEquivalence);
    }

    public static DataContainer unBoundedDataContainer(int concurrencyLevel, Equivalence keyEquivalence, Equivalence valueEquivalence) {
        return new DefaultDataContainer(concurrencyLevel, keyEquivalence, valueEquivalence);
    }

    public static DataContainer unBoundedDataContainer(int concurrencyLevel) {
        return new DefaultDataContainer(concurrencyLevel);
    }

    @Override
    public InternalCacheEntry peek(Object key) {
        return (InternalCacheEntry)this.entries.get(key);
    }

    @Override
    public InternalCacheEntry get(Object k) {
        InternalCacheEntry e = this.peek(k);
        if (e != null && e.canExpire()) {
            long currentTimeMillis = this.timeService.wallClockTime();
            if (e.isExpired(currentTimeMillis)) {
                this.entries.remove(k);
                e = null;
            } else {
                e.touch(currentTimeMillis);
            }
        }
        return e;
    }

    @Override
    public void put(Object k, Object v, Metadata metadata) {
        InternalCacheEntry e = (InternalCacheEntry)this.entries.get(k);
        if (e != null) {
            e.setValue(v);
            InternalCacheEntry original = e;
            e = this.entryFactory.update(e, metadata);
            if (original == e) {
                e.reincarnate(this.timeService.wallClockTime());
            }
        } else {
            e = this.entryFactory.create(k, v, metadata);
        }
        this.entries.put(k, e);
    }

    @Override
    public boolean containsKey(Object k) {
        InternalCacheEntry ice = this.peek(k);
        if (ice != null && ice.canExpire() && ice.isExpired(this.timeService.wallClockTime())) {
            this.entries.remove(k);
            ice = null;
        }
        return ice != null;
    }

    @Override
    public InternalCacheEntry remove(Object k) {
        InternalCacheEntry e = (InternalCacheEntry)this.entries.remove(k);
        return e == null || e.canExpire() && e.isExpired(this.timeService.wallClockTime()) ? null : e;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public Set<Object> keySet() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    @Override
    public Collection<Object> values() {
        return new Values();
    }

    @Override
    public Set<InternalCacheEntry> entrySet() {
        return new EntrySet();
    }

    @Override
    public void purgeExpired() {
        long currentTimeMillis = this.timeService.wallClockTime();
        Iterator purgeCandidates = this.entries.values().iterator();
        while (purgeCandidates.hasNext()) {
            InternalCacheEntry e = (InternalCacheEntry)purgeCandidates.next();
            if (!e.isExpired(currentTimeMillis)) continue;
            purgeCandidates.remove();
        }
    }

    @Override
    public Iterator<InternalCacheEntry> iterator() {
        return new EntryIterator(this.entries.values().iterator());
    }

    private static class ValueIterator
    implements Iterator<Object> {
        Iterator<InternalCacheEntry> currentIterator;

        private ValueIterator(Iterator<InternalCacheEntry> it) {
            this.currentIterator = it;
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object next() {
            return this.currentIterator.next().getValue();
        }
    }

    private class Values
    extends AbstractCollection<Object> {
        private Values() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValueIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }
    }

    private class EntrySet
    extends AbstractSet<InternalCacheEntry> {
        private EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            InternalCacheEntry ice = (InternalCacheEntry)DefaultDataContainer.this.entries.get(e.getKey());
            if (ice == null) {
                return false;
            }
            return ice.getValue().equals(e.getValue());
        }

        @Override
        public Iterator<InternalCacheEntry> iterator() {
            return new ImmutableEntryIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }

        @Override
        public String toString() {
            return DefaultDataContainer.this.entries.toString();
        }
    }

    public static class EntryIterator
    implements Iterator<InternalCacheEntry> {
        private final Iterator<InternalCacheEntry> it;

        EntryIterator(Iterator<InternalCacheEntry> it) {
            this.it = it;
        }

        @Override
        public InternalCacheEntry next() {
            return this.it.next();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ImmutableEntryIterator
    extends EntryIterator {
        ImmutableEntryIterator(Iterator<InternalCacheEntry> it) {
            super(it);
        }

        @Override
        public InternalCacheEntry next() {
            return CoreImmutables.immutableInternalCacheEntry(super.next());
        }
    }

    private final class DefaultEvictionListener
    implements BoundedConcurrentHashMap.EvictionListener<Object, InternalCacheEntry> {
        private DefaultEvictionListener() {
        }

        @Override
        public void onEntryEviction(Map<Object, InternalCacheEntry> evicted) {
            DefaultDataContainer.this.evictionManager.onEntryEviction(evicted);
        }

        @Override
        public void onEntryChosenForEviction(InternalCacheEntry entry) {
            DefaultDataContainer.this.passivator.passivate(entry);
        }

        @Override
        public void onEntryActivated(Object key) {
            DefaultDataContainer.this.activator.activate(key);
        }

        @Override
        public void onEntryRemoved(Object key) {
            try {
                CacheStore cacheStore = DefaultDataContainer.this.clm.getCacheStore();
                if (cacheStore != null) {
                    cacheStore.remove(key);
                }
            }
            catch (CacheLoaderException e) {
                throw new CacheException((Throwable)e);
            }
        }
    }
}

