/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.CommandsFactoryImpl;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.NonTransactionalInvocationContextContainer;
import org.infinispan.context.TransactionalInvocationContextContainer;
import org.infinispan.distribution.L1Manager;
import org.infinispan.distribution.L1ManagerImpl;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.ActivationManagerImpl;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionManagerImpl;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.eviction.PassivationManagerImpl;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.loaders.manager.CacheLoaderManager;
import org.infinispan.loaders.manager.CacheLoaderManagerImpl;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferLockImpl;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.totalorder.TotalOrderManager;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;
import org.infinispan.util.concurrent.locks.containers.AbstractLockContainer;
import org.infinispan.util.concurrent.locks.containers.LockContainer;
import org.infinispan.util.concurrent.locks.containers.OwnableReentrantPerEntryLockContainer;
import org.infinispan.util.concurrent.locks.containers.OwnableReentrantStripedLockContainer;
import org.infinispan.util.concurrent.locks.containers.ReentrantPerEntryLockContainer;
import org.infinispan.util.concurrent.locks.containers.ReentrantStripedLockContainer;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.BackupSenderImpl;

@DefaultFactoryFor(classes={CacheNotifier.class, CommandsFactory.class, CacheLoaderManager.class, InvocationContextContainer.class, PassivationManager.class, ActivationManager.class, BatchContainer.class, EvictionManager.class, TransactionCoordinator.class, RecoveryAdminOperations.class, StateTransferLock.class, ClusteringDependentLogic.class, LockContainer.class, L1Manager.class, TransactionFactory.class, BackupSender.class, TotalOrderManager.class})
public class EmptyConstructorNamedCacheFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (componentType.equals(ClusteringDependentLogic.class)) {
            CacheMode cacheMode = this.configuration.clustering().cacheMode();
            if (!cacheMode.isClustered()) {
                return componentType.cast(new ClusteringDependentLogic.LocalLogic());
            }
            if (cacheMode.isInvalidation()) {
                return componentType.cast(new ClusteringDependentLogic.InvalidationLogic());
            }
            if (cacheMode.isReplicated()) {
                return componentType.cast(new ClusteringDependentLogic.ReplicationLogic());
            }
            return componentType.cast(new ClusteringDependentLogic.DistributionLogic());
        }
        boolean isTransactional = this.configuration.transaction().transactionMode().isTransactional();
        if (componentType.equals(InvocationContextContainer.class)) {
            Class componentImpl = isTransactional ? TransactionalInvocationContextContainer.class : NonTransactionalInvocationContextContainer.class;
            return componentType.cast(Util.getInstance(componentImpl));
        }
        if (componentType.equals(CacheNotifier.class)) {
            return (T)new CacheNotifierImpl();
        }
        if (componentType.equals(CommandsFactory.class)) {
            return (T)new CommandsFactoryImpl();
        }
        if (componentType.equals(CacheLoaderManager.class)) {
            return (T)new CacheLoaderManagerImpl();
        }
        if (componentType.equals(PassivationManager.class)) {
            return (T)new PassivationManagerImpl();
        }
        if (componentType.equals(ActivationManager.class)) {
            return (T)new ActivationManagerImpl();
        }
        if (componentType.equals(BatchContainer.class)) {
            return (T)new BatchContainer();
        }
        if (componentType.equals(TransactionCoordinator.class)) {
            return (T)new TransactionCoordinator();
        }
        if (componentType.equals(RecoveryAdminOperations.class)) {
            return (T)new RecoveryAdminOperations();
        }
        if (componentType.equals(StateTransferLock.class)) {
            return (T)new StateTransferLockImpl();
        }
        if (componentType.equals(EvictionManager.class)) {
            return (T)new EvictionManagerImpl();
        }
        if (componentType.equals(LockContainer.class)) {
            boolean notTransactional;
            boolean bl = notTransactional = !isTransactional;
            AbstractLockContainer lockContainer = this.configuration.locking().useLockStriping() ? (notTransactional ? new ReentrantStripedLockContainer(this.configuration.locking().concurrencyLevel()) : new OwnableReentrantStripedLockContainer(this.configuration.locking().concurrencyLevel())) : (notTransactional ? new ReentrantPerEntryLockContainer(this.configuration.locking().concurrencyLevel()) : new OwnableReentrantPerEntryLockContainer(this.configuration.locking().concurrencyLevel()));
            return (T)lockContainer;
        }
        if (componentType.equals(L1Manager.class)) {
            return (T)new L1ManagerImpl();
        }
        if (componentType.equals(TransactionFactory.class)) {
            return (T)new TransactionFactory();
        }
        if (componentType.equals(BackupSender.class)) {
            return (T)new BackupSenderImpl(this.globalConfiguration.sites().localSite());
        }
        if (componentType.equals(TotalOrderManager.class)) {
            return (T)new TotalOrderManager();
        }
        throw new CacheConfigurationException("Don't know how to create a " + componentType.getName());
    }
}

