/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.ClusteringInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseDistributionInterceptor
extends ClusteringInterceptor {
    protected DistributionManager dm;
    protected ClusteringDependentLogic cdl;
    private static final Log log = LogFactory.getLog(BaseDistributionInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void injectDependencies(DistributionManager distributionManager, ClusteringDependentLogic cdl) {
        this.dm = distributionManager;
        this.cdl = cdl;
    }

    @Override
    protected final InternalCacheEntry retrieveFromRemoteSource(Object key, InvocationContext ctx, boolean acquireRemoteLock, FlagAffectedCommand command, boolean isWrite) throws Exception {
        GlobalTransaction gtx = ctx.isInTxScope() ? ((TxInvocationContext)ctx).getGlobalTransaction() : null;
        ClusteredGetCommand get = this.cf.buildClusteredGetCommand(key, command.getFlags(), acquireRemoteLock, gtx);
        get.setWrite(isWrite);
        ArrayList<Address> targets = new ArrayList<Address>(this.stateTransferManager.getCacheTopology().getReadConsistentHash().locateOwners(key));
        targets.retainAll(this.rpcManager.getTransport().getMembers());
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(targets, this.rpcManager.getAddress());
        RpcOptions options = this.rpcManager.getRpcOptionsBuilder(ResponseMode.WAIT_FOR_VALID_RESPONSE, false).responseFilter(filter).build();
        Map<Address, Response> responses = this.rpcManager.invokeRemotely(targets, (ReplicableCommand)get, options);
        if (!responses.isEmpty()) {
            for (Response r : responses.values()) {
                if (!(r instanceof SuccessfulResponse)) continue;
                SuccessfulResponse response = (SuccessfulResponse)r;
                if (response.getResponseValue() == null) {
                    return null;
                }
                InternalCacheValue cacheValue = (InternalCacheValue)response.getResponseValue();
                return cacheValue.toInternalCacheEntry(key);
            }
        }
        return null;
    }

    protected final Object handleNonTxWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        if (ctx.isInTxScope()) {
            throw new CacheException("Attempted execution of non-transactional write command in a transactional invocation context");
        }
        SingleKeyRecipientGenerator recipientGenerator = new SingleKeyRecipientGenerator(command.getKey());
        this.remoteGetBeforeWrite(ctx, command, recipientGenerator);
        if (this.isLocalModeForced(command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        boolean isSync = this.isSynchronous(command);
        if (!ctx.isOriginLocal()) {
            Object returnValue = this.invokeNextInterceptor(ctx, command);
            Address primaryOwner = this.cdl.getPrimaryOwner(command.getKey());
            if (primaryOwner.equals(this.rpcManager.getAddress())) {
                if (command.isConditional() && !command.isSuccessful()) {
                    log.tracef("Skipping the replication of the conditional command as it did not succeed on primary owner (%s).", command);
                    return returnValue;
                }
                int oldTopologyId = command.getTopologyId();
                command.setTopologyId(this.stateTransferManager.getCacheTopology().getTopologyId());
                this.rpcManager.invokeRemotely(recipientGenerator.generateRecipients(), (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(isSync));
                command.setTopologyId(oldTopologyId);
            }
            return returnValue;
        }
        Address primaryOwner = this.cdl.getPrimaryOwner(command.getKey());
        if (primaryOwner.equals(this.rpcManager.getAddress())) {
            boolean isSingleOwnerAndLocal;
            Object result = this.invokeNextInterceptor(ctx, command);
            if (command.isConditional() && !command.isSuccessful()) {
                log.tracef("Skipping the replication of the conditional command as it did not succeed on primary owner (%s).", command);
                return result;
            }
            List<Address> recipients = recipientGenerator.generateRecipients();
            log.tracef("I'm the primary owner, sending the command to all (%s) the recipients in order to be applied.", recipients);
            boolean bl = isSingleOwnerAndLocal = this.cacheConfiguration.clustering().hash().numOwners() == 1;
            if (!isSingleOwnerAndLocal) {
                this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(isSync));
            }
            return result;
        }
        log.tracef("I'm not the primary owner, so sending the command to the primary owner(%s) in order to be forwarded", primaryOwner);
        Object localResult = this.invokeNextInterceptor(ctx, command);
        boolean isSyncForwarding = isSync || this.isNeedReliableReturnValues(command);
        Map<Address, Response> addressResponseMap = this.rpcManager.invokeRemotely(Collections.singletonList(primaryOwner), (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(isSyncForwarding));
        if (!isSyncForwarding) {
            return localResult;
        }
        return this.getResponseFromPrimaryOwner(primaryOwner, addressResponseMap);
    }

    private Object getResponseFromPrimaryOwner(Address primaryOwner, Map<Address, Response> addressResponseMap) {
        Response fromPrimaryOwner = addressResponseMap.get(primaryOwner);
        if (fromPrimaryOwner == null) {
            log.tracef("Primary owner %s returned null", primaryOwner);
            return null;
        }
        if (fromPrimaryOwner.isSuccessful()) {
            return ((SuccessfulResponse)fromPrimaryOwner).getResponseValue();
        }
        if (addressResponseMap.get(primaryOwner) instanceof CacheNotFoundResponse) {
            throw new OutdatedTopologyException("Cache is no longer running on primary owner " + primaryOwner);
        }
        Exception cause = fromPrimaryOwner instanceof ExceptionResponse ? ((ExceptionResponse)fromPrimaryOwner).getException() : null;
        throw new CacheException("Got unsuccessful response from primary owner: " + fromPrimaryOwner, (Throwable)cause);
    }

    protected abstract void remoteGetBeforeWrite(InvocationContext var1, WriteCommand var2, RecipientGenerator var3) throws Throwable;

    class MultipleKeysRecipientGenerator
    implements RecipientGenerator {
        private final Collection<Object> keys;
        private List<Address> recipients = null;

        MultipleKeysRecipientGenerator(Collection<Object> keys) {
            this.keys = keys;
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                this.recipients = BaseDistributionInterceptor.this.cdl.getOwners(this.keys);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    class SingleKeyRecipientGenerator
    implements RecipientGenerator {
        private final Object key;
        private final Set<Object> keys;
        private List<Address> recipients = null;

        SingleKeyRecipientGenerator(Object key) {
            this.key = key;
            this.keys = Collections.singleton(key);
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                this.recipients = BaseDistributionInterceptor.this.cdl.getOwners(this.key);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    static interface RecipientGenerator {
        public Collection<Object> getKeys();

        public List<Address> generateRecipients();
    }
}

