/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cluster;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.configuration.cache.ClusterCacheLoaderConfiguration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.spi.AbstractCacheLoader;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterCacheLoader
extends AbstractCacheLoader {
    private static final Log log = LogFactory.getLog(ClusterCacheLoader.class);
    private RpcManager rpcManager;
    private AdvancedCache<?, ?> cache;
    private ClusterCacheLoaderConfiguration configuration;

    @Override
    public void init(CacheLoaderConfiguration configuration, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        this.configuration = this.validateConfigurationClass(configuration, ClusterCacheLoaderConfiguration.class);
        super.init(configuration, cache, m);
        this.cache = cache.getAdvancedCache();
        this.rpcManager = this.cache.getRpcManager();
    }

    @Override
    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        Response response;
        if (!this.isCacheReady() || !this.isLocalCall()) {
            return null;
        }
        ClusteredGetCommand clusteredGetCommand = new ClusteredGetCommand(key, this.cache.getName(), InfinispanCollections.emptySet(), false, null, this.cache.getCacheConfiguration().dataContainer().keyEquivalence());
        Collection<Response> responses = this.doRemoteCall(clusteredGetCommand);
        if (responses.isEmpty()) {
            return null;
        }
        if (responses.size() > 1) {
            HashSet<Response> setResponses = new HashSet<Response>(responses);
            if (setResponses.size() > 1) {
                throw new CacheLoaderException(String.format("Responses contains more than 1 element and these elements are not equal, so can't decide which one to use: %s", setResponses));
            }
            response = (Response)setResponses.iterator().next();
        } else {
            response = responses.iterator().next();
        }
        if (response.isSuccessful() && response instanceof SuccessfulResponse) {
            InternalCacheValue value = (InternalCacheValue)((SuccessfulResponse)response).getResponseValue();
            return value.toInternalCacheEntry(key);
        }
        log.unknownResponsesFromRemoteCache(responses);
        throw new CacheLoaderException("Unknown responses");
    }

    @Override
    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return InfinispanCollections.emptySet();
    }

    @Override
    public Set<InternalCacheEntry> load(int maxElems) throws CacheLoaderException {
        return InfinispanCollections.emptySet();
    }

    @Override
    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        return InfinispanCollections.emptySet();
    }

    @Override
    public void start() throws CacheLoaderException {
    }

    @Override
    public void stop() throws CacheLoaderException {
    }

    private Collection<Response> doRemoteCall(ClusteredGetCommand clusteredGetCommand) throws CacheLoaderException {
        HashSet<Address> members = new HashSet<Address>(this.rpcManager.getTransport().getMembers());
        Address self = this.rpcManager.getTransport().getAddress();
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(members, self);
        try {
            RpcOptions options = this.rpcManager.getRpcOptionsBuilder(ResponseMode.WAIT_FOR_VALID_RESPONSE).timeout(this.configuration.remoteCallTimeout(), TimeUnit.MILLISECONDS).responseFilter(filter).build();
            return this.rpcManager.invokeRemotely(null, (ReplicableCommand)clusteredGetCommand, options).values();
        }
        catch (Exception e) {
            log.errorDoingRemoteCall(e);
            throw new CacheLoaderException(e);
        }
    }

    private boolean isLocalCall() {
        InvocationContext invocationContext = this.cache.getInvocationContextContainer().getInvocationContext(false);
        return invocationContext.isOriginLocal();
    }

    protected boolean isCacheReady() {
        return this.cache.getStatus() == ComponentStatus.RUNNING;
    }
}

