/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.spi;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.loaders.spi.AbstractCacheLoader;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractCacheStore
extends AbstractCacheLoader
implements CacheStore {
    private static final Log log = LogFactory.getLog(AbstractCacheStore.class);
    private Map<GlobalTransaction, List<? extends Modification>> transactions;
    protected ExecutorService purgerService;
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger(0);
    protected boolean multiThreadedPurge = false;
    protected CacheStoreConfiguration configuration;

    @Override
    public void init(CacheLoaderConfiguration config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        this.configuration = this.validateConfigurationClass(config, CacheStoreConfiguration.class);
        super.init(config, cache, m);
    }

    protected final int getConcurrencyLevel() {
        return this.cache == null || this.cache.getCacheConfiguration() == null ? 16 : this.cache.getCacheConfiguration().locking().concurrencyLevel();
    }

    @Override
    public void start() throws CacheLoaderException {
        if (this.configuration == null) {
            throw new IllegalStateException("Make sure you call super.init() from CacheStore extension");
        }
        if (this.configuration.purgeSynchronously()) {
            this.purgerService = new WithinThreadExecutor();
        } else {
            this.multiThreadedPurge = this.supportsMultiThreadedPurge() && this.configuration.purgerThreads() > 1;
            final String loaderName = this.getClass().getSimpleName();
            this.purgerService = Executors.newFixedThreadPool(this.supportsMultiThreadedPurge() ? this.configuration.purgerThreads() : 1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, (AbstractCacheStore.this.cache == null ? "" : AbstractCacheStore.this.cache.getName() + '-') + loaderName + '-' + THREAD_COUNTER.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        this.transactions = CollectionFactory.makeConcurrentMap((int)64, (int)this.getConcurrencyLevel());
    }

    protected boolean supportsMultiThreadedPurge() {
        return false;
    }

    @Override
    public void stop() throws CacheLoaderException {
        this.purgerService.shutdownNow();
    }

    @Override
    public void purgeExpired() throws CacheLoaderException {
        if (this.purgerService == null) {
            throw new IllegalStateException("purgerService is null (did you call super.start() from cache loader implementation ?");
        }
        Future<Void> future = this.purgerService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AbstractCacheStore.this.purgeInternal();
                    return null;
                }
                catch (CacheLoaderException e) {
                    log.problemPurgingExpired(e);
                    throw e;
                }
            }
        });
        if (this.configuration.purgeSynchronously()) {
            try {
                future.get(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof CacheLoaderException) {
                    throw (CacheLoaderException)e.getCause();
                }
                throw log.purgingExpiredEntriesFailed(e);
            }
            catch (TimeoutException e) {
                throw log.timedOutWaitingForExpiredEntriesToBePurged(e);
            }
        }
    }

    @Override
    public CacheLoaderConfiguration getConfiguration() {
        return this.configuration;
    }

    protected abstract void purgeInternal() throws CacheLoaderException;

    protected void applyModifications(List<? extends Modification> mods) throws CacheLoaderException {
        block5: for (Modification modification : mods) {
            switch (modification.getType()) {
                case STORE: {
                    Store s = (Store)modification;
                    this.store(s.getStoredEntry());
                    continue block5;
                }
                case CLEAR: {
                    this.clear();
                    continue block5;
                }
                case REMOVE: {
                    Remove r = (Remove)modification;
                    this.remove(r.getKey());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown modification type " + (Object)((Object)modification.getType()));
        }
    }

    @Override
    public void prepare(List<? extends Modification> mods, GlobalTransaction tx, boolean isOnePhase) throws CacheLoaderException {
        if (isOnePhase) {
            this.applyModifications(mods);
        } else {
            this.transactions.put(tx, mods);
        }
    }

    @Override
    public void rollback(GlobalTransaction tx) {
        this.transactions.remove(tx);
    }

    @Override
    public void commit(GlobalTransaction tx) throws CacheLoaderException {
        List<? extends Modification> list = this.transactions.remove(tx);
        if (list != null && !list.isEmpty()) {
            this.applyModifications(list);
        }
    }

    @Override
    public void removeAll(Set<Object> keys) throws CacheLoaderException {
        if (keys != null && !keys.isEmpty()) {
            for (Object key : keys) {
                this.remove(key);
            }
        }
    }

    protected static void safeClose(InputStream stream) throws CacheLoaderException {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Exception e) {
            throw new CacheLoaderException("Problems closing input stream", e);
        }
    }

    protected static void safeClose(OutputStream stream) throws CacheLoaderException {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Exception e) {
            throw new CacheLoaderException("Problems closing output stream", e);
        }
    }

    protected StreamingMarshaller getMarshaller() {
        return this.marshaller;
    }
}

