/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import java.util.Properties;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.loaders.jdbc.DatabaseType;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfigurationChildBuilder;
import org.infinispan.loaders.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.TableManipulationConfigurationBuilder;
import org.infinispan.loaders.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.loaders.keymappers.Key2StringMapper;

public class JdbcMixedCacheStoreConfigurationBuilder
extends AbstractJdbcCacheStoreConfigurationBuilder<JdbcMixedCacheStoreConfiguration, JdbcMixedCacheStoreConfigurationBuilder>
implements JdbcMixedCacheStoreConfigurationChildBuilder<JdbcMixedCacheStoreConfigurationBuilder> {
    private final MixedTableManipulationConfigurationBuilder binaryTable;
    private final MixedTableManipulationConfigurationBuilder stringTable;
    private String key2StringMapper = DefaultTwoWayKey2StringMapper.class.getName();
    private DatabaseType databaseType;
    private int batchSize = 100;
    private int fetchSize = 100;

    public JdbcMixedCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
        this.binaryTable = new MixedTableManipulationConfigurationBuilder(this);
        this.stringTable = new MixedTableManipulationConfigurationBuilder(this);
    }

    public JdbcMixedCacheStoreConfigurationBuilder self() {
        return this;
    }

    public JdbcMixedCacheStoreConfigurationBuilder batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public JdbcMixedCacheStoreConfigurationBuilder fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public JdbcMixedCacheStoreConfigurationBuilder databaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    @Override
    public MixedTableManipulationConfigurationBuilder binaryTable() {
        return this.binaryTable;
    }

    @Override
    public MixedTableManipulationConfigurationBuilder stringTable() {
        return this.stringTable;
    }

    @Override
    public JdbcMixedCacheStoreConfigurationChildBuilder<JdbcMixedCacheStoreConfigurationBuilder> key2StringMapper(String key2StringMapper) {
        this.key2StringMapper = key2StringMapper;
        return this;
    }

    @Override
    public JdbcMixedCacheStoreConfigurationChildBuilder<JdbcMixedCacheStoreConfigurationBuilder> key2StringMapper(Class<? extends Key2StringMapper> klass) {
        this.key2StringMapper = klass.getName();
        return this;
    }

    @Override
    public void validate() {
        if (this.binaryTable.tableNamePrefix.equals(this.stringTable.tableNamePrefix)) {
            throw new CacheConfigurationException("There cannot be the same tableNamePrefix on both the binary and String tables.");
        }
    }

    public JdbcMixedCacheStoreConfiguration create() {
        return new JdbcMixedCacheStoreConfiguration(this.batchSize, this.fetchSize, this.databaseType, this.key2StringMapper, this.binaryTable.create(), this.stringTable.create(), (ConnectionFactoryConfiguration)this.connectionFactory.create(), this.manageConnectionFactory, this.lockAcquistionTimeout, this.lockConcurrencyLevel, this.purgeOnStartup, this.purgeSynchronously, this.purgerThreads, this.fetchPersistentState, this.ignoreModifications, TypedProperties.toTypedProperties((Properties)this.properties), this.async.create(), this.singletonStore.create());
    }

    public JdbcMixedCacheStoreConfigurationBuilder read(JdbcMixedCacheStoreConfiguration template) {
        super.readInternal(template);
        this.binaryTable.read(template.binaryTable());
        this.stringTable.read(template.stringTable());
        this.key2StringMapper = template.key2StringMapper();
        this.batchSize = template.batchSize();
        this.fetchSize = template.fetchSize();
        this.databaseType = template.databaseType();
        return this;
    }

    public class MixedTableManipulationConfigurationBuilder
    extends TableManipulationConfigurationBuilder<JdbcMixedCacheStoreConfigurationBuilder, MixedTableManipulationConfigurationBuilder>
    implements JdbcMixedCacheStoreConfigurationChildBuilder<JdbcMixedCacheStoreConfigurationBuilder> {
        MixedTableManipulationConfigurationBuilder(AbstractJdbcCacheStoreConfigurationBuilder<?, JdbcMixedCacheStoreConfigurationBuilder> builder) {
            super(builder);
        }

        public MixedTableManipulationConfigurationBuilder self() {
            return this;
        }

        @Override
        public MixedTableManipulationConfigurationBuilder binaryTable() {
            return JdbcMixedCacheStoreConfigurationBuilder.this.binaryTable;
        }

        @Override
        public MixedTableManipulationConfigurationBuilder stringTable() {
            return JdbcMixedCacheStoreConfigurationBuilder.this.stringTable;
        }

        @Override
        public PooledConnectionFactoryConfigurationBuilder<JdbcMixedCacheStoreConfigurationBuilder> connectionPool() {
            return JdbcMixedCacheStoreConfigurationBuilder.this.connectionPool();
        }

        @Override
        public ManagedConnectionFactoryConfigurationBuilder<JdbcMixedCacheStoreConfigurationBuilder> dataSource() {
            return JdbcMixedCacheStoreConfigurationBuilder.this.dataSource();
        }

        @Override
        public JdbcMixedCacheStoreConfigurationChildBuilder<JdbcMixedCacheStoreConfigurationBuilder> key2StringMapper(String key2StringMapper) {
            return JdbcMixedCacheStoreConfigurationBuilder.this.key2StringMapper(key2StringMapper);
        }

        @Override
        public JdbcMixedCacheStoreConfigurationChildBuilder<JdbcMixedCacheStoreConfigurationBuilder> key2StringMapper(Class<? extends Key2StringMapper> klass) {
            return JdbcMixedCacheStoreConfigurationBuilder.this.key2StringMapper(klass);
        }
    }
}

