/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class bla {
    protected JChannel ch;
    protected RpcDispatcher disp;
    protected int count = 1;

    public int incr() {
        int retval = this.count++;
        System.out.println("incremented count to " + retval);
        return retval;
    }

    protected void loop() {
        boolean discarding = false;
        boolean running = true;
        final RequestOptions opts = RequestOptions.SYNC().setTimeout(60000L);
        String input = "[1] invoke unicast RPC [d] toggle discarding messages (%s) [x] exit";
        while (running) {
            int c = Util.keyPress(String.format("[1] invoke unicast RPC [d] toggle discarding messages (%s) [x] exit", discarding));
            switch (c) {
                case 49: {
                    final Address dest = this.getReceiver();
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                Object rsp = bla.this.disp.callRemoteMethod(dest, "incr", null, null, opts);
                                System.out.println("rsp=" + rsp);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                    break;
                }
                case 100: {
                    if (discarding) {
                        this.disableDiscard();
                        discarding = false;
                        break;
                    }
                    this.enableDiscard();
                    discarding = true;
                    break;
                }
                case 120: {
                    running = false;
                }
            }
        }
    }

    protected void disableDiscard() {
        DISCARD discard = (DISCARD)this.ch.getProtocolStack().findProtocol((Class<?>)DISCARD.class);
        discard.setDiscardAll(false);
    }

    protected void enableDiscard() {
        DISCARD discard = (DISCARD)this.ch.getProtocolStack().findProtocol((Class<?>)DISCARD.class);
        discard.setDiscardAll(true);
    }

    protected Address getReceiver() {
        try {
            ArrayList<Address> mbrs = new ArrayList<Address>(this.ch.getView().getMembers());
            System.out.println("pick receiver from the following members:");
            int i = 0;
            for (Address mbr : mbrs) {
                if (mbr.equals(this.ch.getAddress())) {
                    System.out.println("[" + i + "]: " + mbr + " (self)");
                } else {
                    System.out.println("[" + i + "]: " + mbr);
                }
                ++i;
            }
            System.out.flush();
            System.in.skip(System.in.available());
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String str = reader.readLine().trim();
            int index = Integer.parseInt(str);
            return (Address)mbrs.get(index);
        }
        catch (Exception e) {
            System.err.println("UnicastTest.getReceiver(): " + e);
            return null;
        }
    }

    public void start() throws Exception {
        this.ch = new JChannel("/home/bela/session_udp.xml");
        this.disp = new RpcDispatcher((Channel)this.ch, null, (MembershipListener)new ReceiverAdapter(){

            @Override
            public void viewAccepted(View view) {
                System.out.println("view = " + view);
            }
        }, this);
        if (this.ch.getProtocolStack().findProtocol((Class<?>)DISCARD.class) == null) {
            this.ch.getProtocolStack().insertProtocol((Protocol)new DISCARD(), 1, (Class<? extends Protocol>)TP.class);
        }
        this.ch.connect("cluster");
        this.loop();
        Util.close((Channel)this.ch);
    }

    public static void main(String[] args) throws Exception {
        new bla().start();
    }
}

