/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.remote.configuration.ConnectionPoolConfiguration;
import org.infinispan.loaders.remote.configuration.RemoteCacheStoreConfiguration;
import org.infinispan.loaders.remote.configuration.RemoteServerConfiguration;
import org.infinispan.loaders.remote.logging.Log;
import org.infinispan.loaders.remote.wrapper.HotRodEntryMarshaller;
import org.infinispan.loaders.spi.AbstractCacheStore;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class RemoteCacheStore
extends AbstractCacheStore {
    private static final Log log = (Log)LogFactory.getLog(RemoteCacheStore.class, Log.class);
    private RemoteCacheStoreConfiguration configuration;
    private volatile RemoteCacheManager remoteCacheManager;
    private volatile RemoteCache<Object, Object> remoteCache;
    private InternalEntryFactory iceFactory;
    private static final String LIFESPAN = "lifespan";
    private static final String MAXIDLE = "maxidle";

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        if (this.configuration.rawValues()) {
            MetadataValue value = this.remoteCache.getWithMetadata(key);
            if (value != null) {
                return this.iceFactory.create(key, value.getValue(), (EntryVersion)new NumericVersion(value.getVersion()), value.getCreated(), TimeUnit.SECONDS.toMillis(value.getLifespan()), value.getLastUsed(), TimeUnit.SECONDS.toMillis(value.getMaxIdle()));
            }
            return null;
        }
        return (InternalCacheEntry)this.remoteCache.get(key);
    }

    protected void purgeInternal() throws CacheLoaderException {
        if (log.isTraceEnabled()) {
            log.trace("Skipping purge call, as this is performed on the remote cache.");
        }
    }

    public boolean containsKey(Object key) throws CacheLoaderException {
        return this.remoteCache.containsKey(key);
    }

    public void store(InternalCacheEntry entry) throws CacheLoaderException {
        if (log.isTraceEnabled()) {
            log.tracef("Adding entry: %s", entry);
        }
        this.remoteCache.put(entry.getKey(), this.configuration.rawValues() ? entry.getValue() : entry, this.toSeconds(entry.getLifespan(), entry, LIFESPAN), TimeUnit.SECONDS, this.toSeconds(entry.getMaxIdle(), entry, MAXIDLE), TimeUnit.SECONDS);
    }

    public void fromStream(ObjectInput inputStream) throws CacheLoaderException {
        try {
            Map result = (Map)this.marshaller.objectFromObjectStream(inputStream);
            this.remoteCache.putAll(result);
        }
        catch (Exception e) {
            throw new CacheLoaderException("Exception while reading data", (Throwable)e);
        }
    }

    public void toStream(ObjectOutput outputStream) throws CacheLoaderException {
        Map map = this.remoteCache.getBulk();
        try {
            this.marshaller.objectToObjectStream((Object)map, outputStream);
        }
        catch (IOException e) {
            throw new CacheLoaderException("Exception while serializing remote data to stream", (Throwable)e);
        }
    }

    public void clear() throws CacheLoaderException {
        this.remoteCache.clear();
    }

    public boolean remove(Object key) throws CacheLoaderException {
        return this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove(key) != null;
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        Map map = this.remoteCache.getBulk();
        return this.convertToInternalCacheEntries(map);
    }

    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        return this.convertToInternalCacheEntries(this.remoteCache.getBulk(numEntries));
    }

    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        log.sharedModeOnlyAllowed();
        throw new CacheLoaderException("RemoteCacheStore can only run in shared mode! This method shouldn't be called in shared mode");
    }

    public void init(CacheLoaderConfiguration configuration, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        if (!(configuration instanceof RemoteCacheStoreConfiguration)) {
            throw new CacheLoaderException("Incompatible configuration bean passed. Has to be an instance of " + RemoteCacheStoreConfiguration.class.getName());
        }
        this.configuration = (RemoteCacheStoreConfiguration)configuration;
        super.init(configuration, cache, m);
    }

    public void start() throws CacheLoaderException {
        super.start();
        Object marshaller = this.configuration.marshaller() != null ? (Marshaller)Util.getInstance((String)this.configuration.marshaller(), (ClassLoader)this.cache.getCacheConfiguration().classLoader()) : (this.configuration.hotRodWrapping() ? new HotRodEntryMarshaller() : (this.configuration.rawValues() ? new GenericJBossMarshaller() : this.getMarshaller()));
        ConfigurationBuilder builder = this.buildRemoteConfiguration(this.configuration, (Marshaller)marshaller);
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
        this.remoteCache = this.configuration.remoteCacheName().equals("___defaultcache") ? this.remoteCacheManager.getCache() : this.remoteCacheManager.getCache(this.configuration.remoteCacheName());
        if (this.configuration.rawValues() && this.iceFactory == null) {
            this.iceFactory = (InternalEntryFactory)this.cache.getAdvancedCache().getComponentRegistry().getComponent(InternalEntryFactory.class);
        }
    }

    public void stop() throws CacheLoaderException {
        super.stop();
        this.remoteCacheManager.stop();
    }

    private long toSeconds(long millis, InternalCacheEntry entry, String desc) {
        if (millis > 0L && millis < 1000L) {
            if (log.isTraceEnabled()) {
                log.tracef("Adjusting %s time for (k,v): (%s, %s) from %d millis to 1 sec, as milliseconds are not supported by HotRod", new Object[]{desc, entry.getKey(), entry.getValue(), millis});
            }
            return 1L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    private Set<InternalCacheEntry> convertToInternalCacheEntries(Map<Object, Object> map) throws CacheLoaderException {
        HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>(map.size());
        Set<Map.Entry<Object, Object>> set = map.entrySet();
        for (Map.Entry<Object, Object> e : set) {
            if (this.configuration.rawValues()) {
                result.add(this.load(e.getKey()));
                continue;
            }
            result.add((InternalCacheEntry)e.getValue());
        }
        return result;
    }

    public void setInternalCacheEntryFactory(InternalEntryFactory iceFactory) {
        if (this.iceFactory != null) {
            throw new IllegalStateException();
        }
        this.iceFactory = iceFactory;
    }

    public RemoteCache<Object, Object> getRemoteCache() {
        return this.remoteCache;
    }

    private ConfigurationBuilder buildRemoteConfiguration(RemoteCacheStoreConfiguration configuration, Marshaller marshaller) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        for (RemoteServerConfiguration s : configuration.servers()) {
            builder.addServer().host(s.host()).port(s.port());
        }
        ConnectionPoolConfiguration poolConfiguration = configuration.connectionPool();
        Long connectionTimeout = configuration.connectionTimeout();
        Long socketTimeout = configuration.socketTimeout();
        builder.balancingStrategy(configuration.balancingStrategy()).connectionPool().exhaustedAction(ExhaustedAction.valueOf((String)poolConfiguration.exhaustedAction().toString())).maxActive(poolConfiguration.maxActive()).maxIdle(poolConfiguration.maxIdle()).maxTotal(poolConfiguration.maxTotal()).minIdle(poolConfiguration.minIdle()).minEvictableIdleTime(poolConfiguration.minEvictableIdleTime()).testWhileIdle(poolConfiguration.testWhileIdle()).timeBetweenEvictionRuns(poolConfiguration.timeBetweenEvictionRuns()).connectionTimeout(connectionTimeout.intValue()).forceReturnValues(configuration.forceReturnValues()).keySizeEstimate(configuration.keySizeEstimate()).marshaller(marshaller).asyncExecutorFactory().factoryClass(configuration.asyncExecutorFactory().factory().getClass()).classLoader(((Object)((Object)configuration)).getClass().getClassLoader()).pingOnStartup(configuration.pingOnStartup()).socketTimeout(socketTimeout.intValue()).tcpNoDelay(configuration.tcpNoDelay()).valueSizeEstimate(configuration.valueSizeEstimate());
        if (configuration.protocolVersion() != null) {
            builder.protocolVersion(configuration.protocolVersion());
        }
        if (configuration.transportFactory() != null) {
            builder.transportFactory(configuration.transportFactory());
        }
        return builder;
    }
}

