/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.transaction.xa.Xid;
import org.infinispan.Cache;
import org.infinispan.atomic.Delta;
import org.infinispan.commands.CancelCommand;
import org.infinispan.commands.CancellationService;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.MapCombineCommand;
import org.infinispan.commands.read.ReduceCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.read.ValuesCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderNonVersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderRollbackCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedPrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distexec.mapreduce.MapReduceManager;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.XSiteAdminCommand;

public class CommandsFactoryImpl
implements CommandsFactory {
    private static final Log log = LogFactory.getLog(CommandsFactoryImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private DataContainer dataContainer;
    private CacheNotifier notifier;
    private Cache<Object, Object> cache;
    private String cacheName;
    private boolean totalOrderProtocol;
    private InterceptorChain interceptorChain;
    private DistributionManager distributionManager;
    private InvocationContextContainer icc;
    private TransactionTable txTable;
    private Configuration configuration;
    private RecoveryManager recoveryManager;
    private StateProvider stateProvider;
    private StateConsumer stateConsumer;
    private LockManager lockManager;
    private InternalEntryFactory entryFactory;
    private MapReduceManager mapReduceManager;
    private StateTransferManager stateTransferManager;
    private BackupSender backupSender;
    private CancellationService cancellationService;
    private TimeService timeService;
    private Map<Byte, ModuleCommandInitializer> moduleCommandInitializers;

    @Inject
    public void setupDependencies(DataContainer container, CacheNotifier notifier, Cache<Object, Object> cache, InterceptorChain interceptorChain, DistributionManager distributionManager, InvocationContextContainer icc, TransactionTable txTable, Configuration configuration, @ComponentName(value="org.infinispan.modules.command.initializers") Map<Byte, ModuleCommandInitializer> moduleCommandInitializers, RecoveryManager recoveryManager, StateProvider stateProvider, StateConsumer stateConsumer, LockManager lockManager, InternalEntryFactory entryFactory, MapReduceManager mapReduceManager, StateTransferManager stm, BackupSender backupSender, CancellationService cancellationService, TimeService timeService) {
        this.dataContainer = container;
        this.notifier = notifier;
        this.cache = cache;
        this.interceptorChain = interceptorChain;
        this.distributionManager = distributionManager;
        this.icc = icc;
        this.txTable = txTable;
        this.configuration = configuration;
        this.moduleCommandInitializers = moduleCommandInitializers;
        this.recoveryManager = recoveryManager;
        this.stateProvider = stateProvider;
        this.stateConsumer = stateConsumer;
        this.lockManager = lockManager;
        this.entryFactory = entryFactory;
        this.mapReduceManager = mapReduceManager;
        this.stateTransferManager = stm;
        this.backupSender = backupSender;
        this.cancellationService = cancellationService;
        this.timeService = timeService;
    }

    @Start(priority=1)
    public void start() {
        this.cacheName = this.cache.getName();
        this.totalOrderProtocol = this.configuration.transaction().transactionProtocol().isTotalOrder();
    }

    @Override
    public PutKeyValueCommand buildPutKeyValueCommand(Object key, Object value, Metadata metadata, Set<Flag> flags) {
        return new PutKeyValueCommand(key, value, false, this.notifier, metadata, flags);
    }

    @Override
    public RemoveCommand buildRemoveCommand(Object key, Object value, Set<Flag> flags) {
        return new RemoveCommand(key, value, this.notifier, flags);
    }

    @Override
    public InvalidateCommand buildInvalidateCommand(Set<Flag> flags, Object ... keys) {
        return new InvalidateCommand(this.notifier, flags, keys);
    }

    @Override
    public InvalidateCommand buildInvalidateFromL1Command(boolean forRehash, Set<Flag> flags, Collection<Object> keys) {
        return new InvalidateL1Command(forRehash, this.dataContainer, this.configuration, this.distributionManager, this.notifier, flags, keys);
    }

    @Override
    public InvalidateCommand buildInvalidateFromL1Command(Address origin, boolean forRehash, Set<Flag> flags, Collection<Object> keys) {
        return new InvalidateL1Command(origin, forRehash, this.dataContainer, this.configuration, this.distributionManager, this.notifier, flags, keys);
    }

    @Override
    public ReplaceCommand buildReplaceCommand(Object key, Object oldValue, Object newValue, Metadata metadata, Set<Flag> flags) {
        return new ReplaceCommand(key, oldValue, newValue, this.notifier, metadata, flags, this.configuration.dataContainer().valueEquivalence());
    }

    @Override
    public SizeCommand buildSizeCommand(Set<Flag> flags) {
        return new SizeCommand(this.dataContainer, flags);
    }

    @Override
    public KeySetCommand buildKeySetCommand(Set<Flag> flags) {
        return new KeySetCommand(this.dataContainer, flags);
    }

    @Override
    public ValuesCommand buildValuesCommand(Set<Flag> flags) {
        return new ValuesCommand(this.dataContainer, this.timeService, flags);
    }

    @Override
    public EntrySetCommand buildEntrySetCommand(Set<Flag> flags) {
        return new EntrySetCommand(this.dataContainer, this.entryFactory, this.timeService, flags);
    }

    @Override
    public GetKeyValueCommand buildGetKeyValueCommand(Object key, Set<Flag> flags, boolean returnEntry) {
        return new GetKeyValueCommand(key, flags, returnEntry);
    }

    @Override
    public PutMapCommand buildPutMapCommand(Map<?, ?> map, Metadata metadata, Set<Flag> flags) {
        return new PutMapCommand(map, this.notifier, metadata, flags);
    }

    @Override
    public ClearCommand buildClearCommand(Set<Flag> flags) {
        return new ClearCommand(this.notifier, flags);
    }

    @Override
    public EvictCommand buildEvictCommand(Object key, Set<Flag> flags) {
        return new EvictCommand(key, this.notifier, flags);
    }

    @Override
    public PrepareCommand buildPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
        return this.totalOrderProtocol ? new TotalOrderNonVersionedPrepareCommand(this.cacheName, gtx, modifications) : new PrepareCommand(this.cacheName, gtx, modifications, onePhaseCommit);
    }

    @Override
    public VersionedPrepareCommand buildVersionedPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhase) {
        return this.totalOrderProtocol ? new TotalOrderVersionedPrepareCommand(this.cacheName, gtx, modifications, onePhase) : new VersionedPrepareCommand(this.cacheName, gtx, modifications, onePhase);
    }

    @Override
    public CommitCommand buildCommitCommand(GlobalTransaction gtx) {
        return this.totalOrderProtocol ? new TotalOrderCommitCommand(this.cacheName, gtx) : new CommitCommand(this.cacheName, gtx);
    }

    @Override
    public VersionedCommitCommand buildVersionedCommitCommand(GlobalTransaction gtx) {
        return this.totalOrderProtocol ? new TotalOrderVersionedCommitCommand(this.cacheName, gtx) : new VersionedCommitCommand(this.cacheName, gtx);
    }

    @Override
    public RollbackCommand buildRollbackCommand(GlobalTransaction gtx) {
        return this.totalOrderProtocol ? new TotalOrderRollbackCommand(this.cacheName, gtx) : new RollbackCommand(this.cacheName, gtx);
    }

    @Override
    public MultipleRpcCommand buildReplicateCommand(List<ReplicableCommand> toReplicate) {
        return new MultipleRpcCommand(toReplicate, this.cacheName);
    }

    @Override
    public SingleRpcCommand buildSingleRpcCommand(ReplicableCommand call) {
        return new SingleRpcCommand(this.cacheName, call);
    }

    @Override
    public ClusteredGetCommand buildClusteredGetCommand(Object key, Set<Flag> flags, boolean acquireRemoteLock, GlobalTransaction gtx) {
        return new ClusteredGetCommand(key, this.cacheName, flags, acquireRemoteLock, gtx, this.configuration.dataContainer().keyEquivalence());
    }

    @Override
    public void initializeReplicableCommand(ReplicableCommand c, boolean isRemote) {
        if (c == null) {
            return;
        }
        switch (c.getCommandId()) {
            case 8: {
                ((PutKeyValueCommand)c).init(this.notifier);
                break;
            }
            case 11: {
                ((ReplaceCommand)c).init(this.notifier, this.configuration);
                break;
            }
            case 9: {
                ((PutMapCommand)c).init(this.notifier);
                break;
            }
            case 10: {
                ((RemoveCommand)c).init(this.notifier);
                break;
            }
            case 2: {
                MultipleRpcCommand rc = (MultipleRpcCommand)c;
                rc.init(this.interceptorChain, this.icc);
                if (rc.getCommands() == null) break;
                for (ReplicableCommand nested : rc.getCommands()) {
                    this.initializeReplicableCommand(nested, false);
                }
                break;
            }
            case 1: {
                SingleRpcCommand src = (SingleRpcCommand)c;
                src.init(this.interceptorChain, this.icc);
                if (src.getCommand() == null) break;
                this.initializeReplicableCommand(src.getCommand(), false);
                break;
            }
            case 6: {
                InvalidateCommand ic = (InvalidateCommand)c;
                ic.init(this.notifier);
                break;
            }
            case 7: {
                InvalidateL1Command ilc = (InvalidateL1Command)c;
                ilc.init(this.configuration, this.distributionManager, this.notifier, this.dataContainer);
                break;
            }
            case 12: 
            case 26: 
            case 38: 
            case 39: {
                PrepareCommand pc = (PrepareCommand)c;
                pc.init(this.interceptorChain, this.icc, this.txTable);
                pc.initialize(this.notifier, this.recoveryManager);
                if (pc.getModifications() != null) {
                    for (WriteCommand nested : pc.getModifications()) {
                        this.initializeReplicableCommand(nested, false);
                    }
                }
                pc.markTransactionAsRemote(isRemote);
                if (!this.configuration.deadlockDetection().enabled() || !isRemote) break;
                DldGlobalTransaction transaction = (DldGlobalTransaction)pc.getGlobalTransaction();
                transaction.setLocksHeldAtOrigin(pc.getAffectedKeys());
                break;
            }
            case 14: 
            case 27: 
            case 35: 
            case 36: {
                CommitCommand commitCommand = (CommitCommand)c;
                commitCommand.init(this.interceptorChain, this.icc, this.txTable);
                commitCommand.markTransactionAsRemote(isRemote);
                break;
            }
            case 13: 
            case 37: {
                RollbackCommand rollbackCommand = (RollbackCommand)c;
                rollbackCommand.init(this.interceptorChain, this.icc, this.txTable);
                rollbackCommand.markTransactionAsRemote(isRemote);
                break;
            }
            case 5: {
                ClearCommand cc = (ClearCommand)c;
                cc.init(this.notifier);
                break;
            }
            case 16: {
                ClusteredGetCommand clusteredGetCommand = (ClusteredGetCommand)c;
                clusteredGetCommand.initialize(this.icc, this, this.entryFactory, this.interceptorChain, this.distributionManager, this.txTable, this.configuration.dataContainer().keyEquivalence());
                break;
            }
            case 3: {
                DldGlobalTransaction gtx;
                RemoteTransaction transaction;
                LockControlCommand lcc = (LockControlCommand)c;
                lcc.init(this.interceptorChain, this.icc, this.txTable);
                lcc.markTransactionAsRemote(isRemote);
                if (!this.configuration.deadlockDetection().enabled() || !isRemote || (transaction = this.txTable.getRemoteTransaction(gtx = (DldGlobalTransaction)lcc.getGlobalTransaction())) == null) break;
                if (!this.configuration.clustering().cacheMode().isDistributed()) {
                    Set<Object> keys = this.txTable.getLockedKeysForRemoteTransaction(gtx);
                    GlobalTransaction gtx2 = transaction.getGlobalTransaction();
                    ((DldGlobalTransaction)gtx2).setLocksHeldAtOrigin(keys);
                    gtx.setLocksHeldAtOrigin(keys);
                    break;
                }
                GlobalTransaction gtx2 = transaction.getGlobalTransaction();
                ((DldGlobalTransaction)gtx2).setLocksHeldAtOrigin(gtx.getLocksHeldAtOrigin());
                break;
            }
            case 15: {
                ((StateRequestCommand)c).init(this.stateProvider);
                break;
            }
            case 20: {
                ((StateResponseCommand)c).init(this.stateConsumer);
                break;
            }
            case 21: {
                GetInDoubtTransactionsCommand gptx = (GetInDoubtTransactionsCommand)c;
                gptx.init(this.recoveryManager);
                break;
            }
            case 22: {
                TxCompletionNotificationCommand ftx = (TxCompletionNotificationCommand)c;
                ftx.init(this.txTable, this.lockManager, this.recoveryManager, this.stateTransferManager);
                break;
            }
            case 30: {
                MapCombineCommand mrc = (MapCombineCommand)c;
                mrc.init(this.mapReduceManager);
                break;
            }
            case 31: {
                ReduceCommand reduceCommand = (ReduceCommand)c;
                reduceCommand.init(this.mapReduceManager);
                break;
            }
            case 19: {
                DistributedExecuteCommand dec = (DistributedExecuteCommand)c;
                dec.init(this.cache);
                break;
            }
            case 23: {
                GetInDoubtTxInfoCommand gidTxInfoCommand = (GetInDoubtTxInfoCommand)c;
                gidTxInfoCommand.init(this.recoveryManager);
                break;
            }
            case 24: {
                CompleteTransactionCommand ccc = (CompleteTransactionCommand)c;
                ccc.init(this.recoveryManager);
                break;
            }
            case 25: {
                break;
            }
            case 29: {
                CreateCacheCommand createCacheCommand = (CreateCacheCommand)c;
                createCacheCommand.init(this.cache.getCacheManager());
                break;
            }
            case 32: {
                XSiteAdminCommand xSiteAdminCommand = (XSiteAdminCommand)c;
                xSiteAdminCommand.init(this.backupSender);
                break;
            }
            case 34: {
                CancelCommand cancelCommand = (CancelCommand)c;
                cancelCommand.init(this.cancellationService);
                break;
            }
            default: {
                ModuleCommandInitializer mci = this.moduleCommandInitializers.get(c.getCommandId());
                if (mci != null) {
                    mci.initializeReplicableCommand(c, isRemote);
                    break;
                }
                if (!trace) break;
                log.tracef("Nothing to initialize for command: %s", c);
            }
        }
    }

    @Override
    public LockControlCommand buildLockControlCommand(Collection<Object> keys, Set<Flag> flags, GlobalTransaction gtx) {
        return new LockControlCommand(keys, this.cacheName, flags, gtx);
    }

    @Override
    public LockControlCommand buildLockControlCommand(Object key, Set<Flag> flags, GlobalTransaction gtx) {
        return new LockControlCommand(key, this.cacheName, flags, gtx);
    }

    @Override
    public LockControlCommand buildLockControlCommand(Collection<Object> keys, Set<Flag> flags) {
        return new LockControlCommand(keys, this.cacheName, flags, null);
    }

    @Override
    public StateRequestCommand buildStateRequestCommand(StateRequestCommand.Type subtype, Address sender, int viewId, Set<Integer> segments) {
        return new StateRequestCommand(this.cacheName, subtype, sender, viewId, segments);
    }

    @Override
    public StateResponseCommand buildStateResponseCommand(Address sender, int viewId, Collection<StateChunk> stateChunks) {
        return new StateResponseCommand(this.cacheName, sender, viewId, stateChunks);
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public GetInDoubtTransactionsCommand buildGetInDoubtTransactionsCommand() {
        return new GetInDoubtTransactionsCommand(this.cacheName);
    }

    @Override
    public TxCompletionNotificationCommand buildTxCompletionNotificationCommand(Xid xid, GlobalTransaction globalTransaction) {
        return new TxCompletionNotificationCommand(xid, globalTransaction, this.cacheName);
    }

    @Override
    public TxCompletionNotificationCommand buildTxCompletionNotificationCommand(long internalId) {
        return new TxCompletionNotificationCommand(internalId, this.cacheName);
    }

    @Override
    public <T> DistributedExecuteCommand<T> buildDistributedExecuteCommand(Callable<T> callable, Address sender, Collection keys) {
        return new DistributedExecuteCommand<T>(this.cacheName, keys, callable);
    }

    @Override
    public <KIn, VIn, KOut, VOut> MapCombineCommand<KIn, VIn, KOut, VOut> buildMapCombineCommand(String taskId, Mapper<KIn, VIn, KOut, VOut> m, Reducer<KOut, VOut> r, Collection<KIn> keys) {
        return new MapCombineCommand<KIn, VIn, KOut, VOut>(taskId, m, r, this.cacheName, keys);
    }

    @Override
    public GetInDoubtTxInfoCommand buildGetInDoubtTxInfoCommand() {
        return new GetInDoubtTxInfoCommand(this.cacheName);
    }

    @Override
    public CompleteTransactionCommand buildCompleteTransactionCommand(Xid xid, boolean commit) {
        return new CompleteTransactionCommand(this.cacheName, xid, commit);
    }

    @Override
    public ApplyDeltaCommand buildApplyDeltaCommand(Object deltaAwareValueKey, Delta delta, Collection keys) {
        return new ApplyDeltaCommand(deltaAwareValueKey, delta, keys);
    }

    @Override
    public CreateCacheCommand buildCreateCacheCommand(String cacheNameToCreate, String cacheConfigurationName) {
        return new CreateCacheCommand(this.cacheName, cacheNameToCreate, cacheConfigurationName);
    }

    @Override
    public CreateCacheCommand buildCreateCacheCommand(String cacheNameToCreate, String cacheConfigurationName, boolean start, int size) {
        return new CreateCacheCommand(this.cacheName, cacheNameToCreate, cacheConfigurationName, start, size);
    }

    @Override
    public <KOut, VOut> ReduceCommand<KOut, VOut> buildReduceCommand(String taskId, String destintationCache, Reducer<KOut, VOut> r, Collection<KOut> keys) {
        return new ReduceCommand<KOut, VOut>(taskId, r, destintationCache, keys);
    }

    @Override
    public CancelCommand buildCancelCommandCommand(UUID commandUUID) {
        return new CancelCommand(this.cacheName, commandUUID);
    }
}

