/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Set;
import org.infinispan.commands.LocalCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EvictCommand
extends RemoveCommand
implements LocalCommand {
    private static final Log log = LogFactory.getLog(EvictCommand.class);

    public EvictCommand(Object key, CacheNotifier notifier, Set<Flag> flags) {
        super(key, null, notifier, flags);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitEvictCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.key == null) {
            throw new NullPointerException("Key is null!!");
        }
        super.perform(ctx);
        return null;
    }

    @Override
    public void notify(InvocationContext ctx, Object value, boolean isPre) {
        if (!isPre) {
            if (log.isTraceEnabled()) {
                log.tracef("Notify eviction listeners for key=%", this.key);
            }
            this.notifier.notifyCacheEntryEvicted(this.key, value, ctx, this);
        }
    }

    @Override
    public byte getCommandId() {
        return -1;
    }

    @Override
    public String toString() {
        return "EvictCommand{key=" + this.key + ", value=" + this.value + ", flags=" + this.flags + "}";
    }
}

