/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.config.CloneableConfigurationComponent;
import org.infinispan.config.Dynamic;
import org.infinispan.config.JAXBUnmarshallable;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public abstract class AbstractConfigurationBean
implements CloneableConfigurationComponent,
JAXBUnmarshallable {
    private static final long serialVersionUID = 4879873994727821938L;
    private static final Log log = LogFactory.getLog(AbstractConfigurationBean.class);
    private boolean accessible;
    protected Set<String> overriddenConfigurationElements = new HashSet<String>(4);

    protected AbstractConfigurationBean() {
    }

    protected String uc(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }

    protected static TypedProperties toTypedProperties(Properties p) {
        return TypedProperties.toTypedProperties((Properties)p);
    }

    protected static TypedProperties toTypedProperties(String s) {
        TypedProperties tp = new TypedProperties();
        if (s != null && s.trim().length() > 0) {
            ByteArrayInputStream stream = new ByteArrayInputStream(s.getBytes());
            try {
                tp.load((InputStream)stream);
            }
            catch (IOException e) {
                throw new CacheConfigurationException("Unable to parse properties string " + s, (Throwable)e);
            }
        }
        return tp;
    }

    protected abstract boolean hasComponentStarted();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testImmutability(String fieldName) {
        try {
            if (!this.accessible && this.hasComponentStarted() && !this.getClass().getDeclaredField(fieldName).isAnnotationPresent(Dynamic.class)) {
                throw new CacheConfigurationException("Attempted to modify a non-Dynamic configuration element [" + fieldName + "] after the component has started!");
            }
        }
        catch (NoSuchFieldException e) {
            log.fieldNotFound(fieldName);
        }
        finally {
            this.accessible = false;
        }
        this.overriddenConfigurationElements.add(fieldName);
    }

    @Override
    public CloneableConfigurationComponent clone() throws CloneNotSupportedException {
        AbstractConfigurationBean dolly = (AbstractConfigurationBean)super.clone();
        dolly.overriddenConfigurationElements = new HashSet<String>(this.overriddenConfigurationElements);
        return dolly;
    }

    @Override
    public void willUnmarshall(Object parent) {
    }
}

