/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.transaction.LockingMode;

public class Configurations {
    private Configurations() {
    }

    public static boolean isSecondPhaseAsync(Configuration cfg) {
        ClusteringConfiguration clusteringCfg = cfg.clustering();
        return !cfg.transaction().syncCommitPhase() || clusteringCfg.async().useReplQueue() || !clusteringCfg.cacheMode().isSynchronous();
    }

    public static boolean isOnePhaseCommit(Configuration cfg) {
        return !cfg.clustering().cacheMode().isSynchronous() || cfg.transaction().lockingMode() == LockingMode.PESSIMISTIC;
    }

    public static boolean isStateTransferEnabled(Configuration cfg) {
        return cfg.clustering().stateTransfer().fetchInMemoryState() || cfg.loaders().fetchPersistentState() != false;
    }

    public static boolean isOnePhaseTotalOrderCommit(Configuration cfg) {
        return cfg.transaction().transactionProtocol().isTotalOrder() && !Configurations.isVersioningEnabled(cfg);
    }

    public static boolean isVersioningEnabled(Configuration cfg) {
        return cfg.locking().writeSkewCheck() && cfg.transaction().lockingMode() == LockingMode.OPTIMISTIC && cfg.versioning().enabled();
    }
}

