/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commands.read.MapCombineCommand;
import org.infinispan.commands.read.ReduceCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceManager;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distexec.mapreduce.spi.MapReduceTaskLifecycleService;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.manager.CacheLoaderManager;
import org.infinispan.loaders.spi.CacheLoader;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.MarshalledValue;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MapReduceManagerImpl
implements MapReduceManager {
    private static final Log log = LogFactory.getLog(MapReduceManagerImpl.class);
    private static final int CANCELLATION_CHECK_FREQUENCY = 20;
    private ClusteringDependentLogic cdl;
    private EmbeddedCacheManager cacheManager;
    private CacheLoaderManager cacheLoaderManager;
    private ExecutorService executorService;
    private TimeService timeService;

    MapReduceManagerImpl() {
    }

    @Inject
    public void init(EmbeddedCacheManager cacheManager, CacheLoaderManager cacheLoaderManager, @ComponentName(value="org.infinispan.executors.transport") ExecutorService asyncTransportExecutor, ClusteringDependentLogic cdl, TimeService timeService) {
        this.cacheManager = cacheManager;
        this.cacheLoaderManager = cacheLoaderManager;
        this.cdl = cdl;
        this.executorService = asyncTransportExecutor;
        this.timeService = timeService;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public <KIn, VIn, KOut, VOut> Map<KOut, List<VOut>> mapAndCombineForLocalReduction(MapCombineCommand<KIn, VIn, KOut, VOut> mcc) throws InterruptedException {
        CollectableCollector<KOut, VOut> collector = this.map(mcc);
        return this.combineForLocalReduction(mcc, collector);
    }

    @Override
    public <KIn, VIn, KOut, VOut> Set<KOut> mapAndCombineForDistributedReduction(MapCombineCommand<KIn, VIn, KOut, VOut> mcc) throws InterruptedException {
        CollectableCollector<KOut, VOut> collector = this.map(mcc);
        try {
            return this.combine(mcc, collector);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <KOut, VOut> Map<KOut, VOut> reduce(ReduceCommand<KOut, VOut> reduceCommand) throws InterruptedException {
        Cache cache = this.cacheManager.getCache(reduceCommand.getCacheName());
        Set<KOut> keys = reduceCommand.getKeys();
        String taskId = reduceCommand.getTaskId();
        Reducer reducer = reduceCommand.getReducer();
        boolean useIntermediateKeys = reduceCommand.isEmitCompositeIntermediateKeys();
        boolean noInputKeys = keys == null || keys.isEmpty();
        Cache tmpCache = this.cacheManager.getCache(reduceCommand.getCacheName());
        HashMap<KOut, VOut> result = new HashMap<KOut, VOut>();
        if (noInputKeys) {
            throw new IllegalStateException("Reduce phase of MapReduceTask " + taskId + " on node " + this.cdl.getAddress() + " executed with empty input keys");
        }
        MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
        log.tracef("For m/r task %s invoking %s at %s", taskId, reduceCommand, this.cdl.getAddress());
        int interruptCount = 0;
        long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
        try {
            taskLifecycleService.onPreExecute(reducer, cache);
            for (KOut key : keys) {
                int n = ++interruptCount;
                ++interruptCount;
                if (this.checkInterrupt(n) && Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                List value = useIntermediateKeys ? (List)tmpCache.get(new IntermediateCompositeKey<KOut>(taskId, key)) : (List)tmpCache.get(key);
                VOut reduced = reducer.reduce(key, value.iterator());
                result.put(key, reduced);
                log.tracef("For m/r task %s reduced %s to %s at %s ", new Object[]{taskId, key, reduced, this.cdl.getAddress()});
            }
        }
        finally {
            if (log.isTraceEnabled()) {
                log.tracef("Reduce for task %s took %s milliseconds", reduceCommand.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS));
            }
            taskLifecycleService.onPostExecute(reducer);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <KIn, VIn, KOut, VOut> CollectableCollector<KOut, VOut> map(MapCombineCommand<KIn, VIn, KOut, VOut> mcc) throws InterruptedException {
        Cache cache = this.cacheManager.getCache(mcc.getCacheName());
        Set<KIn> keys = mcc.getKeys();
        HashSet<KIn> inputKeysCopy = null;
        Mapper mapper = mcc.getMapper();
        DistributionManager dm = cache.getAdvancedCache().getDistributionManager();
        boolean inputKeysSpecified = keys != null && !keys.isEmpty();
        Set<Object> inputKeys = keys;
        if (!inputKeysSpecified) {
            inputKeys = this.filterLocalPrimaryOwner(cache.keySet(), dm);
        } else {
            inputKeysCopy = new HashSet<KIn>(keys);
        }
        MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
        DefaultCollector collector = new DefaultCollector();
        log.tracef("For m/r task %s invoking %s with input keys %s", mcc.getTaskId(), mcc, inputKeys);
        int interruptCount = 0;
        long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
        try {
            taskLifecycleService.onPreExecute(mapper, cache);
            for (Object key : inputKeys) {
                if (this.checkInterrupt(interruptCount++) && Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                Object value = cache.get(key);
                mapper.map(key, value, collector);
                if (!inputKeysSpecified) continue;
                inputKeysCopy.remove(key);
            }
            Set<Object> keysFromCacheLoader = null;
            keysFromCacheLoader = inputKeysSpecified ? this.filterLocalPrimaryOwner(inputKeysCopy, dm) : this.filterLocalPrimaryOwner(this.loadAllKeysFromCacheLoaderUsingFilter(inputKeys), dm);
            log.tracef("For m/r task %s cache loader input keys %s", mcc.getTaskId(), keysFromCacheLoader);
            interruptCount = 0;
            for (Object key : keysFromCacheLoader) {
                if (this.checkInterrupt(interruptCount++) && Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                KOut value = this.loadValueFromCacheLoader(key);
                if (value == null) continue;
                mapper.map(key, value, collector);
            }
        }
        finally {
            if (log.isTraceEnabled()) {
                log.tracef("Map phase for task %s took %s milliseconds", mcc.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS));
            }
            taskLifecycleService.onPostExecute(mapper);
        }
        return collector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <KIn, VIn, KOut, VOut> Set<KOut> combine(MapCombineCommand<KIn, VIn, KOut, VOut> mcc, CollectableCollector<KOut, VOut> collector) throws Exception {
        String taskId = mcc.getTaskId();
        boolean emitCompositeIntermediateKeys = mcc.isEmitCompositeIntermediateKeys();
        Reducer<KOut, VOut> combiner = mcc.getCombiner();
        HashSet<Object> mapPhaseKeys = new HashSet<Object>();
        Cache tmpCache = null;
        tmpCache = emitCompositeIntermediateKeys ? this.cacheManager.getCache("__tmpMapReduce") : this.cacheManager.getCache(taskId);
        if (tmpCache == null) {
            throw new IllegalStateException("Temporary cache for MapReduceTask " + taskId + " not found on " + this.cdl.getAddress());
        }
        DistributionManager dm = tmpCache.getAdvancedCache().getDistributionManager();
        if (combiner != null) {
            Cache cache = this.cacheManager.getCache(mcc.getCacheName());
            log.tracef("For m/r task %s invoking combiner %s at %s", taskId, mcc, this.cdl.getAddress());
            MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
            ConcurrentHashMap<KOut, VOut> combinedMap = new ConcurrentHashMap<KOut, VOut>();
            long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
            try {
                taskLifecycleService.onPreExecute(combiner, cache);
                Map<KOut, List<VOut>> collectedValues = collector.collectedValues();
                for (Map.Entry<KOut, List<VOut>> entry : collectedValues.entrySet()) {
                    VOut combined;
                    List<VOut> list = entry.getValue();
                    if (list.size() > 1) {
                        combined = combiner.reduce(entry.getKey(), list.iterator());
                        combinedMap.put(entry.getKey(), combined);
                    } else {
                        combined = list.get(0);
                        combinedMap.put(entry.getKey(), combined);
                    }
                    log.tracef("For m/r task %s combined %s to %s at %s", new Object[]{taskId, entry.getKey(), combined, this.cdl.getAddress()});
                }
            }
            finally {
                if (log.isTraceEnabled()) {
                    log.tracef("Combine for task %s took %s milliseconds", mcc.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS));
                }
                taskLifecycleService.onPostExecute(combiner);
            }
            Map keysToNodes = this.mapKeysToNodes(dm, taskId, combinedMap.keySet(), emitCompositeIntermediateKeys);
            start = log.isTraceEnabled() ? this.timeService.time() : 0L;
            try {
                for (Map.Entry<Object, List<Object>> entry : keysToNodes.entrySet()) {
                    List<Object> keysHashedToAddress = entry.getValue();
                    try {
                        log.tracef("For m/r task %s migrating intermediate keys %s to %s", taskId, keysHashedToAddress, entry.getKey());
                        for (Object key : keysHashedToAddress) {
                            Object value = combinedMap.get(key);
                            DeltaAwareList delta = new DeltaAwareList(value);
                            if (emitCompositeIntermediateKeys) {
                                tmpCache.put(new IntermediateCompositeKey<Object>(taskId, key), delta);
                            } else {
                                tmpCache.put(key, delta);
                            }
                            mapPhaseKeys.add(key);
                        }
                    }
                    catch (Exception e) {
                        throw new CacheException("Could not move intermediate keys/values for M/R task " + taskId, (Throwable)e);
                        return mapPhaseKeys;
                    }
                }
            }
            finally {
                if (log.isTraceEnabled()) {
                    log.tracef("Migrating keys for task %s took %s milliseconds (Migrated %s keys)", mcc.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS), mapPhaseKeys.size());
                }
            }
        }
        Map<KOut, List<VOut>> collectedValues = collector.collectedValues();
        Map<Address, List<KOut>> keysToNodes = this.mapKeysToNodes(dm, taskId, collectedValues.keySet(), emitCompositeIntermediateKeys);
        long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
        try {
            for (Map.Entry<Address, List<KOut>> entry : keysToNodes.entrySet()) {
                List<KOut> keysHashedToAddress = entry.getValue();
                try {
                    log.tracef("For m/r task %s migrating intermediate keys %s to %s", taskId, keysHashedToAddress, entry.getKey());
                    for (KOut key : keysHashedToAddress) {
                        List<VOut> value = collectedValues.get(key);
                        DeltaAwareList<List<VOut>> delta = new DeltaAwareList<List<VOut>>(value);
                        if (emitCompositeIntermediateKeys) {
                            tmpCache.put(new IntermediateCompositeKey<KOut>(taskId, key), delta);
                        } else {
                            tmpCache.put(key, delta);
                        }
                        mapPhaseKeys.add(key);
                    }
                }
                catch (Exception exception) {
                    throw new CacheException("Could not move intermediate keys/values for M/R task " + taskId, (Throwable)exception);
                    return mapPhaseKeys;
                }
            }
        }
        finally {
            if (log.isTraceEnabled()) {
                log.tracef("Migrating keys for task %s took %s milliseconds (Migrated %s keys)", mcc.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS), mapPhaseKeys.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <KIn, VIn, KOut, VOut> Map<KOut, List<VOut>> combineForLocalReduction(MapCombineCommand<KIn, VIn, KOut, VOut> mcc, CollectableCollector<KOut, VOut> collector) {
        String taskId = mcc.getTaskId();
        Reducer<KOut, VOut> combiner = mcc.getCombiner();
        Map<KOut, List<VOut>> result = null;
        if (combiner != null) {
            result = new HashMap<KOut, List<VOut>>();
            log.tracef("For m/r task %s invoking combiner %s at %s", taskId, mcc, this.cdl.getAddress());
            MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
            long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
            try {
                Cache cache = this.cacheManager.getCache(mcc.getCacheName());
                taskLifecycleService.onPreExecute(combiner, cache);
                Map<KOut, List<VOut>> collectedValues = collector.collectedValues();
                for (Map.Entry<KOut, List<VOut>> e : collectedValues.entrySet()) {
                    List<VOut> list = e.getValue();
                    LinkedList<VOut> l = new LinkedList<VOut>();
                    VOut combined = list.size() > 1 ? combiner.reduce(e.getKey(), list.iterator()) : list.get(0);
                    l.add(combined);
                    result.put(e.getKey(), l);
                    log.tracef("For m/r task %s combined %s to %s at %s", new Object[]{taskId, e.getKey(), combined, this.cdl.getAddress()});
                }
            }
            finally {
                if (log.isTraceEnabled()) {
                    log.tracef("Combine for task %s took %s milliseconds", mcc.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS));
                }
                taskLifecycleService.onPostExecute(combiner);
            }
        } else {
            result = collector.collectedValues();
        }
        return result;
    }

    private boolean checkInterrupt(int counter) {
        return counter % 20 == 0;
    }

    protected <KIn> Set<KIn> loadAllKeysFromCacheLoaderUsingFilter(Set<KIn> filterOutSet) {
        Set<Object> keysInCL = InfinispanCollections.emptySet();
        CacheLoader cl = this.resolveCacheLoader();
        if (cl != null) {
            try {
                keysInCL = cl.loadAllKeys(filterOutSet);
            }
            catch (CacheLoaderException e) {
                throw new CacheException("Could not load key/value entries from cacheloader", (Throwable)e);
            }
        }
        return keysInCL;
    }

    protected <KIn, KOut> KOut loadValueFromCacheLoader(KIn key) {
        Object value = null;
        CacheLoader cl = this.resolveCacheLoader();
        if (cl != null) {
            try {
                InternalCacheEntry entry = cl.load(key);
                if (entry != null) {
                    Object loadedValue = entry.getValue();
                    value = loadedValue instanceof MarshalledValue ? ((MarshalledValue)loadedValue).get() : loadedValue;
                }
            }
            catch (CacheLoaderException e) {
                throw new CacheException("Could not load key/value entries from cacheloader", (Throwable)e);
            }
        }
        return (KOut)value;
    }

    protected CacheLoader resolveCacheLoader() {
        CacheLoader cl = null;
        if (this.cacheLoaderManager != null && this.cacheLoaderManager.isEnabled()) {
            cl = this.cacheLoaderManager.getCacheLoader();
        }
        return cl;
    }

    @Override
    public <T> Map<Address, List<T>> mapKeysToNodes(DistributionManager dm, String taskId, Collection<T> keysToMap, boolean useIntermediateCompositeKey) {
        HashMap<Address, List<T>> addressToKey = new HashMap<Address, List<T>>();
        for (T key : keysToMap) {
            Address ownerOfKey = null;
            ownerOfKey = useIntermediateCompositeKey ? dm.getPrimaryLocation(new IntermediateCompositeKey<T>(taskId, key)) : dm.getPrimaryLocation(key);
            ArrayList<T> keysAtNode = (ArrayList<T>)addressToKey.get(ownerOfKey);
            if (keysAtNode == null) {
                keysAtNode = new ArrayList<T>();
                addressToKey.put(ownerOfKey, keysAtNode);
            }
            keysAtNode.add(key);
        }
        return addressToKey;
    }

    protected <KIn> Set<KIn> filterLocalPrimaryOwner(Set<KIn> nodeLocalKeys, DistributionManager dm) {
        HashSet<KIn> selectedKeys = new HashSet<KIn>();
        for (KIn key : nodeLocalKeys) {
            Address primaryLocation = dm != null ? dm.getPrimaryLocation(key) : this.cdl.getAddress();
            if (primaryLocation == null || !primaryLocation.equals(this.cdl.getAddress())) continue;
            selectedKeys.add(key);
        }
        return selectedKeys;
    }

    public static final class IntermediateCompositeKey<V>
    implements Serializable {
        private static final long serialVersionUID = 4434717760740027918L;
        private final String taskId;
        private final V key;

        public IntermediateCompositeKey(String taskId, V key) {
            this.taskId = taskId;
            this.key = key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IntermediateCompositeKey)) {
                return false;
            }
            IntermediateCompositeKey other = (IntermediateCompositeKey)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId));
        }

        public String toString() {
            return "IntermediateCompositeKey [taskId=" + this.taskId + ", key=" + this.key + "]";
        }
    }

    private static class DeltaAwareList<E>
    extends LinkedList<E>
    implements DeltaAware,
    Delta {
        private static final long serialVersionUID = 2176345973026460708L;

        public DeltaAwareList(Collection<? extends E> c) {
            super(c);
        }

        public DeltaAwareList(E reducedObject) {
            this.add(reducedObject);
        }

        @Override
        public Delta delta() {
            return new DeltaAwareList<DeltaAwareList>(this);
        }

        @Override
        public void commit() {
            this.clear();
        }

        @Override
        public DeltaAware merge(DeltaAware d) {
            List other = null;
            if (d != null && d instanceof DeltaAwareList) {
                other = (List)((Object)d);
                for (Object e : this) {
                    other.add(e);
                }
                return (DeltaAware)((Object)other);
            }
            return this;
        }
    }

    private static interface CollectableCollector<K, V>
    extends Collector<K, V> {
        public Map<K, List<V>> collectedValues();
    }

    private static class DefaultCollector<KOut, VOut>
    implements CollectableCollector<KOut, VOut> {
        private final Map<KOut, List<VOut>> store = CollectionFactory.makeConcurrentMap();

        private DefaultCollector() {
        }

        @Override
        public void emit(KOut key, VOut value) {
            List<VOut> list = this.store.get(key);
            if (list == null) {
                list = new LinkedList<VOut>();
                this.store.put(key, list);
            }
            list.add(value);
        }

        @Override
        public Map<KOut, List<VOut>> collectedValues() {
            return this.store;
        }
    }
}

