/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.infinispan.distribution.DataLocality;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="DistributionManager", description="Component that handles distribution of content across a cluster")
public class DistributionManagerImpl
implements DistributionManager {
    private static final Log log = LogFactory.getLog(DistributionManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private RpcManager rpcManager;
    private StateTransferManager stateTransferManager;

    @Inject
    public void init(RpcManager rpcManager, StateTransferManager stateTransferManager) {
        this.rpcManager = rpcManager;
        this.stateTransferManager = stateTransferManager;
    }

    @Start(priority=20)
    private void start() throws Exception {
        if (trace) {
            log.tracef("starting distribution manager on %s", this.getAddress());
        }
    }

    private Address getAddress() {
        return this.rpcManager.getAddress();
    }

    @Override
    @Deprecated
    public boolean isLocal(Object key) {
        return this.getLocality(key).isLocal();
    }

    @Override
    public DataLocality getLocality(Object key) {
        boolean local;
        boolean transferInProgress = this.stateTransferManager.isStateTransferInProgressForKey(key);
        CacheTopology topology = this.stateTransferManager.getCacheTopology();
        boolean bl = local = topology == null || topology.getWriteConsistentHash().isKeyLocalToNode(this.getAddress(), key);
        if (transferInProgress) {
            if (local) {
                return DataLocality.LOCAL_UNCERTAIN;
            }
            return DataLocality.NOT_LOCAL_UNCERTAIN;
        }
        if (local) {
            return DataLocality.LOCAL;
        }
        return DataLocality.NOT_LOCAL;
    }

    @Override
    public List<Address> locate(Object key) {
        return this.getConsistentHash().locateOwners(key);
    }

    @Override
    public Address getPrimaryLocation(Object key) {
        return this.getConsistentHash().locatePrimaryOwner(key);
    }

    @Override
    public Set<Address> locateAll(Collection<Object> keys) {
        return this.getConsistentHash().locateAllOwners(keys);
    }

    @Override
    public ConsistentHash getConsistentHash() {
        return this.getWriteConsistentHash();
    }

    @Override
    public ConsistentHash getReadConsistentHash() {
        return this.stateTransferManager.getCacheTopology().getReadConsistentHash();
    }

    @Override
    public ConsistentHash getWriteConsistentHash() {
        return this.stateTransferManager.getCacheTopology().getWriteConsistentHash();
    }

    @Override
    @ManagedOperation(description="Determines whether a given key is affected by an ongoing rehash, if any.", displayName="Could key be affected by rehash?")
    public boolean isAffectedByRehash(@Parameter(name="key", description="Key to check") Object key) {
        return this.stateTransferManager.isStateTransferInProgressForKey(key);
    }

    @Override
    public boolean isRehashInProgress() {
        return this.stateTransferManager.isStateTransferInProgress();
    }

    @Override
    public boolean isJoinComplete() {
        return this.stateTransferManager.isJoinComplete();
    }

    @ManagedOperation(description="Tells you whether a given key is local to this instance of the cache.  Only works with String keys.", displayName="Is key local?")
    public boolean isLocatedLocally(@Parameter(name="key", description="Key to query") String key) {
        return this.getLocality(key).isLocal();
    }

    @ManagedOperation(description="Locates an object in a cluster.  Only works with String keys.", displayName="Locate key")
    public List<String> locateKey(@Parameter(name="key", description="Key to locate") String key) {
        LinkedList<String> l = new LinkedList<String>();
        for (Address a : this.locate(key)) {
            l.add(a.toString());
        }
        return l;
    }
}

