/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.ReplicatedConsistentHash;
import org.infinispan.remoting.transport.Address;

public class ReplicatedConsistentHashFactory
implements ConsistentHashFactory<ReplicatedConsistentHash> {
    @Override
    public ReplicatedConsistentHash create(Hash hashFunction, int numOwners, int numSegments, List<Address> members) {
        int[] primaryOwners = new int[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            primaryOwners[i] = i % members.size();
        }
        return new ReplicatedConsistentHash(hashFunction, members, primaryOwners);
    }

    @Override
    public ReplicatedConsistentHash updateMembers(ReplicatedConsistentHash baseCH, List<Address> newMembers) {
        if (newMembers.equals(baseCH.getMembers())) {
            return baseCH;
        }
        int numSegments = baseCH.getNumSegments();
        int[] primaryOwners = new int[numSegments];
        int[] nodeUsage = new int[newMembers.size()];
        boolean foundOrphanSegments = false;
        for (int segmentId = 0; segmentId < numSegments; ++segmentId) {
            int primaryOwnerIndex;
            Address primaryOwner = baseCH.locatePrimaryOwnerForSegment(segmentId);
            primaryOwners[segmentId] = primaryOwnerIndex = newMembers.indexOf(primaryOwner);
            if (primaryOwnerIndex == -1) {
                foundOrphanSegments = true;
                continue;
            }
            int n = primaryOwnerIndex;
            nodeUsage[n] = nodeUsage[n] + 1;
        }
        if (foundOrphanSegments) {
            for (int i = 0; i < numSegments; ++i) {
                int leastUsed;
                if (primaryOwners[i] != -1) continue;
                primaryOwners[i] = leastUsed = this.findLeastUsedNode(nodeUsage);
                int n = leastUsed;
                nodeUsage[n] = nodeUsage[n] + 1;
            }
        }
        int minSegmentsPerNode = numSegments / newMembers.size();
        Queue[] segmentsByNode = new Queue[newMembers.size()];
        for (int segmentId = 0; segmentId < primaryOwners.length; ++segmentId) {
            int owner = primaryOwners[segmentId];
            ArrayDeque<Integer> segments = segmentsByNode[owner];
            if (segments == null) {
                segmentsByNode[owner] = segments = new ArrayDeque<Integer>(minSegmentsPerNode);
            }
            segments.add(segmentId);
        }
        int mostUsedNode = 0;
        for (int node = 0; node < nodeUsage.length; ++node) {
            while (nodeUsage[node] < minSegmentsPerNode) {
                if (nodeUsage[mostUsedNode] <= minSegmentsPerNode + 1) {
                    mostUsedNode = this.findMostUsedNode(nodeUsage);
                }
                int segmentId = (Integer)segmentsByNode[mostUsedNode].poll();
                primaryOwners[segmentId] = node;
                int n = mostUsedNode;
                nodeUsage[n] = nodeUsage[n] - 1;
                int n2 = node;
                nodeUsage[n2] = nodeUsage[n2] + 1;
            }
        }
        return new ReplicatedConsistentHash(baseCH.getHashFunction(), newMembers, primaryOwners);
    }

    private int findLeastUsedNode(int[] nodeUsage) {
        int res = 0;
        for (int node = 1; node < nodeUsage.length; ++node) {
            if (nodeUsage[node] >= nodeUsage[res]) continue;
            res = node;
        }
        return res;
    }

    private int findMostUsedNode(int[] nodeUsage) {
        int res = 0;
        for (int node = 1; node < nodeUsage.length; ++node) {
            if (nodeUsage[node] <= nodeUsage[res]) continue;
            res = node;
        }
        return res;
    }

    @Override
    public ReplicatedConsistentHash rebalance(ReplicatedConsistentHash baseCH) {
        return baseCH;
    }

    @Override
    public ReplicatedConsistentHash union(ReplicatedConsistentHash ch1, ReplicatedConsistentHash ch2) {
        if (!ch1.getHashFunction().equals(ch2.getHashFunction())) {
            throw new IllegalArgumentException("The consistent hash objects must have the same hash function");
        }
        if (ch1.getNumSegments() != ch2.getNumSegments()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of segments");
        }
        ArrayList<Address> unionMembers = new ArrayList<Address>(ch1.getMembers());
        for (Address member : ch2.getMembers()) {
            if (unionMembers.contains(member)) continue;
            unionMembers.add(member);
        }
        int[] primaryOwners = new int[ch1.getNumSegments()];
        for (int segmentId = 0; segmentId < primaryOwners.length; ++segmentId) {
            int primaryOwnerIndex;
            Address primaryOwner = ch1.locatePrimaryOwnerForSegment(segmentId);
            primaryOwners[segmentId] = primaryOwnerIndex = unionMembers.indexOf(primaryOwner);
        }
        return new ReplicatedConsistentHash(ch1.getHashFunction(), unionMembers, primaryOwners);
    }

    public static class Externalizer
    extends AbstractExternalizer<ReplicatedConsistentHashFactory> {
        public void writeObject(ObjectOutput output, ReplicatedConsistentHashFactory chf) {
        }

        public ReplicatedConsistentHashFactory readObject(ObjectInput unmarshaller) {
            return new ReplicatedConsistentHashFactory();
        }

        public Integer getId() {
            return 92;
        }

        public Set<Class<? extends ReplicatedConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(ReplicatedConsistentHashFactory.class);
        }
    }
}

