/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.loaders.manager.CacheLoaderManager;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class EvictionManagerImpl
implements EvictionManager {
    private static final Log log = LogFactory.getLog(EvictionManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    ScheduledFuture<?> evictionTask;
    private ScheduledExecutorService executor;
    private Configuration configuration;
    private CacheLoaderManager cacheLoaderManager;
    private DataContainer dataContainer;
    private CacheStore cacheStore;
    private CacheNotifier cacheNotifier;
    private TimeService timeService;
    private boolean enabled;
    private String cacheName;

    @Inject
    public void initialize(@ComponentName(value="org.infinispan.executors.eviction") ScheduledExecutorService executor, Cache cache, Configuration cfg, DataContainer dataContainer, CacheLoaderManager cacheLoaderManager, CacheNotifier cacheNotifier, TimeService timeService) {
        this.initialize(executor, cache.getName(), cfg, dataContainer, cacheLoaderManager, cacheNotifier, timeService);
    }

    void initialize(ScheduledExecutorService executor, String cacheName, Configuration cfg, DataContainer dataContainer, CacheLoaderManager cacheLoaderManager, CacheNotifier cacheNotifier, TimeService timeService) {
        this.executor = executor;
        this.configuration = cfg;
        this.cacheName = cacheName;
        this.dataContainer = dataContainer;
        this.cacheLoaderManager = cacheLoaderManager;
        this.cacheNotifier = cacheNotifier;
        this.timeService = timeService;
    }

    @Start(priority=55)
    public void start() {
        this.enabled = this.configuration.expiration().reaperEnabled();
        if (this.enabled) {
            long expWakeUpInt;
            if (this.cacheLoaderManager != null && this.cacheLoaderManager.isEnabled()) {
                this.cacheStore = this.cacheLoaderManager.getCacheStore();
            }
            if ((expWakeUpInt = this.configuration.expiration().wakeUpInterval()) <= 0L) {
                log.notStartingEvictionThread();
            } else {
                this.evictionTask = this.executor.scheduleWithFixedDelay(new ScheduledTask(), expWakeUpInt, expWakeUpInt, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void processEviction() {
        long start = 0L;
        if (!Thread.currentThread().isInterrupted()) {
            try {
                if (trace) {
                    log.trace("Purging data container of expired entries");
                    start = this.timeService.time();
                }
                this.dataContainer.purgeExpired();
                if (trace) {
                    log.tracef("Purging data container completed in %s", Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
                }
            }
            catch (Exception e) {
                log.exceptionPurgingDataContainer(e);
            }
        }
        if (!Thread.currentThread().isInterrupted() && this.cacheStore != null) {
            try {
                if (trace) {
                    log.trace("Purging cache store of expired entries");
                    start = this.timeService.time();
                }
                this.cacheStore.purgeExpired();
                if (trace) {
                    log.tracef("Purging cache store completed in %s", Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
                }
            }
            catch (Exception e) {
                log.exceptionPurgingDataContainer(e);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Stop(priority=5)
    public void stop() {
        if (this.evictionTask != null) {
            this.evictionTask.cancel(true);
        }
    }

    @Override
    public void onEntryEviction(Map<Object, InternalCacheEntry> evicted) {
        ImmutableContext ctx = ImmutableContext.INSTANCE;
        this.cacheNotifier.notifyCacheEntriesEvicted(evicted.values(), ctx, null);
    }

    class ScheduledTask
    implements Runnable {
        ScheduledTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogFactory.pushNDC(EvictionManagerImpl.this.cacheName, trace);
            try {
                EvictionManagerImpl.this.processEviction();
            }
            finally {
                LogFactory.popNDC(trace);
            }
        }
    }
}

