/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import org.infinispan.Cache;
import org.infinispan.io.FileChunkMapper;
import org.infinispan.io.GridFile;

public class ReadableGridFileChannel
implements ReadableByteChannel {
    private int position = 0;
    private int localIndex = 0;
    private byte[] currentBuffer;
    private boolean closed;
    private FileChunkMapper fileChunkMapper;
    private long fileLength;

    ReadableGridFileChannel(GridFile file, Cache<String, byte[]> cache) {
        this.fileChunkMapper = new FileChunkMapper(file, cache);
        this.fileLength = (int)file.length();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        long tbr = this.getTotalBytesRemaining();
        if (tbr == 0L) {
            return -1;
        }
        int bytesRead = 0;
        long len = Math.min((long)dst.remaining(), tbr);
        while (len > 0L) {
            int bytesReadFromChunk = this.readFromChunk(dst, len);
            len -= (long)bytesReadFromChunk;
            bytesRead += bytesReadFromChunk;
        }
        return bytesRead;
    }

    private int readFromChunk(ByteBuffer dst, long len) {
        int bytesRemaining = this.getBytesRemainingInChunk();
        if (bytesRemaining == 0) {
            this.fetchNextChunk();
            bytesRemaining = this.getBytesRemainingInChunk();
        }
        int bytesToRead = Math.min((int)len, bytesRemaining);
        dst.put(this.currentBuffer, this.localIndex, bytesToRead);
        this.position += bytesToRead;
        this.localIndex += bytesToRead;
        return bytesToRead;
    }

    private void fetchNextChunk() {
        int chunkNumber = this.getChunkNumber(this.position);
        this.currentBuffer = this.fileChunkMapper.fetchChunk(chunkNumber);
        this.localIndex = 0;
    }

    private long getTotalBytesRemaining() {
        return this.fileLength - (long)this.position;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.reset();
        this.closed = true;
    }

    public long position() throws IOException {
        this.checkOpen();
        return this.position;
    }

    public void position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("newPosition may not be negative");
        }
        this.checkOpen();
        int newPos = (int)newPosition;
        int chunkNumberOfNewPosition = this.getChunkNumber(newPos);
        if (this.getChunkNumber(this.position - 1) != chunkNumberOfNewPosition) {
            this.currentBuffer = this.fileChunkMapper.fetchChunk(chunkNumberOfNewPosition);
        }
        this.position = newPos;
        this.localIndex = newPos % this.getChunkSize();
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    public long size() throws IOException {
        return this.fileLength;
    }

    private int getChunkNumber(int position) {
        return position < 0 ? -1 : position / this.getChunkSize();
    }

    private int getChunkSize() {
        return this.fileChunkMapper.getChunkSize();
    }

    private void reset() {
        this.localIndex = 0;
        this.position = 0;
    }

    private int getBytesRemainingInChunk() {
        return this.currentBuffer == null ? 0 : this.currentBuffer.length - this.localIndex;
    }
}

