/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.decorators.AbstractDelegatingStore;
import org.infinispan.loaders.modifications.Clear;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.ModificationsList;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AsyncStore
extends AbstractDelegatingStore {
    private static final Log log = LogFactory.getLog(AsyncStore.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final AtomicInteger threadId = new AtomicInteger(0);
    private final TransactionFactory txFactory = new TransactionFactory();
    private Map<GlobalTransaction, List<? extends Modification>> transactions;
    private ExecutorService executor;
    private Thread coordinator;
    private int concurrencyLevel;
    private long shutdownTimeout;
    private String cacheName;
    private TimeService timeService;
    private BufferLock stateLock;
    @GuardedBy(value="stateLock")
    private volatile State state;
    protected AsyncStoreConfiguration asyncConfiguration;

    public AsyncStore(CacheStore delegate) {
        super(delegate);
        this.txFactory.init(false, false, false, false);
    }

    @Override
    public void init(CacheLoaderConfiguration configuration, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(configuration, cache, m);
        this.asyncConfiguration = ((CacheStoreConfiguration)configuration).async();
        Configuration cacheCfg = cache != null ? cache.getCacheConfiguration() : null;
        this.concurrencyLevel = cacheCfg != null ? cacheCfg.locking().concurrencyLevel() : 16;
        long cacheStopTimeout = cacheCfg != null ? cacheCfg.transaction().cacheStopTimeout() : 30000L;
        Long configuredAsyncStopTimeout = this.asyncConfiguration.shutdownTimeout();
        String string = this.cacheName = cache != null ? cache.getName() : null;
        if (configuredAsyncStopTimeout >= cacheStopTimeout) {
            this.shutdownTimeout = Math.round((double)cacheStopTimeout * 0.9);
            log.asyncStoreShutdownTimeoutTooHigh(configuredAsyncStopTimeout, cacheStopTimeout, this.shutdownTimeout);
        } else {
            this.shutdownTimeout = configuredAsyncStopTimeout;
        }
        this.transactions = CollectionFactory.makeConcurrentMap((int)64, (int)this.concurrencyLevel);
        this.timeService = cache.getAdvancedCache().getComponentRegistry().getTimeService();
    }

    private State newState(boolean clear, State next) {
        ConcurrentMap map = CollectionFactory.makeConcurrentMap((int)64, (int)this.concurrencyLevel);
        return new State(clear, map, next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(Modification mod, int count) {
        this.stateLock.writeLock(count);
        try {
            if (log.isTraceEnabled()) {
                log.tracef("Queue modification: %s", mod);
            }
            this.state.put(mod);
        }
        finally {
            this.stateLock.writeUnlock();
        }
    }

    @Override
    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        Modification mod = this.state.get(key);
        if (mod != null) {
            switch (mod.getType()) {
                case REMOVE: 
                case CLEAR: {
                    return null;
                }
                case STORE: {
                    InternalCacheEntry ice = ((Store)mod).getStoredEntry();
                    if (ice.isExpired(this.timeService.wallClockTime())) {
                        return null;
                    }
                    return ice;
                }
            }
        }
        return super.load(key);
    }

    @Override
    public boolean containsKey(Object key) throws CacheLoaderException {
        Modification mod = this.state.get(key);
        if (mod != null) {
            return mod.getType() == Modification.Type.STORE;
        }
        return super.containsKey(key);
    }

    private void loadKeys(State s, Set<Object> exclude, Set<Object> result) throws CacheLoaderException {
        if (!s.clear) {
            State next = s.next;
            if (next != null) {
                this.loadKeys(next, exclude, result);
            } else {
                result.addAll(super.loadAllKeys(exclude));
            }
        }
        for (Modification mod : s.modifications.values()) {
            switch (mod.getType()) {
                case STORE: {
                    Object key = ((Store)mod).getStoredEntry().getKey();
                    if (exclude != null && exclude.contains(key)) break;
                    result.add(key);
                    break;
                }
                case REMOVE: {
                    result.remove(((Remove)mod).getKey());
                }
            }
        }
    }

    @Override
    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        HashSet<Object> result = new HashSet<Object>();
        this.loadKeys(this.state, keysToExclude, result);
        return result;
    }

    @Override
    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return this.load(Integer.MAX_VALUE);
    }

    @Override
    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>();
        for (Object key : this.loadAllKeys(null)) {
            InternalCacheEntry entry = this.load(key);
            if (entry == null) continue;
            result.add(entry);
            if (result.size() != numEntries) continue;
            return result;
        }
        return result;
    }

    @Override
    public void store(InternalCacheEntry entry) {
        this.put(new Store(entry), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.stateLock.writeLock(1);
        try {
            this.state = this.newState(true, this.state.next);
        }
        finally {
            this.stateLock.reset(1);
            this.stateLock.writeUnlock();
        }
    }

    @Override
    public boolean remove(Object key) {
        this.put(new Remove(key), 1);
        return true;
    }

    @Override
    public void removeAll(Set<Object> keys) throws CacheLoaderException {
        if (keys != null && !keys.isEmpty()) {
            ArrayList<Remove> mods = new ArrayList<Remove>(keys.size());
            for (Object key : keys) {
                mods.add(new Remove(key));
            }
            this.put(new ModificationsList(mods), mods.size());
        }
    }

    @Override
    public void prepare(List<? extends Modification> mods, GlobalTransaction tx, boolean isOnePhase) throws CacheLoaderException {
        if (isOnePhase) {
            this.enqueueModificationsList(mods);
        } else {
            this.transactions.put(tx, mods);
        }
    }

    @Override
    public void rollback(GlobalTransaction tx) {
        this.transactions.remove(tx);
    }

    @Override
    public void commit(GlobalTransaction tx) throws CacheLoaderException {
        this.enqueueModificationsList(this.transactions.remove(tx));
    }

    private void enqueueModificationsList(List<? extends Modification> mods) {
        int i;
        if (mods == null || mods.isEmpty()) {
            return;
        }
        for (i = mods.size() - 1; i >= 0 && mods.get(i).getType() != Modification.Type.CLEAR; --i) {
        }
        if (i >= 0) {
            this.clear();
            mods = mods.subList(i + 1, mods.size());
        }
        if (!mods.isEmpty()) {
            this.put(new ModificationsList(mods), mods.size());
        }
    }

    @Override
    public void start() throws CacheLoaderException {
        log.debugf("Async cache loader starting %s", this);
        this.state = this.newState(false, null);
        this.stateLock = new BufferLock(this.asyncConfiguration.modificationQueueSize());
        super.start();
        int poolSize = this.asyncConfiguration.threadPoolSize();
        this.executor = new ThreadPoolExecutor(0, poolSize, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "AsyncStoreProcessor-" + AsyncStore.this.cacheName + "-" + threadId.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
        this.coordinator = new Thread((Runnable)new AsyncStoreCoordinator(), "AsyncStoreCoordinator-" + this.cacheName);
        this.coordinator.setDaemon(true);
        this.coordinator.start();
    }

    @Override
    public void stop() throws CacheLoaderException {
        if (trace) {
            log.tracef("Stop async store %s", this);
        }
        this.stateLock.writeLock(1);
        this.state.stopped = true;
        this.stateLock.writeUnlock();
        try {
            this.coordinator.join(this.shutdownTimeout);
            if (this.coordinator.isAlive()) {
                log.error("Async store executor did not stop properly");
            }
        }
        catch (InterruptedException e) {
            log.interruptedWaitingAsyncStorePush(e);
            Thread.currentThread().interrupt();
        }
        super.stop();
    }

    protected void applyModificationsSync(List<Modification> mods) throws CacheLoaderException {
        this.getDelegate().prepare(mods, this.txFactory.newGlobalTransaction(null, false), true);
    }

    private class AsyncStoreProcessor
    implements Runnable {
        private final List<Modification> modifications;
        private final State myState;

        AsyncStoreProcessor(List<Modification> modifications, State myState) {
            this.modifications = modifications;
            this.myState = myState;
        }

        @Override
        public void run() {
            this.retryWork(3);
            this.myState.workerThreads.countDown();
            if (this.myState.workerThreads.getCount() == 0L) {
                State s = AsyncStore.this.state;
                while (s != null) {
                    if (s.next == this.myState) {
                        s.next = null;
                    }
                    s = s.next;
                }
            }
        }

        private void retryWork(int maxRetries) {
            for (int attempt = 0; attempt < maxRetries; ++attempt) {
                if (attempt > 0 && log.isDebugEnabled()) {
                    log.debugf("Retrying due to previous failure. %s attempts left.", maxRetries - attempt);
                }
                try {
                    AsyncStore.this.applyModificationsSync(this.modifications);
                    return;
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Failed to process async modifications", e);
                    continue;
                }
            }
            log.unableToProcessAsyncModifications(maxRetries);
        }
    }

    private class AsyncStoreCoordinator
    implements Runnable {
        private AsyncStoreCoordinator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogFactory.pushNDC(AsyncStore.this.cacheName, trace);
            try {
                while (true) {
                    State head;
                    State tail;
                    State s;
                    if (this.shouldStop(s = AsyncStore.this.state)) {
                        return;
                    }
                    AsyncStore.this.stateLock.readLock();
                    try {
                        s = AsyncStore.this.state;
                        tail = s.next;
                        assert (tail == null || tail.next == null) : "State chain longer than 3 entries!";
                        head = AsyncStore.this.newState(false, s);
                        AsyncStore.this.state = head;
                    }
                    finally {
                        AsyncStore.this.stateLock.reset(0);
                        AsyncStore.this.stateLock.readUnlock();
                    }
                    try {
                        ArrayList<Object> mods;
                        if (s.clear) {
                            if (tail != null) {
                                this.workerThreadsAwait(tail.workerThreads);
                            }
                            AsyncStore.this.getDelegate().clear();
                        }
                        if (tail != null) {
                            mods = new ArrayList();
                            for (Map.Entry e : s.modifications.entrySet()) {
                                if (!tail.modifications.containsKey(e.getKey())) {
                                    mods.add(e.getValue());
                                    continue;
                                }
                                if (!head.clear && head.modifications.putIfAbsent(e.getKey(), e.getValue()) == null) {
                                    AsyncStore.this.stateLock.add(1);
                                }
                                s.modifications.remove(e.getKey());
                            }
                        } else {
                            mods = new ArrayList(s.modifications.values());
                        }
                        int threads = Math.min(mods.size(), AsyncStore.this.asyncConfiguration.threadPoolSize());
                        s.workerThreads = new CountDownLatch(threads);
                        if (threads > 0) {
                            int start = 0;
                            int quotient = mods.size() / threads;
                            int remainder = mods.size() % threads;
                            for (int i = 0; i < threads; ++i) {
                                int end = start + quotient + (i < remainder ? 1 : 0);
                                AsyncStore.this.executor.execute(new AsyncStoreProcessor(mods.subList(start, end), s));
                                start = end;
                            }
                            assert (start == mods.size()) : "Thread distribution is broken!";
                        }
                        if (tail != null) {
                            this.workerThreadsAwait(tail.workerThreads);
                            s.next = null;
                        }
                        if (this.shouldStop(s)) {
                            this.workerThreadsAwait(s.workerThreads);
                            return;
                        }
                    }
                    catch (InterruptedException e) {
                        log.asyncStoreCoordinatorInterrupted(e);
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        log.unexpectedErrorInAsyncStoreCoordinator(e);
                    }
                }
            }
            finally {
                try {
                    boolean workersTerminated = false;
                    try {
                        AsyncStore.this.executor.shutdown();
                        workersTerminated = AsyncStore.this.executor.awaitTermination(AsyncStore.this.shutdownTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (!workersTerminated) {
                        AsyncStore.this.executor.shutdownNow();
                    }
                }
                finally {
                    LogFactory.popNDC(trace);
                }
            }
        }

        private boolean shouldStop(State s) {
            return s.stopped && s.modifications.isEmpty();
        }

        private void workerThreadsAwait(CountDownLatch latch) throws InterruptedException {
            boolean await = latch.await(AsyncStore.this.shutdownTimeout, TimeUnit.MILLISECONDS);
            if (!await) {
                throw log.waitingForWorkerThreadsFailed(latch);
            }
        }
    }

    private static class BufferLock {
        private final Sync sync = new Sync();
        private final Counter counter;
        private final Available available;

        BufferLock(int size) {
            this.counter = size > 0 ? new Counter(size) : null;
            this.available = new Available();
        }

        void writeLock(int count) {
            if (this.counter != null) {
                this.counter.acquireShared(count);
            }
            this.sync.acquireShared(1);
        }

        void writeUnlock() {
            this.sync.releaseShared(1);
            this.available.releaseShared(1);
        }

        void readLock() {
            this.available.acquireShared(1);
            this.sync.acquire(1);
        }

        void readUnlock() {
            this.sync.release(1);
        }

        void reset(int count) {
            if (this.counter != null) {
                this.counter.releaseShared(count);
            }
            this.available.releaseShared(count);
        }

        void add(int count) {
            if (this.counter != null) {
                count = this.counter.add(count);
            }
            this.available.releaseShared(count);
        }

        private static class Sync
        extends AbstractQueuedSynchronizer {
            private static final long serialVersionUID = 2983687000985096017L;

            private Sync() {
            }

            @Override
            protected boolean tryAcquire(int unused) {
                if (!this.compareAndSetState(0, -1)) {
                    return false;
                }
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }

            @Override
            protected boolean tryRelease(int unused) {
                this.setExclusiveOwnerThread(null);
                this.setState(0);
                return true;
            }

            @Override
            protected int tryAcquireShared(int unused) {
                int state;
                do {
                    if ((state = this.getState()) >= 0) continue;
                    return -1;
                } while (!this.compareAndSetState(state, state + 1));
                return 1;
            }

            @Override
            protected boolean tryReleaseShared(int unused) {
                int state;
                while (!this.compareAndSetState(state = this.getState(), state - 1)) {
                }
                return true;
            }
        }

        private static class Available
        extends AbstractQueuedSynchronizer {
            private static final long serialVersionUID = 6464514100313353749L;

            private Available() {
            }

            @Override
            protected int tryAcquireShared(int unused) {
                return this.getState() > 0 ? 1 : -1;
            }

            @Override
            protected boolean tryReleaseShared(int state) {
                this.setState(state > 0 ? 1 : 0);
                return state > 0;
            }
        }

        private static class Counter
        extends AbstractQueuedSynchronizer {
            private static final long serialVersionUID = 1688655561670368887L;
            private final int size;

            Counter(int size) {
                this.size = size;
            }

            int add(int count) {
                int state;
                while (!this.compareAndSetState(state = this.getState(), state + count)) {
                }
                return state + count;
            }

            @Override
            protected int tryAcquireShared(int count) {
                int state;
                do {
                    if ((state = this.getState()) < this.size) continue;
                    return -1;
                } while (!this.compareAndSetState(state, state + count));
                return state + count >= this.size ? 0 : 1;
            }

            @Override
            protected boolean tryReleaseShared(int state) {
                this.setState(state);
                return state < this.size;
            }
        }
    }

    private static class State {
        private static final Clear CLEAR = new Clear();
        private final boolean clear;
        private final ConcurrentMap<Object, Modification> modifications;
        private volatile State next;
        private volatile boolean stopped = false;
        private CountDownLatch workerThreads;

        private State(boolean clear, ConcurrentMap<Object, Modification> modMap, State next) {
            this.clear = clear;
            this.modifications = modMap;
            this.next = next;
            if (next != null) {
                this.stopped = next.stopped;
            }
        }

        Modification get(Object key) {
            State state = this;
            while (state != null) {
                Modification mod = (Modification)state.modifications.get(key);
                if (mod != null) {
                    return mod;
                }
                if (state.clear) {
                    return CLEAR;
                }
                state = state.next;
            }
            return null;
        }

        void put(Modification mod) {
            if (this.stopped) {
                throw new CacheException("AsyncStore stopped; no longer accepting more entries.");
            }
            switch (mod.getType()) {
                case STORE: {
                    this.modifications.put(((Store)mod).getStoredEntry().getKey(), mod);
                    break;
                }
                case REMOVE: {
                    this.modifications.put(((Remove)mod).getKey(), mod);
                    break;
                }
                case LIST: {
                    for (Modification modification : ((ModificationsList)mod).getList()) {
                        this.put(modification);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown modification type " + (Object)((Object)mod.getType()));
                }
            }
        }
    }
}

