/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.notifications.IncorrectListenerException;
import org.infinispan.notifications.Listener;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;

public abstract class AbstractListenerImpl {
    protected final Map<Class<? extends Annotation>, List<ListenerInvocation>> listenersMap = new HashMap<Class<? extends Annotation>, List<ListenerInvocation>>(16, 0.99f);
    protected ExecutorService syncProcessor;
    protected ExecutorService asyncProcessor;

    @Inject
    void injectExecutor(@ComponentName(value="org.infinispan.executors.notification") ExecutorService executor) {
        this.asyncProcessor = executor;
    }

    @Start(priority=9)
    public void start() {
        this.syncProcessor = new WithinThreadExecutor();
    }

    @Stop(priority=99)
    void stop() {
        for (List<ListenerInvocation> list : this.listenersMap.values()) {
            if (list == null) continue;
            list.clear();
        }
        if (this.syncProcessor != null) {
            this.syncProcessor.shutdownNow();
        }
    }

    protected abstract Log getLog();

    protected abstract Map<Class<? extends Annotation>, Class<?>> getAllowedMethodAnnotations();

    protected List<ListenerInvocation> getListenerCollectionForAnnotation(Class<? extends Annotation> annotation) {
        List<ListenerInvocation> list = this.listenersMap.get(annotation);
        if (list == null) {
            throw new CacheException("Unknown listener annotation: " + annotation);
        }
        return list;
    }

    public void removeListener(Object listener) {
        for (Class<? extends Annotation> annotation : this.getAllowedMethodAnnotations().keySet()) {
            this.removeListenerInvocation(annotation, listener);
        }
    }

    private void removeListenerInvocation(Class<? extends Annotation> annotation, Object listener) {
        if (listener == null) {
            return;
        }
        List<ListenerInvocation> l = this.getListenerCollectionForAnnotation(annotation);
        HashSet<ListenerInvocation> markedForRemoval = new HashSet<ListenerInvocation>(4);
        for (ListenerInvocation li : l) {
            if (!listener.equals(li.target)) continue;
            markedForRemoval.add(li);
        }
        l.removeAll(markedForRemoval);
    }

    public void addListener(Object listener) {
        this.addListener(listener, null);
    }

    public void addListener(Object listener, ClassLoader classLoader) {
        this.validateAndAddListenerInvocation(listener, classLoader);
    }

    public Set<Object> getListeners() {
        HashSet<Object> result = new HashSet<Object>(this.listenersMap.size());
        for (List<ListenerInvocation> list : this.listenersMap.values()) {
            for (ListenerInvocation li : list) {
                result.add(li.target);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private void validateAndAddListenerInvocation(Object listener, ClassLoader classLoader) {
        boolean sync = AbstractListenerImpl.testListenerClassValidity(listener.getClass());
        boolean foundMethods = false;
        Map<Class<Annotation>, Class<?>> allowedListeners = this.getAllowedMethodAnnotations();
        for (Method m : listener.getClass().getMethods()) {
            for (Map.Entry<Class<Annotation>, Class<?>> annotationEntry : allowedListeners.entrySet()) {
                Class<? extends Annotation> key = annotationEntry.getKey();
                Class<?> value = annotationEntry.getValue();
                if (!m.isAnnotationPresent(key)) continue;
                AbstractListenerImpl.testListenerMethodValidity(m, value, key.getName());
                this.addListenerInvocation(key, new ListenerInvocation(listener, m, sync, classLoader));
                foundMethods = true;
            }
        }
        if (!foundMethods) {
            this.getLog().noAnnotateMethodsFoundInListener(listener.getClass());
        }
    }

    private void addListenerInvocation(Class<? extends Annotation> annotation, ListenerInvocation li) {
        List<ListenerInvocation> result = this.getListenerCollectionForAnnotation(annotation);
        result.add(li);
    }

    protected static boolean testListenerClassValidity(Class<?> listenerClass) {
        Listener l = (Listener)ReflectionUtil.getAnnotation(listenerClass, Listener.class);
        if (l == null) {
            throw new IncorrectListenerException(String.format("Cache listener class %s must be annotated with org.infinispan.notifications.annotation.Listener", listenerClass.getName()));
        }
        if (!Modifier.isPublic(listenerClass.getModifiers())) {
            throw new IncorrectListenerException(String.format("Cache listener class %s must be public!", listenerClass.getName()));
        }
        return l.sync();
    }

    protected static void testListenerMethodValidity(Method m, Class<?> allowedParameter, String annotationName) {
        if (m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(allowedParameter)) {
            throw new IncorrectListenerException("Methods annotated with " + annotationName + " must accept exactly one parameter, of assignable from type " + allowedParameter.getName());
        }
        if (!m.getReturnType().equals(Void.TYPE)) {
            throw new IncorrectListenerException("Methods annotated with " + annotationName + " should have a return type of void.");
        }
    }

    private Throwable getRealException(Throwable re) {
        if (re.getCause() == null) {
            return re;
        }
        Throwable cause = re.getCause();
        if (cause instanceof CacheException || cause instanceof RuntimeException) {
            return this.getRealException(cause);
        }
        return re;
    }

    static ClassLoader setContextClassLoader(final ClassLoader loader) {
        PrivilegedAction<ClassLoader> action = new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(loader);
                return contextClassLoader;
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected class ListenerInvocation {
        public final Object target;
        public final Method method;
        public final boolean sync;
        public final WeakReference<ClassLoader> classLoader;

        public ListenerInvocation(Object target, Method method, boolean sync, ClassLoader classLoader) {
            this.target = target;
            this.method = method;
            this.sync = sync;
            this.classLoader = new WeakReference<ClassLoader>(classLoader);
        }

        public void invoke(final Object event) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ClassLoader contextClassLoader = null;
                    if (ListenerInvocation.this.classLoader != null && ListenerInvocation.this.classLoader.get() != null) {
                        contextClassLoader = AbstractListenerImpl.setContextClassLoader((ClassLoader)ListenerInvocation.this.classLoader.get());
                    }
                    try {
                        ListenerInvocation.this.method.invoke(ListenerInvocation.this.target, event);
                    }
                    catch (InvocationTargetException exception) {
                        Throwable cause = AbstractListenerImpl.this.getRealException(exception);
                        if (ListenerInvocation.this.sync) {
                            throw new CacheException(String.format("Caught exception [%s] while invoking method [%s] on listener instance: %s", cause.getClass().getName(), ListenerInvocation.this.method, ListenerInvocation.this.target), cause);
                        }
                        AbstractListenerImpl.this.getLog().unableToInvokeListenerMethod(ListenerInvocation.this.method, ListenerInvocation.this.target, cause);
                    }
                    catch (IllegalAccessException exception) {
                        AbstractListenerImpl.this.getLog().unableToInvokeListenerMethod(ListenerInvocation.this.method, ListenerInvocation.this.target, exception);
                        AbstractListenerImpl.this.removeListener(ListenerInvocation.this.target);
                    }
                    finally {
                        if (ListenerInvocation.this.classLoader != null && ListenerInvocation.this.classLoader.get() != null) {
                            AbstractListenerImpl.setContextClassLoader(contextClassLoader);
                        }
                    }
                }
            };
            if (this.sync) {
                AbstractListenerImpl.this.syncProcessor.execute(r);
            } else {
                AbstractListenerImpl.this.asyncProcessor.execute(r);
            }
        }
    }
}

