/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jgroups.Address;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Digest
implements Streamable,
Iterable<Entry> {
    protected Address[] members;
    protected long[] seqnos;

    public Digest() {
    }

    public Digest(Address[] members, long[] seqnos) {
        if (members == null) {
            throw new IllegalArgumentException("members is null");
        }
        if (seqnos == null) {
            throw new IllegalArgumentException("seqnos is null");
        }
        this.members = members;
        this.seqnos = seqnos;
        this.checkPostcondition();
    }

    public Digest(Address[] members) {
        if (members == null) {
            throw new IllegalArgumentException("members is null");
        }
        this.members = members;
    }

    public Digest(Digest digest) {
        if (digest == null) {
            return;
        }
        this.members = digest.members;
        this.seqnos = digest instanceof MutableDigest || this instanceof MutableDigest ? Arrays.copyOf(digest.seqnos, digest.seqnos.length) : digest.seqnos;
        this.checkPostcondition();
    }

    public Digest(Map<Address, long[]> map) {
        this.createArrays(map);
        this.checkPostcondition();
    }

    public Digest(Address sender, long highest_delivered, long highest_received) {
        this.members = new Address[]{sender};
        this.seqnos = new long[]{highest_delivered, highest_received};
    }

    public Address[] getMembersRaw() {
        return this.members;
    }

    public int capacity() {
        return this.members != null ? this.members.length : 0;
    }

    public boolean contains(Address mbr) {
        if (mbr == null || this.members == null) {
            return false;
        }
        for (Address member : this.members) {
            if (member == null || !member.equals(mbr)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Address ... members) {
        for (Address member : members) {
            if (this.contains(member)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Digest other = (Digest)obj;
        return Arrays.equals(this.members, other.members) && Arrays.equals(this.seqnos, other.seqnos);
    }

    public long[] get(Address member) {
        int index = this.find(member);
        if (index < 0) {
            return null;
        }
        return new long[]{this.seqnos[index * 2], this.seqnos[index * 2 + 1]};
    }

    @Override
    public Iterator<Entry> iterator() {
        return new MyIterator();
    }

    public Digest copy() {
        return new Digest(this.members, Arrays.copyOf(this.seqnos, this.seqnos.length));
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        this.writeTo(out, true);
    }

    public void writeTo(DataOutput out, boolean write_addrs) throws Exception {
        if (write_addrs) {
            Util.writeAddresses(this.members, out);
        } else {
            out.writeShort(this.members.length);
        }
        for (int i = 0; i < this.capacity(); ++i) {
            Util.writeLongSequence(this.seqnos[i * 2], this.seqnos[i * 2 + 1], out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.readFrom(in, true);
    }

    public void readFrom(DataInput in, boolean read_addrs) throws Exception {
        if (read_addrs) {
            this.members = Util.readAddresses(in);
            this.seqnos = new long[this.capacity() * 2];
        } else {
            this.seqnos = new long[in.readShort() * 2];
        }
        for (int i = 0; i < this.seqnos.length / 2; ++i) {
            long[] tmp = Util.readLongSequence(in);
            this.seqnos[i * 2] = tmp[0];
            this.seqnos[i * 2 + 1] = tmp[1];
        }
    }

    public long serializedSize(boolean with_members) {
        long retval = with_members ? Util.size(this.members) : 2L;
        for (int i = 0; i < this.members.length; ++i) {
            retval += (long)Util.size(this.seqnos[i * 2], this.seqnos[i * 2 + 1]);
        }
        return retval;
    }

    public String toString() {
        return this.toString(this.members, true);
    }

    public String toString(Digest order) {
        return order != null ? this.toString(order.members, true) : this.toString(this.members, true);
    }

    public String toString(Address[] order, boolean print_highest_received) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.capacity() == 0) {
            return "[]";
        }
        int count = 0;
        int capacity = this.capacity();
        for (Address key : order) {
            long[] tmp_seqnos;
            long[] lArray = tmp_seqnos = key != null ? this.get(key) : null;
            if (key == null || tmp_seqnos == null) continue;
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key).append(": ").append('[').append(tmp_seqnos[0]);
            if (print_highest_received) {
                sb.append(" (").append(tmp_seqnos[1]).append(")");
            }
            sb.append("]");
            if (Util.MAX_LIST_PRINT_SIZE <= 0 || ++count < Util.MAX_LIST_PRINT_SIZE) continue;
            if (capacity <= count) break;
            sb.append(", ...");
            break;
        }
        return sb.toString();
    }

    protected int find(Address mbr) {
        if (mbr == null || this.members == null) {
            return -1;
        }
        for (int i = 0; i < this.members.length; ++i) {
            Address member = this.members[i];
            if (member == null || !member.equals(mbr)) continue;
            return i;
        }
        return -1;
    }

    protected void createArrays(Map<Address, long[]> map) {
        int size = map.size();
        this.members = new Address[size];
        this.seqnos = new long[size * 2];
        int index = 0;
        for (Map.Entry<Address, long[]> entry : map.entrySet()) {
            this.members[index] = entry.getKey();
            this.seqnos[index * 2] = entry.getValue()[0];
            this.seqnos[index * 2 + 1] = entry.getValue()[1];
            ++index;
        }
    }

    protected void checkPostcondition() {
        int size = this.members.length;
        if (size * 2 != this.seqnos.length) {
            throw new IllegalArgumentException("seqnos.length (" + this.seqnos.length + ") is not twice the members size (" + size + ")");
        }
    }

    public static class Entry {
        protected final Address member;
        protected final long highest_delivered;
        protected final long highest_received;

        public Entry(Address member, long highest_delivered, long highest_received) {
            this.member = member;
            this.highest_delivered = highest_delivered;
            this.highest_received = highest_received;
        }

        public Address getMember() {
            return this.member;
        }

        public long getHighestDeliveredSeqno() {
            return this.highest_delivered;
        }

        public long getHighestReceivedSeqno() {
            return this.highest_received;
        }

        public long getHighest() {
            return Math.max(this.highest_delivered, this.highest_received);
        }

        public String toString() {
            return this.member + ": [" + this.highest_delivered + " (" + this.highest_received + ")]";
        }
    }

    protected class MyIterator
    implements Iterator<Entry> {
        protected int index;

        protected MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Digest.this.capacity();
        }

        @Override
        public Entry next() {
            if (this.index >= Digest.this.capacity()) {
                throw new NoSuchElementException("index=" + this.index + ", capacity=" + Digest.this.capacity());
            }
            Address mbr = Digest.this.members != null ? Digest.this.members[this.index] : null;
            long hd = Digest.this.seqnos != null ? Digest.this.seqnos[this.index * 2] : 0L;
            long hr = Digest.this.seqnos != null ? Digest.this.seqnos[this.index * 2 + 1] : 0L;
            Entry entry = new Entry(mbr, hd, hr);
            ++this.index;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

