/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteServerConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationChildBuilder;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<RemoteStoreConfiguration, RemoteStoreConfigurationBuilder>
implements RemoteStoreConfigurationChildBuilder<RemoteStoreConfigurationBuilder> {
    private static final Log log = (Log)LogFactory.getLog(RemoteStoreConfigurationBuilder.class, Log.class);
    private final ExecutorFactoryConfigurationBuilder asyncExecutorFactory;
    private String balancingStrategy = RoundRobinBalancingStrategy.class.getName();
    private final ConnectionPoolConfigurationBuilder connectionPool;
    private long connectionTimeout = 60000L;
    private boolean forceReturnValues;
    private boolean hotRodWrapping;
    private int keySizeEstimate = 64;
    private String marshaller;
    private boolean pingOnStartup = true;
    private String protocolVersion;
    private boolean rawValues;
    private String remoteCacheName = "___defaultcache";
    private List<RemoteServerConfigurationBuilder> servers = new ArrayList<RemoteServerConfigurationBuilder>();
    private long socketTimeout = 60000L;
    private boolean tcpNoDelay = true;
    private String transportFactory;
    private int valueSizeEstimate = 512;

    public RemoteStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
        this.asyncExecutorFactory = new ExecutorFactoryConfigurationBuilder(this);
        this.connectionPool = new ConnectionPoolConfigurationBuilder(this);
    }

    public RemoteStoreConfigurationBuilder self() {
        return this;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    @Override
    public RemoteStoreConfigurationBuilder balancingStrategy(String balancingStrategy) {
        this.balancingStrategy = balancingStrategy;
        return this;
    }

    @Override
    public ConnectionPoolConfigurationBuilder connectionPool() {
        return this.connectionPool;
    }

    @Override
    public RemoteStoreConfigurationBuilder connectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder forceReturnValues(boolean forceReturnValues) {
        this.forceReturnValues = forceReturnValues;
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder hotRodWrapping(boolean hotRodWrapping) {
        this.hotRodWrapping = hotRodWrapping;
        this.rawValues(true);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder keySizeEstimate(int keySizeEstimate) {
        this.keySizeEstimate = keySizeEstimate;
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder marshaller(String marshaller) {
        this.marshaller = marshaller;
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder marshaller(Class<? extends Marshaller> marshaller) {
        this.marshaller = marshaller.getName();
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder pingOnStartup(boolean pingOnStartup) {
        this.pingOnStartup = pingOnStartup;
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder protocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder rawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder remoteCacheName(String remoteCacheName) {
        this.remoteCacheName = remoteCacheName;
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder socketTimeout(long socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder transportFactory(String transportFactory) {
        this.transportFactory = transportFactory;
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder transportFactory(Class<? extends TransportFactory> transportFactory) {
        this.transportFactory = transportFactory.getName();
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder valueSizeEstimate(int valueSizeEstimate) {
        this.valueSizeEstimate = valueSizeEstimate;
        return this;
    }

    @Override
    public RemoteServerConfigurationBuilder addServer() {
        RemoteServerConfigurationBuilder builder = new RemoteServerConfigurationBuilder(this);
        this.servers.add(builder);
        return builder;
    }

    public RemoteStoreConfiguration create() {
        ArrayList<RemoteServerConfiguration> remoteServers = new ArrayList<RemoteServerConfiguration>();
        for (RemoteServerConfigurationBuilder server : this.servers) {
            remoteServers.add(server.create());
        }
        return new RemoteStoreConfiguration(this.purgeOnStartup, this.fetchPersistentState, this.ignoreModifications, this.async.create(), this.singletonStore.create(), this.preload, this.shared, this.properties, this.asyncExecutorFactory.create(), this.balancingStrategy, this.connectionPool.create(), this.connectionTimeout, this.forceReturnValues, this.hotRodWrapping, this.keySizeEstimate, this.marshaller, this.pingOnStartup, this.protocolVersion, this.rawValues, this.remoteCacheName, remoteServers, this.socketTimeout, this.tcpNoDelay, this.transportFactory, this.valueSizeEstimate);
    }

    public RemoteStoreConfigurationBuilder read(RemoteStoreConfiguration template) {
        this.asyncExecutorFactory.read(template.asyncExecutorFactory());
        this.balancingStrategy = template.balancingStrategy();
        this.connectionPool.read(template.connectionPool());
        this.connectionTimeout = template.connectionTimeout();
        this.forceReturnValues = template.forceReturnValues();
        this.hotRodWrapping = template.hotRodWrapping();
        this.keySizeEstimate = template.keySizeEstimate();
        this.marshaller = template.marshaller();
        this.pingOnStartup = template.pingOnStartup();
        this.protocolVersion = template.protocolVersion();
        this.rawValues = template.rawValues();
        this.remoteCacheName = template.remoteCacheName();
        this.socketTimeout = template.socketTimeout();
        this.tcpNoDelay = template.tcpNoDelay();
        this.transportFactory = template.transportFactory();
        this.valueSizeEstimate = template.valueSizeEstimate();
        for (RemoteServerConfiguration server : template.servers()) {
            this.addServer().host(server.host()).port(server.port());
        }
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this;
    }

    public void validate() {
        this.connectionPool.validate();
        this.asyncExecutorFactory.validate();
        for (RemoteServerConfigurationBuilder server : this.servers) {
            server.validate();
        }
        if (this.hotRodWrapping && this.marshaller != null) {
            throw log.cannotEnableHotRodWrapping();
        }
    }
}

